/*
 * thread.hh
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __THREAD_HH__
#define __THREAD_HH__

#include <glibmm/thread.h>
#include "dispatcher.hh"

// TODO: If we quit the main event loop, We won't really quit unless all the threads
// are terminated ?
class Thread {
public:
  explicit Thread(const sigc::slot<void>&, Dispatcher *);
  ~Thread();
  bool ok(std::string&);
private:
  Dispatcher *dispatcher;
  Glib::Thread *thread;
  Glib::RefPtr<Glib::MainLoop> loop;
  void thread_done() { loop->quit(); }
  std::string error;
};

#endif /* __THREAD_HH__ */
