#include <iostream>

#include "sockets_glue.h"
#include "Heap.h"
#include "VM.h"
#include "stdfuns.h"
#include "KayaAPI.h"

KArray do_socketpair() 
{
  int sv[2];
  socketpair(PF_UNIX,SOCK_STREAM,0,&sv[0]);
  KArray arr = newKayaArray(2);
  KayaArrayPush(arr,KayaPtr((void*)sv[0]));
  KayaArrayPush(arr,KayaPtr((void*)sv[1]));
  return arr;
}

void do_closesocket(void* sptr) {
  close((kint)sptr);
}

void do_socketsend(void* vmptr, void* sptr, wchar_t* msg) {
    char* data = CSTRING(msg);
    VMState* vm = (VMState*)vmptr;
    int rlen;
    do {
        rlen = send((kint)sptr, data,strlen(data),0);
    } while (errno == EINTR);
    if (rlen<0) {
	vm->kaya_internalError(0);
    }
}

void do_socketsendchars(void* vmptr, void* sptr, void* data, int len) {
    VMState* vm = (VMState*)vmptr;
    int rlen;
    do {
        rlen = send((kint)sptr, (char*)data,len,0);
    } while (errno == EINTR);
    if (rlen<0) {
	vm->kaya_internalError(0);
    }
}

void do_socketsendbyte(void* vmptr, void* sptr, kint byte) {
    char data[2];
    data[0] = (char)byte;
    VMState* vm = (VMState*)vmptr;
    int rlen;
    do {
        rlen = send((kint)sptr, &data[0],1,0);
    } while (errno == EINTR);
    if (rlen<0) {
	vm->kaya_internalError(0);
    }
}

wchar_t* do_socketrecv(void* vmptr, void* sptr, KayaValue len) {
    VMState* vm = (VMState*)vmptr;
    int lenval = KayaGetInt(len);
    char* buf = (char*)GC_MALLOC_ATOMIC((lenval+1)*sizeof(char));
    int rlen;
    do {
        rlen = recv((kint)sptr, buf,lenval,0);
    } while (errno == EINTR);
    KayaSetInt(len,rlen);
    if (rlen<0) {
//	cout << rlen << endl;
//	buf[0]='\0';
	vm->kaya_internalError(1);
    }
    return KSTRING(buf);
}

void* do_socketrecvchars(void* vmptr, void* sptr, KayaValue len) {
    VMState* vm = (VMState*)vmptr;
    int lenval = KayaGetInt(len);
    char* buf = (char*)GC_MALLOC_ATOMIC((lenval+1)*sizeof(char));
    memset((void*)buf,0,(lenval+1)*sizeof(char));
    int rlen;
    do {
        rlen = recv((kint)sptr, buf,lenval,0);
    } while (errno == EINTR);
    KayaSetInt(len,rlen);
    if (rlen<0) {
//	cout << rlen << endl;
//	buf[0]='\0';
	vm->kaya_internalError(1);
    }
    return (void*)buf;
}

kint do_socketrecvbyte(void* vmptr, void* sptr) {
    VMState* vm = (VMState*)vmptr;
    char* buf = (char*)GC_MALLOC_ATOMIC(2*sizeof(char));
    int rlen;
    do {
        rlen = recv((kint)sptr, buf,1,0);
    } while (errno == EINTR);
    if (rlen<0) {
//	cout << rlen << endl;
//	buf[0]='\0';
	vm->kaya_internalError(1);
    }
    return (kint)buf[0];
}

bool do_socketpending(void* vmptr,void* conn, int timeout)
{
    VMState* vm = (VMState*)vmptr;
    kint connid = (kint)conn;
    fd_set rfds;
    struct timeval tv;
    FD_ZERO(&rfds);
    FD_SET(connid,&rfds);
    tv.tv_sec = timeout/1000000;
    tv.tv_usec = timeout%1000000;

    int rv;
    do {
        rv = select(connid+1,&rfds,NULL,NULL,&tv);
    } while (errno == EINTR);

    if (rv==-1) {
	vm->kaya_internalError(6);
    }
    else {
	return rv;
    }
}

