#ifndef _CLOSURE_H // -*-C++-*-
#define _CLOSURE_H

/**
    Kaya run-time system
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence.
*/

#ifndef WIN32
#include <pthread.h>
#define GC_THREADS
#else
#define GC_WIN32_THREADS
#endif
#include <gc/gc_cpp.h>
#include "VMState.h"
#include "Heap.h"
#include <map>

class Closure : public gc_cleanup {
public:
    // Create a closure from a function, which will have <args> as its locals,
    // and space for <arity> arguments.
    Closure(VMState* vm, func fn,kint args, kint arity, bool stack=true);
    Closure(Closure& x);
    ~Closure();

    // Run the closure. Pushes m_args onto the stack, then runs the function
    // as normal.
    void run(VMState* vm);

    func getfn() { return m_fn; }
    kint getFnID() { return ::getFnID(m_fn); }
    kint getNumArgs() { return m_numargs; }
    Value** getArgs() { return m_args; }

    void setArg(kint i,Value* v) { m_args[i]=v; }
    void addArgs(VMState* vm, kint i);

    bool eq(Closure* c,map<Value*,Value*>& done);
    Closure* copy(map<Value*, Value*>& done);

private:
    func m_fn;
    Value** m_args;
    kint m_numargs;
    kint m_arity;
};

#endif
