

import sys

from PyQt4 import QtGui, QtCore

from qt4gui import calcwindowimpl

import logging
l = logging.getLogger(__name__)

import constants

l.debug("import qt4factory")


class Qt4Factory:

    def initApp(self,control):
        l.debug("init app")
        self.myApp = QtGui.QApplication(sys.argv)
        self.control = control

    def makeMainWindow(self):
        l.debug("make main window")
        self.mainwin = calcwindowimpl.CalcWindowImpl(None, self.control)
        return self.mainwin

    def startAppLoop(self):
        self.mainwin.show()
        self.mainwin.postInitialise()
        self.myApp.exec_()

    def makeRect(self,x,y,w,h):
        return guirect(x,y,w,h)

    def getFontFactory(self):
        return FontFactory()
        
    def getScaledBracketWidth(self, spacewidth, h):
        return spacewidth*2
    
    def getIntegralWidth(self, originalWidth, h):
        return originalWidth
    
    def setWaitCursor(self):
        self.myApp.setOverrideCursor(QtCore.Qt.WaitCursor)
        
    def clearWaitCursor(self):
        self.myApp.setOverrideCursor(QtCore.Qt.ArrowCursor)

class Painter(QtGui.QPainter):

    def __init__(self, *args):
        QtGui.QPainter.__init__(self, *args)
        
    def setPenColour(self, colour):
        if colour == constants.blue:
            qtColour = QtCore.Qt.blue
        if colour == constants.black:
            qtColour = QtCore.Qt.black
        if colour == constants.white:
            qtColour = QtCore.Qt.white
        if colour == constants.red:
            qtColour = QtCore.Qt.red
            
        self.setPen(qtColour)

    def drawCharacterToFit(self, metrics, ch, x, y, w, h):

        #self.drawRect(x,y,w,h)
        chSize = metrics.charBoundingRect(ch)

        xScale = float(w)/chSize.width()
        yScale = float(h)/chSize.height()

        self.save()
        self.scale(xScale, yScale)
        self.translate( - x + x/xScale,  - y + y/yScale)
        #drawPointF = QtCore.QPointF(x+chSize.x(), y+chSize.y()+chSize.height())
        drawPointF = QtCore.QPointF(x - chSize.x(), y+chSize.y()+chSize.height())
        self.drawText(drawPointF, unicode(ch))
        self.restore()

class FontFactory:
    def __init__(self):
        pass

    def makeFont(self):
        return Font()

    def getFontMetrics(self, font):
        return FontMetrics(font)
    

class Font(QtGui.QFont):
    def __init__(self):
        QtGui.QFont.__init__(self)

    def __repr__(self):
        size = self.pointSize()
        family = self.family()
        return ("<Font (qt4) %2.1f %s>" % (size, family))
    
glyphRects = {}
def getGlyphRect(font, glyph):
    # round font size up to nearest int
    fontSize = int(font.pointSize()+0.45)
    fontFamily = font.family()
    if (fontSize, fontFamily, glyph) in glyphRects:
        return glyphRects[(fontSize, fontFamily, glyph)]
    else:
        glyphRect = calcGlyphRect(font, glyph)
        glyphRects[(fontSize, fontFamily, glyph)] = glyphRect
        return glyphRect
    
# diabolically slow method to get glyph height because we can't do it with Qt (:o)
def calcGlyphRect(font, glyph):
    X = font.pointSize() * 2
    Y = font.pointSize() * 2
    image = QtGui.QImage(X,Y, QtGui.QImage.Format_RGB32)
    whiteRGB = QtGui.qRgb(255,255,255)
    #print "white",whiteRGB
    image.fill(whiteRGB)
    painter = QtGui.QPainter(image)
    painter.setFont(font)
    brush = QtGui.QBrush(QtCore.Qt.red)
    painter.setBrush(brush)
    painter.drawText(X/4.0,Y*3/4.0,glyph)
    painter.end()
    minY = Y
    maxY = 0
    minX = X
    maxX = 0
    for x in range(X):
        pixelFound = False
        for y in range(Y):
            #print "x,y,c",x,y,image.pixel(x,y)
            if not image.pixel(x,y) == whiteRGB:
                pixelFound = True
                if y < minY:
                    #print x,y,"miny", y
                    minY = y
                break
        for y in reversed(range(Y)):
            if not image.pixel(x,y) == whiteRGB:
                pixelFound = True
                if y > maxY:
                    #################print x,y,"maxy", y
                    maxY = y
                break
        if pixelFound:
            if minX == X:
                minX = x
            if x > maxX:
                maxX = x
                
    x = minX - X/4.0
    y = minY - Y*3/4.0
    width = maxX - minX
    height = maxY - minY
    return x,y,width,height
    #return Rect(x,-height-y,width+1,height+1)     
    
class FontMetrics(QtGui.QFontMetrics):
    def __init__(self, font):
        QtGui.QFontMetrics.__init__(self, font)
        self.font = font
        
    def charBoundingRect(self, char):
        return self.boundingRect(char)
        
    def boundingRect(self,text):
        # first get maxY, maxHeight
        
        maxY = -1000
        minY = 1000
        for ch in text:
            x,y,width,height = getGlyphRect(self.font, ch)
            if y > maxY:
                maxY = y
            topY = y - height
            if topY < minY:
                minY = topY
        y = maxY
        height = maxY - minY 
            
        qtRect = QtGui.QFontMetrics.boundingRect(self,0,0,1000,1000,QtCore.Qt.AlignLeft + QtCore.Qt.AlignTop, text)
        return Rect(qtRect.x(),-y-height,qtRect.width(),height+1)
                
    def boundingRect2(self,text):
        # we modify x and y because we want to return the postscript-compliant version of x,y
        # ie x and y are relative to the origin of the character itself and not the reverse as in Qt
        rect = QtGui.QFontMetrics.boundingRect(self,0,0,1000,1000,QtCore.Qt.AlignLeft + QtCore.Qt.AlignTop, text)
        return Rect(rect.x(),-(rect.height()+rect.y()),rect.width(),rect.height())

    def charBoundingRect2(self,char):
        rect =  QtGui.QFontMetrics.boundingRect(self, (unicode(char)))
        return Rect(rect.x(),-(rect.height()+rect.y()),rect.width(),rect.height())

class Rect(QtCore.QRect):
    def __init__(self,x,y,w,h):
        QtCore.QRect.__init__(self,x,y,w,h)
        
    def __repr__(self):
        return "<Rect (pdf) %s %s %s %s >" % (self.x(), self.y(), self.width(), self.height())

