/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2007 Kouhei Sutou <kou@cozmixng.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copyED of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_MODULE_IMPL_H__
#define __KZ_MODULE_IMPL_H__

#include <glib-object.h>
#include "kz-app.h"

G_BEGIN_DECLS

#include "kz-module.h"

typedef void     (*KzModuleInitFunc)         (GTypeModule *module);
typedef void     (*KzModuleExitFunc)         (void);
typedef GObject *(*KzModuleInstantiateFunc)  (const gchar *first_property,
					      va_list      var_args);
typedef const gchar *(*KzModuleGetNameFunc)  (void);

#define KZ_MODULE_IMPL_INIT           kz_module_impl_init
#define KZ_MODULE_IMPL_EXIT           kz_module_impl_exit
#define KZ_MODULE_IMPL_INSTANTIATE    kz_module_impl_instantiate
#define KZ_MODULE_IMPL_GET_NAME       kz_module_impl_get_name


void     KZ_MODULE_IMPL_INIT           (GTypeModule  *module);
void     KZ_MODULE_IMPL_EXIT           (void);
GObject *KZ_MODULE_IMPL_INSTANTIATE    (const gchar *first_property,
					va_list      var_args);
const gchar *KZ_MODULE_IMPL_GET_NAME   (void);

G_END_DECLS

#endif /* __KZ_MODULE_IMPL_H__ */
