/***************************************************************************
                          kbib.h  -  description
                             -------------------
    begin                : Sat May 24 16:37:30 EST 2003
    copyright            : (C) 2003 by Thach Nguyen
    email                : thach@dragon.thach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBIB_H
#define KBIB_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt

// include files for KDE
#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kaction.h>
#include <kurl.h>
#include <qlistview.h>
#include <qvbox.h>
#include <qtextview.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qptrlist.h>

#include "kbibiface.h"
#include "kbiblistview.h"
#include "kbibpreview.h"
#include "kbibgroupview.h"
#include "id2entry.h"
#include "bibentrydeftable.h"


// forward declaration of the KBib classes
class KBibDoc;
class KBibFindDlg;
class KBibConfigDlg;
class KBibStart;

bool writeXMLFile(void);

typedef struct _configState
{
    QString browser;
    QString textViewer;
    QString keyConnecting;
    QFont   font;
    int 	  startupAction;
    bool    askReqField;
    int 	  citeAction;
	int fieldDelimiter;
    QStringList displayFields;
    QValueList<int> displayFieldsSize;
    bool displayFieldsChanged;
	int compareRefSetting;
	int authorDisplaySetting;
	bool autocompletion;
	QMap<QString, QString> globalStringMacros;
//	QString encoding;
}
configState;


class KBibApp : public KMainWindow, virtual public KBibIface
{
    Q_OBJECT

public:
    /** construtor of KBibApp, calls all init functions to create the application.
     */
    KBibApp(QWidget* parent=0, const char* name="kbib");
    ~KBibApp();

    /** returns a pointer to the current document connected to the KTMainWindow instance and is used by
     * the View class to access the document object's methods
     */
    KBibDoc *getDocument() const;
    QString cite();
    int insertFile(QString url, int fileType, bool notInsertExisting);
    bool openDocument(const KURL url_);
    int searchKey(const char *s, int start=0);
    int getPreviewMode();
    void startKbib();
    void closeEvent(QCloseEvent *e);

    bool editEntry(int i);

    void startup();

    QString getLastFile();

    configState kbibConfigState;
    QStringList defaultDisplayFields();
    QValueList<int> defaultDisplayFieldsSize();
    void setCurrentSelectedView(int );
	KBibListView *currentListView(void) { return m_view; }
	bool isGroupViewVisible() { return groupViewVisible; }
	void createEntryDefs();
	
protected:
    /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
     * file
     */
    void saveOptions();

    /** read general Options again and initialize all variables like the recent file list
     */
    void readOptions();

    /** initializes the KActions of the application */
    void initActions();
    /** sets up the statusbar for the main window by initialzing a statuslabel.
     */

    void initStatusBar();
    /** initializes the document object of the main window that is connected to the view in initView().
     * @see initView();
     */

    void initDocument();
    /** creates the centerwidget of the KTMainWindow instance and sets it as the view
     */

    void initView();
    /** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
     * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
     * be saved if Modified; on cancel the closeEvent is rejected.
     * @see KTMainWindow#queryClose
     * @see KTMainWindow#closeEvent
     */

    virtual bool queryClose();
    /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
     * properties.
     * @see KTMainWindow#queryExit
     * @see KTMainWindow#closeEvent
     */

    virtual bool queryExit();
    /** saves the window properties for each open window during session end to the session config file, including saving the currently
     * opened file by a temporary filename provided by KApplication.
     * @see KTMainWindow#saveProperties
     */

    virtual void saveProperties(KConfig *_cfg);
    /** reads the session config file and restores the application's state including the last opened files and documents by reading the
     * temporary files saved by saveProperties()
     * @see KTMainWindow#readProperties
     */
    virtual void readProperties(KConfig *_cfg);

	void setGroupByList();
	void setActive();
	void newRefFromID(IDType, QString, BibEntry *entry=0);

public slots:
    /** open a new application window by creating a new instance of KBibApp */
    void slotFileNewWindow();
    /** clears the document in the actual view to reuse it as the new document */
    void slotFileNew();
    /** open a file and load it into the document*/
    void slotFileOpen();
    /** opens a file from the recent files menu */
    //    void slotFileOpenRecent(const KURL& url);
    /** save a document */
    void slotFileSave();
    /** save a document by a new filename*/
    void slotFileSaveAs();
    /** print the actual file */
    //void slotFilePrint();
    /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
     * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
     */
    void slotFileQuit();

    void slotFileExportEndnote();
    void slotFileExportRIS();
	void slotFileExportMODSXML();
	void slotFileExportHTML();

    void slotViewToolBar();
    /** toggles the statusbar
     */
    void slotViewStatusBar();
    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusMsg(const QString &text);
    void slotFileOpenRecent(const KURL& url);
    /** Delete Selected Entries */
    void slotDeleteEntry();
    void slotNewEntry();
    void slotInsertFile();
    void slotCiteEntry();
    void slotEditDeSelectAll();
    void slotEditSelectAll();
    void slotShowPreview();
	void slotShowGroupView();
    void slotViewBibSource();
    void slotDocChanged();
    void slotCreateKeys();
	void slotViewURL();
	void slotViewFile();
    void slotNumRefMsg();

    void slotCheckKeys();

    void slotEditPaste();

    void slotEditCopy();
	void slotEditCopyFormated();
    void slotEditCut();
    void slotEditInvertSelection();

    void slotFileReload();

    void slotEditFind();

    void slotEditFindNext();
    void slotStringMacro();
	void slotPreamble();
    void slotPreviewModeSelect();
	void slotCustomiseFields();
	void slotCustomiseTypes();
	void slotSetFieldValue();
	void slotReplaceString();
	void slotCopyFieldContent();
    void slotConfig();
    void slotConfigToolbar();
    void slotNewToolbarConfig();
    void slotConfigKeys();

    void configurationChanged(const configState &st);
    void slotLockKeys();
	void slotLockKeysSelected();
    void slotunLockKeys();
	void slotunLockKeysSelected();

    void slotSelectionChanged();

    void slotCreateBibliography();
    void slotSortReference();
    void slotSaveSelected();
    void slotRemoveDuplicated();

    void slotViewAll();
    void slotViewSelected();
    void slotHideSelected();

    void slotShowDuplicated();
    void slotViewByRefType();

    void slotGroupByChange();
	void slotInternetSearch();
	void slotNewEntryFromText();
	void slotNewEntryFromDOI();
	void slotNewEntryFromArXiv();
	void slotNewEntryFromPubmedID();
	void slotNewEntryFromIDResult(BibEntry *);

	void slotNewEntryFromPDF();

private:
//	BibEntryDefTable* entryDefTab;
	
    /** the configuration object of the application */
    KConfig *config;
    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */

    /** doc represents your actual document and is created only once. It keeps
     * information such as filename and does the serialization of your files.
     */
    KBibDoc *doc;

    KBibListView *m_view;
	QGroupBox *grpViewBox;
    QComboBox *groupViewSelect;
    KBibGroupView *group_view;
    //    QTextView *p_preview;
    KBibPreview *p_preview;
    KRecentFilesAction* m_fileOpenRecent;
    // KAction pointers to enable/disable actions
    KAction* fileNewWindow;
    KAction* fileNew;
    KAction* fileOpen;
    KRecentFilesAction* fileOpenRecent;
    KAction* fileSave;
    KAction* fileSaveAs;
    //KAction* filePrint;
    KAction* fileQuit;
    KAction* fileExportRIS;
	KAction* fileExportMODS;
	KAction* fileExportHTML;
    KAction* fileExportEndnote;
    KAction* editCopy;
	KAction* editCopyFormated;
    KAction* editPaste;
    KAction* editCut;
    KAction* newEntry;
	KAction* newEntryFromDOI;
	KAction* newEntryFromArXiv;
	KAction* newEntryFromPMID;
	KAction* newEntryFromPDF;
    KAction* insertExistingFile;
    KAction* deleteEntry;
    KAction* citeEntry;
    KAction * viewBibSource;
    KAction * showPreview;
	KAction * showGroupView;
    KAction* editSelecAll ;
    KAction* editDeSelectAll;
    KAction* editInvertSelection;
	KAction* internetSearch;
	KAction* newEntryFromText;

    KAction* stringMacro;
	KAction* preamble;
	KAction* customiseFields;
	KAction* customiseTypes;
    KAction* createBibliography;
    KAction* sortReference;
    KAction* viewByRefType;
    KAction* setFieldValue;
	KAction* replaceString;
	KAction* copyFieldContent;
	
	QString lastFile;

    bool previewVisible;
	bool groupViewVisible;
    KToggleAction* viewToolBar;
    KToggleAction* viewStatusBar;
    KAction* createKeys;
    KAction* lockKeys;
    KAction* unLockKeys;
    KAction* refCheckKey;
    KAction* saveSelected;
    KAction* removeDuplicated;
    KAction* showDuplicated;
    KAction* fileReload;
    KAction* editFind;
    KAction* editFindNext;

    KAction* viewAll;
    KAction* viewSelected;

    KAction* hideSelected;

    KBibFindDlg * m_findDlg;
    KBibConfigDlg * configDlg;
    int previewMode;
    KSelectAction * previewModeSelect;
    bool firstRun;

    QPushButton *previewBtn;
    int	currentSelectedView;	//0: none selected, 1: groupview, 2: listview

	ID2Entry *m_id2Entry;
};

#endif // KBIB_H
