//
// C++ Implementation: monthfieldwidget
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "monthfieldwidget.h"

#include <qlayout.h>
#include <kdialog.h>
#include <klocale.h>
#include <qwhatsthis.h>

namespace GUI {

MonthFieldWidget::MonthFieldWidget(QString _name, RefField* field,  QWidget *parent, const char *name)
 : FieldWidget(parent, name)
{
	m_field = field;
	m_name = _name;
	QHBoxLayout* l = new QHBoxLayout(this, 0, KDialog::spacingHint()); 
	QString fn = m_name;
	QChar c = fn.at(0); 
	fn = fn.replace(0, 1, c.upper());
	
	m_label = new QLabel(fn+QString::fromLatin1(":"), this);
	m_monthEdit = new KComboBox(true, this);
	
	//m_numberEdit->setMaximumWidth(400);
	
	QWhatsThis::add ( m_monthEdit, i18n("Enter the value of the %1 field here or select from the list.").arg(m_name.lower()) );
	
	m_monthEdit->insertItem(QString::fromLatin1("Jan."));
	m_monthEdit->insertItem(QString::fromLatin1("Feb."));
	m_monthEdit->insertItem(QString::fromLatin1("Mar."));
	m_monthEdit->insertItem(QString::fromLatin1("Apr."));
	m_monthEdit->insertItem(QString::fromLatin1("May"));
	m_monthEdit->insertItem(QString::fromLatin1("June"));
	m_monthEdit->insertItem(QString::fromLatin1("July"));
	m_monthEdit->insertItem(QString::fromLatin1("Aug."));
	m_monthEdit->insertItem(QString::fromLatin1("Sep."));
	m_monthEdit->insertItem(QString::fromLatin1("Oct."));
	m_monthEdit->insertItem(QString::fromLatin1("Nov."));
	m_monthEdit->insertItem(QString::fromLatin1("Dec."));
	
	
	m_label->setBuddy(m_monthEdit);
	
	l->addWidget(m_label);
	l->addWidget(m_monthEdit);
	m_monthEdit->setMinimumWidth((m_monthEdit->sizeHint().width())*2);
	l->addStretch(0);
	
	
	
}


MonthFieldWidget::~MonthFieldWidget()
{
}

void MonthFieldWidget::setText(QString st)
{
	m_monthEdit->setCurrentText(st);
}


QString MonthFieldWidget::getText(void){
	return m_monthEdit->currentText();
}


}


#include "monthfieldwidget.moc"
