//
// C++ Interface: referencefieldsdialog
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef REFERENCEFIELDSDIALOG_H
#define REFERENCEFIELDSDIALOG_H

#include <kdialogbase.h>
#include "bibentrydeftable.h"

class KComboBox;
class KLineEdit;
class KPushButton;

class QLabel;
class QRadioButton;
class QCheckBox;
class QPainter;
#include <qlistbox.h>
#include <qdict.h>

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
class ReferenceFieldsDialog : public KDialogBase
{
Q_OBJECT
public:
    ReferenceFieldsDialog(QWidget *parent = 0, const char *name = 0);

    ~ReferenceFieldsDialog();

private:
	virtual void slotOk();
	bool checkField();
	bool updateField();
	
	QDict<RefField> refFieldTab;
	QListBox *m_fieldsBox;
	KPushButton *m_btnDelete;
	KLineEdit *m_nameEdit;
	KComboBox* m_typeCombo;
	QLabel *m_multipleEditLabel;
	KLineEdit *m_multipleEdit;
	QCheckBox *m_autoCompletion;
	QCheckBox *m_allowGrouping;
	int newFieldCnt;
	int prevIndex;
	QString prevName;
	private slots:
		void slotHighlightedChanged(int);
		void slotTypeChanged(int);
		void slotNewField();
		void slotDeleteField();
	
};

#endif
