//
// C++ Implementation: replacestringdlg
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "replacestringdlg.h"

#include "bibentrydeftable.h"
#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qwhatsthis.h>


ReplaceStringDlg::ReplaceStringDlg(bool selected, QWidget *parent, const char *name)
 :KDialogBase ( parent, name , true, i18n ( "Replace String" ), KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, false )
{
	QWidget* page = new QWidget ( this );
	setMainWidget ( page );
	QVBoxLayout* l = new QVBoxLayout ( page, 0, KDialog::spacingHint() );

	QHBox* box1 = new QHBox ( page );
	box1->setSpacing ( KDialog::spacingHint() );
	
	QLabel *oldValueLabel = new QLabel(i18n("Search for:"), box1);
	m_oldString = new KLineEdit(box1);
	QWhatsThis::add(m_oldString, i18n("Enter the string to be replaced here.") );
	l->addWidget(box1);
	oldValueLabel->setBuddy(m_oldString);
	
	QHBox* box2 = new QHBox ( page );
	box2->setSpacing ( KDialog::spacingHint() );
	
	QLabel *newValueLabel = new QLabel(i18n("Replace with:"), box2);
	m_newString = new KLineEdit(box2);
	QWhatsThis::add(m_newString, i18n("Enter the new string here.") );
	l->addWidget(box2);
	newValueLabel->setBuddy(m_newString);

	int width;
	if (oldValueLabel->sizeHint().width() > newValueLabel->sizeHint().width())
		width = oldValueLabel->sizeHint().width();
	else
		width = newValueLabel->sizeHint().width();
	oldValueLabel->setFixedWidth(width);
	newValueLabel->setFixedWidth(width);
	
	m_fieldOptionGroup = new QVGroupBox(i18n("Search in"), page);
    l->addWidget(m_fieldOptionGroup);
	
	m_allFieldSelect = new QRadioButton(i18n("All fields"), m_fieldOptionGroup);
	QWhatsThis::add(m_allFieldSelect, i18n("Search and replace string in all fields.") );
	QHBox* box3 = new QHBox ( m_fieldOptionGroup );
	m_fieldSelect = new QRadioButton(i18n("Limited to field: "), box3);
	QWhatsThis::add(m_fieldSelect, i18n("Search and replace string in only specified field.") );
	m_field = new KComboBox(true, box3);
	QWhatsThis::add(m_field, i18n("Enter or select from the list the name of the field you want to search and replace string.") );


	
	m_allFieldSelect->setChecked(1);
    m_fieldSelect->setChecked(0);
	
	m_fieldButtonGroup = new QButtonGroup(page);
	m_fieldButtonGroup->hide();
    m_fieldButtonGroup->insert(m_allFieldSelect);
    m_fieldButtonGroup->insert(m_fieldSelect);
	
	
	m_field->insertStringList( BibEntryDefTable::self()->getFieldNames());	
		
    m_field->setCurrentText("");
	
	m_entryOptionGroup = new QVGroupBox(i18n("Apply change to"), page);
    l->addWidget(m_entryOptionGroup);
    m_allEntrySelect = new QRadioButton(i18n("All references"), m_entryOptionGroup);
	QWhatsThis::add(m_allEntrySelect, i18n("Apply change to all references in the current document.") );
    m_selectedEntrySelect = new QRadioButton(i18n("Only selected references"), m_entryOptionGroup);
	QWhatsThis::add(m_selectedEntrySelect, i18n("Apply change to only selected references in the main list view or in the group view.") );
	
	
	m_entryButtonGroup = new QButtonGroup(page);
	m_entryButtonGroup->hide();
    m_entryButtonGroup->insert(m_allEntrySelect);
    m_entryButtonGroup->insert(m_selectedEntrySelect);
	
	if (selected){
	    m_allEntrySelect->setChecked(0);
    	m_selectedEntrySelect->setChecked(1);
		m_selectedEntrySelect->setEnabled(true);
	}
	else{
		m_allEntrySelect->setChecked(1);
    	m_selectedEntrySelect->setChecked(0);	
		m_selectedEntrySelect->setEnabled(false);
	}
	
	connect(m_field, SIGNAL(textChanged ( const QString & ) ), this, SLOT(slotField(const QString &) ) );
	this->setMinimumWidth(300);
}


ReplaceStringDlg::~ReplaceStringDlg()
{
}

void ReplaceStringDlg::slotField(const QString& st){
	if (!st.isEmpty()){
		m_allFieldSelect->setChecked(0);
    	m_fieldSelect->setChecked(1);	

	}
}

#include "replacestringdlg.moc"
