/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef VISUALEDITOR_H
#define VISUALEDITOR_H

#include <ktextedit.h>

namespace KBlogger
{

class VisualEditor: public KTextEdit
{
    Q_OBJECT

public:
    VisualEditor(QWidget *parent);
    virtual ~VisualEditor();
    virtual QVariant loadResource ( int type, const QUrl & name );

protected:
    void dragEnterEvent(QDragEnterEvent *event);
    void dropEvent(QDropEvent *event);

Q_SIGNALS:
    void droppedMedia( const QString& fileUrl );
};

}
; //namespace

#endif
