/***************************************************************************
                          configurewizard.cpp  -  description
                             -------------------
    begin                : Mon Feb 12 2001
    copyright            : (C) 2001 by Javier Campos Morales
    email                : javi_cms@terra.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "configurewizard.h"
#include "configurewizard.moc"
#include "klineeditdlg.h"

#include <klocale.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kstddirs.h>
#include <qframe.h>
#include <qheader.h>
#include <qlayout.h>
#include <qdir.h>
#include <qlabel.h>

ConfigureWizard::ConfigureWizard(QWidget *parent, const char *name, const QString filePath ) : KDialogBase( parent, name, true, i18n("Configure Options"), Ok|Close, Ok, true )
{
	streamLine = "";
	initGUI();
	initHELP(filePath);
	configRead();
}

ConfigureWizard::~ConfigureWizard()
{
}

/** No descriptions */
void ConfigureWizard::initGUI()
{
		QWidget *page = new QWidget(this);

    QVBoxLayout *Form1Layout = new QVBoxLayout( page );
    Form1Layout->setSpacing( 0 );
    Form1Layout->setMargin( 0 );

    QHBoxLayout *Layout2 = new QHBoxLayout;
    Layout2->setSpacing( 0 );
    Layout2->setMargin( 0 );

    QLabel *TextLabel1 = new QLabel( page, "TextLabel1" );
    TextLabel1->setPixmap( QPixmap( locate("icon","hicolor/48x48/mimetypes/kconfigure.png") ) );
    Layout2->addWidget( TextLabel1 );

    QLabel *TextLabel2 = new QLabel( page, "TextLabel2" );
    TextLabel2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)1, TextLabel2->sizePolicy().hasHeightForWidth() ) );
    TextLabel2->setText( i18n( "<p><b>Modify configure arguments.</b></p><p>Click in the options list to change it's value. After this, push the Ok button to make effective the changes and continue the process of configure.</p>" ) );
    Layout2->addWidget( TextLabel2 );
    Form1Layout->addLayout( Layout2 );

    mainOptions = new KListView( page, "mainOptions" );
    mainOptions->addColumn( i18n( "Option" ) );
    mainOptions->addColumn( i18n( "Value" ) );
    mainOptions->addColumn( i18n( "Description" ) );
		mainOptions->setColumnWidthMode( 0, QListView::Manual );
		mainOptions->setColumnWidthMode( 1, QListView::Manual );
		mainOptions->setColumnWidthMode( 2, QListView::Manual );
		mainOptions->setAllColumnsShowFocus ( true );
		connect( mainOptions, SIGNAL( executed(QListViewItem *) ), this, SLOT( slotItemModify(QListViewItem *) ) );
    Form1Layout->addWidget( mainOptions );

		setMainWidget(page);
}

void ConfigureWizard::initHELP(const QString &filePath)
{
	QDir qdir;

	qdir.setCurrent( filePath );

	q.clearArguments();
	q << "./configure" << "--help";
	QApplication::connect( &q, SIGNAL(receivedStdout(KProcess *, char *, int)),this,SLOT(slotOutputMessages(KProcess *, char *, int)));
  q.start( KProcess::DontCare, KProcess::Stdout );
}

/** No descriptions */
void ConfigureWizard::slotOutputMessages(KProcess*,char *buffer,int buflen)
{
	for( int i = 0; i < buflen; i++ )
	{
	if( *buffer == '\n' )
		{
		addItem();
		streamLine = "";
		} else {
		streamLine += *buffer;
		}
	++buffer;
	}
}

/** Add item from configure --help */
void ConfigureWizard::addItem()
{
	int start_pos;
	int finish_opt;

	if( streamLine.right(1) == ":" ) return;
	if( (start_pos = streamLine.find("--")) > -1 )
		{
		finish_opt = streamLine.find(" ", start_pos);

		(void) new QListViewItem( mainOptions, streamLine.mid( start_pos+2, finish_opt-2-start_pos ), "", ( streamLine.mid(finish_opt, streamLine.length()-finish_opt).stripWhiteSpace() ) );
		}
}

/** No descriptions */
void ConfigureWizard::slotItemModify(QListViewItem *item)
{
	if( (		item->text(0).find("enable")>-1
			||  item->text(0).find("disable")>-1
			||  item->text(0).find("quiet")>-1
			||  item->text(0)=="help"
			||  item->text(0)=="version"
			||  item->text(0)=="with-gnu-ld"
			||  item->text(0)=="with-pic"
			||  item->text(0)=="no-create"
			) && (item->text(0).find("FEATURE")==-1 ) )
		{
			if( item->text(1) == i18n("Activate") )
				item->setText( 1, "" );
				else
				item->setText( 1, i18n("Activate") );
		}
		else
		{
		KLineEditDlg argdlg( "<p><b>"+item->text(0)+"</b></p><p>"+i18n("Description : ")+item->text(2)+"</p>", item->text(1), this);
		if(argdlg.exec())	
			{
			if( argdlg.text() == QString::null )
					item->setText( 1, "" );
				else
					item->setText( 1, (argdlg.text()).stripWhiteSpace() );
			}
		}
}

/** Get arguments of configure */
QString ConfigureWizard::getArguments()
{
	QString arguments="";

	QListViewItem *item = mainOptions->firstChild();
    while( item ) {
        if( (item->text(1)).stripWhiteSpace() != "" )
					{
					QString Soption = "";
					int SoptionLen;

					if( (SoptionLen = item->text(0).find("[")) > -1 )
						{ Soption = item->text(0).left(SoptionLen); }
						else 	if( (SoptionLen = item->text(0).find("=")) > -1 )
							{ Soption = item->text(0).left(SoptionLen); }
							else 	if( (SoptionLen = item->text(0).find("FEATURE")) > -1 )
								{ Soption = item->text(0).left(SoptionLen); }
								else { Soption = item->text(0); }

					if( item->text(1)==i18n("Activate") )
					{ arguments += "--" + Soption + " "; }
					else if( item->text(0).find("FEATURE")>-1 )
						{ arguments += "--" + Soption + item->text(1) + " "; }
						else
						{ arguments += "--" + Soption + "=" + item->text(1) + " "; }
					}
        item = item->nextSibling();
    }
	return arguments;
}

/** Read the config settings */
void ConfigureWizard::configRead()
{
	KConfig *config = KGlobal::config();

	config->setGroup("Configure Help");
	QSize *defaultSize = new QSize(500,350);
	this->resize( config->readSizeEntry("Geometry", defaultSize ) );
	mainOptions->setColumnWidth( 0, config->readNumEntry("Column Option", 175 ) );
	mainOptions->setColumnWidth( 1, config->readNumEntry("Column Value", 100 ) );
	mainOptions->setColumnWidth( 2, config->readNumEntry("Column Description", 300 ) );

}

/** Write config settings */
void ConfigureWizard::configWrite()
{
  KConfig *config = KGlobal::config();

	config->setGroup("Configure Help");
	config->writeEntry("Geometry", this->size() );
	config->writeEntry("Column Option", mainOptions->columnWidth(0) );
	config->writeEntry("Column Value", mainOptions->columnWidth(1) );
	config->writeEntry("Column Description", mainOptions->columnWidth(2) );
	config->sync();
}

/** Finish dialog */
void ConfigureWizard::slotOk()
{
	configWrite();
	accept();
}
