/***************************************************************************
                          kcpreferences.h  -  description
                             -------------------
    begin                : Sat Jan 27 2001
    copyright            : (C) 2001-2005 by Javier Campos Morales
    				and the kconfigure team
    email                :kconfigure@rockerssoft.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KCPREFERENCES_H
#define KCPREFERENCES_H

#include <kdialog.h>
#include <kdialogbase.h>

#include <klocale.h>
#include <kfontdialog.h>
#include <kurlrequester.h>

#include <qradiobutton.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qpushbutton.h>

/**Preferences dialog

  *@author Javier Campos Morales
  *@author Robert Rockers
  */

class Kcpreferences : public KDialogBase  {
   Q_OBJECT
public: 
	Kcpreferences( QWidget *parent=0, const char *name=0, bool modal=true );
	~Kcpreferences();
	/** Read the settings from our configuration file */
	void configRead();
	/** Write the settings to our configuration file */
	void configWrite();
	/** Our Current Settings */
	/** Font Settings */
	QFont Fonts_Default;
	QFont Fonts_Error;
	/** Extract Settings */
	bool Is_Decompress;
	QString Decompress_Dir;
	/** Loging Settings */
	bool Is_Logged;
	bool Is_LogInSources;
	bool Is_LogInHome;
	QString Log_Dir;
	bool Is_LogHTML;
	/** Checkinstall Options */
	bool Is_Checkinstall;
	QString CheckInstall_Command;
	bool Is_RPM;
	bool Is_DKPG;
	bool Is_SLK;
	bool Is_BackFiles;
	bool Is_ElfStrip;
	QString Comstom_Command;
	/** Install Options List */
	int useInstall;

private:
	KFontChooser *font_main;
	KFontChooser *font_error;

private: // Private methods
	/** Set the font options Page of the preferences dialog */
	void setPage_Font();
	/** Set the Check Install options Page of the preferences dialog */
	void setPage_CheckInstall();
	/** Set the misc options Page of the preferences dialog */
	void setPage_Misc();
	/** Put the our config settings into our dialog */
	void setConfigDialog();
	/** Get our config settings from the Settings dialog */
	void readConfigDialog();
	/** misc widgets */
	QCheckBox *compress_dir;
	QCheckBox *logs_start;
	QRadioButton *logs_sources;
	QRadioButton *logs_personal;
	QCheckBox *logs_html;
	/**  */
	QCheckBox *checkinstall_yes;
	KURLRequester *kurlcheckinstall;
	QCheckBox *backup_yes;
	QCheckBox *Elfstrip_yes;
	QLabel *textLabel1;
	QLineEdit *customOptions;
	QRadioButton *RPMradio;
	QRadioButton *DKPGradio;
	QRadioButton *SLKradio;
	KURLRequester *kurlcompress;
	KURLRequester *kurlrequest;

private slots: // Private slots
	/** Ok button */
	void slotOk();
	/** Enables and disables loging options */
	void slotLogCheck();
	/** enables and disables compress options */
	void slotDirCompressCheck();
	/** Enable and disable check install options */
	void slotCheckInstallCheck();

};

#endif
