/* This file is part of the KDE project
   Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef __konq_actions_h__
#define __konq_actions_h__ "$Id: konq_actions.h,v 1.2 2004/09/13 21:34:37 brockers Exp $"

#include <qguardedptr.h>

#include <kaction.h>
#include <qlist.h>

class QLabel;
class QPopupMenu;

class KonqLogoAction : public KAction
{
  Q_OBJECT
public:
    KonqLogoAction( const QString& text, int accel = 0, 
    			QObject* parent = 0, const char* name = 0 );
    KonqLogoAction( const QString& text, int accel,
	            	QObject* receiver, const char* slot, QObject* parent, const char* name = 0 );
    KonqLogoAction( const QString& text, const QIconSet& pix, int accel = 0,
	            	QObject* parent = 0, const char* name = 0 );
    KonqLogoAction( const QString& text, const QIconSet& pix, int accel,
	            	QObject* receiver, const char* slot, QObject* parent, const char* name = 0 );
    // text missing !
//     KonqLogoAction( const QStringList& icons, 
//     		    	QObject* receiver, const char* slot, QObject* parent, const char* name = 0 );

    virtual int plug( QWidget *widget, int index = -1 );

    void start();
    void stop();

private:
    QStringList iconList;
};

#endif
