/***************************************************************************
 *   Copyright (C) 2006 by Rohan McGovern                                  *
 *   rohan.pm@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "dbusannotatable.h"
#include "dbusexceptions.h"

#include <stdexcept>
#include <klocale.h>
#include <qwidget.h>
#include <qvbox.h>
#include <qlabel.h>

DBusAnnotatable::DBusAnnotatable(
  QListViewItem * parent,
  QString const & text1,
  QString const & text2
) : DBusItem( parent, text1, text2 ) {}

DBusAnnotatable::DBusAnnotatable(
  QListView * parent,
  QString const & text1,
  QString const & text2
) : DBusItem( parent, text1, text2 ) {}

void DBusAnnotatable::addAnnotation( QDomElement const & elem )
throw ( QDBusXmlError ) {
    ensureElementIsNamed( elem, "annotation" );
    ensureElementHasAttribute( elem, "name" );
    ensureElementHasAttribute( elem, "value" );

    m_annotations.insert( elem.attribute("name"), elem.attribute("value") );
}


void DBusAnnotatable::addAnnotationInfo( QWidget * widget ) const {
    if ( m_annotations.count() == 0 )
        return;

    QVBox * vbox = new QVBox( widget );
    new QLabel( vbox );
    new QLabel( "<b>Annotations:</b>", vbox );

    for (
      QMap< QString, QString >::const_iterator iter = m_annotations.begin();
      iter != m_annotations.end();
      ++iter
    )
        new QLabel(
          QString("%1: %2").arg( iter.key() ).arg( iter.data() ),
          vbox
        );

}



DBusAnnotatable::~DBusAnnotatable() {
}
