/***************************************************************************
 *   Copyright (C) 2006 by Rohan McGovern                                  *
 *   rohan.pm@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DBUSUTIL_H
#define DBUSUTIL_H

#include <qmutex.h>

#include "dbusexceptions.h"

class QString;

/**
 * A few D-BUS related static utility functions.
 */
class DBusUtil {
public:
    /**
     * @param type D-BUS type string to convert to human-readable form
     * @return human-readable version of D-BUS type string @a type
     */
    static QString niceType( QString const & type )
    throw( QDBusXmlError );

    /**
     * Any threads which need to send D-BUS messages should lock
     * and unlock this before and after.
     */
    static QMutex mutex;

private:
    /// Not implemented.
    DBusUtil();

    /// Not implemented.
    DBusUtil( DBusUtil const & other );

    /// Not implemented.
    const DBusUtil & operator=( DBusUtil const & other );
};

#endif
