/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "retwnd.h"

#include <qlistbox.h>
#include <qlabel.h>

using namespace KWallet;


RetWnd::RetWnd(const char *_funcId,
	       QWidget *parent, const char *name, WFlags f)
 : QWidget(parent, name, f)
{
	funcId = _funcId;
	setCaption("function return value");
	vbox = new QVBox(this);
	new QLabel(QString(funcId) + "\nreturned:", vbox);
	resize(QSize(650, 250));
}

RetWnd::~RetWnd()
{
	delete vbox;
}

void RetWnd::closeEvent(QCloseEvent *e)
{
	e->accept();
	delete this;
}

void RetWnd::resizeEvent(QResizeEvent *)
{
	vbox->resize(size());
}

void RetWnd::open_QStringList(const QStringList &d)
{
	QListBox *l = new QListBox(vbox);
	l->insertStringList(d);
	show();
}

void RetWnd::open_bool(bool d)
{
	QString str;
	if (d) {
		str = "true";
	} else {
		str = "false";
	}
	new QLabel(str, vbox);
	show();
}

void RetWnd::open_int(int d)
{
	new QLabel(QString::number(d), vbox);
	show();
}

void RetWnd::open_pWallet(KWallet::Wallet *d)
{
	new QLabel(QString("0x") +
		   QString::number(reinterpret_cast<unsigned long>(d), 16),
		   vbox);
	show();
}

void RetWnd::open_QString(const QString &d)
{
	new QLabel(d, vbox);
	show();
}

void RetWnd::open_EntryType(Wallet::EntryType d)
{
	QString str;
	switch (d) {
	case Wallet::Unknown:
		str = "Unknown";
		break;
	case Wallet::Password:
		str = "Password";
		break;
	case Wallet::Stream:
		str = "Stream";
		break;
	case Wallet::Map:
		str = "Map";
		break;
	case Wallet::Unused:
		str = "Unused";
		break;
	default:
		str = "BUG";
	}
	new QLabel(str, vbox);
	show();
}

void RetWnd::open_QMap_QString_QString(const QMap<QString,QString> &d)
{//TODO
show();
}

void RetWnd::open_QByteArray(const QByteArray &d)
{
	// we always display a QByteArray as QString, here.
	QString ret;
	QDataStream ds(d, IO_ReadOnly);
	ds >> ret;
	new QLabel("This is a QByteArray, displayed as QString!", vbox);
	new QLabel(ret, vbox);
	show();
}

#include "retwnd.moc"
