/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef PWGENWNDIMPL_H_
#define PWGENWNDIMPL_H_

#include "pwgenwnd.h"

class PwGenWndImpl : public pwGenWnd
{
public:
	PwGenWndImpl(QWidget *parent = 0,
		     const char *name = 0,
		     bool modal = FALSE,
		     WFlags fl = 0);
	~PwGenWndImpl();

	/** returns the generated password */
	QString getPassword();

protected slots:
	/** generate button pressed */
	void genButton_slot();
	/** cancel button pressed */
	void cancelButton_slot();
	/** update the quality progress bar */
	void updateQualityBar_slot();

protected:
	/** start the internal generator */
	bool startIntGen();
	/** check all options of the internal generator */
	bool optionsSanityIntGen();
	/** start the external generator */
	bool startExtGen();
	/** check all options of the external generator */
	bool optionsSanityExtGen();

protected:
	/** the generated password */
	QString password;
};

#endif // PWGENWNDIMPL_H_
