/***************************************************************************
 *   Copyright (C) 2007 by Stephen Leaf                                    *
 *   smileaf@smileaf.org                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <qlayout.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>

#include <klocale.h>
#include <kglobal.h>
#include <kparts/genericfactory.h>
#include <ksimpleconfig.h>
#include <kstandarddirs.h>
#include <kglobalsettings.h>
#include <kio/job.h>

#include "tweakconfig.h"
#include "tweak.h"

typedef KGenericFactory<tweak, QWidget> tweakFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_tweak, tweakFactory("kcmtweak"))

tweak::tweak(QWidget *parent, const char *name, const QStringList&)
    : KCModule(parent, name), myAboutData(0)
{
	QVBoxLayout* layout = new QVBoxLayout( this );
	layout->setAutoAdd( true );
    // place widgets here
	p_configWidget = new TweaKConfig(this);

    load();
    connect( p_configWidget->WheelDirection, SIGNAL(activated(const QString&)), SLOT(configChanged()) );
    connect( p_configWidget->AddTabButton, SIGNAL(clicked()), SLOT(configChanged()) );
    connect( p_configWidget->CloseTabButton, SIGNAL(clicked()), SLOT(configChanged()) );
    connect( p_configWidget->HoverCloseButton, SIGNAL(clicked()), SLOT(configChanged()) );
    connect( p_configWidget->TabPosition, SIGNAL(activated(const QString&)), SLOT(configChanged()) );
    connect( p_configWidget->MouseMiddleClickClosesTab, SIGNAL(clicked()), SLOT(configChanged()) );
    connect( p_configWidget->MinimumTabLength, SIGNAL(valueChanged(int)), SLOT(configChanged()) );
    connect( p_configWidget->MaximumTabLength, SIGNAL(valueChanged(int)), SLOT(configChanged()) );
    connect( p_configWidget->EnableFavicon, SIGNAL(clicked()), SLOT(configChanged()) );
    connect( p_configWidget->ShowMouseScrollIndicator, SIGNAL(clicked()), SLOT(configChanged()) );
    connect( p_configWidget->MenuEntryHeight, SIGNAL(activated(const QString&)), SLOT(configChanged()) );
    connect( p_configWidget->ShowMenuTitles, SIGNAL(clicked()), SLOT(configChanged()) );
    connect( p_configWidget->ButtonLayout, SIGNAL(clicked()), SLOT(configChanged()) );
    connect( p_configWidget->SendReferrer, SIGNAL(clicked()), SLOT(configChanged()) );
    connect( p_configWidget->ShowArchivesAsFolders, SIGNAL(clicked()), SLOT(configChanged()) );
    connect( p_configWidget->SortByApp, SIGNAL(clicked()), SLOT(configChanged()) );
    connect( p_configWidget->KickerHidden, SIGNAL(clicked()), SLOT(configChanged()) );
    connect( p_configWidget->offerShutdown, SIGNAL(clicked()), SLOT(configChanged()) );
};


tweak::~tweak()
{
}


void tweak::load()
{
	KSimpleConfig * config;
    // Read: share/config/kdesktoprc
    config = new KSimpleConfig( KGlobal::dirs()->findResource("config", "kdesktoprc") );
    config->setGroup( "Mouse Buttons" );
    p_configWidget->WheelDirection->setCurrentText( config->readEntry( "WheelDirection", "Forward" ) );
    // Read: share/config/konquerorrc
    config = new KSimpleConfig( KGlobal::dirs()->findResource("config", "konquerorrc") );
    config->setGroup( "FMSettings" );
    p_configWidget->AddTabButton->setChecked( config->readBoolEntry( "AddTabButton", true ) );
    p_configWidget->CloseTabButton->setChecked( config->readBoolEntry( "CloseTabButton", true ) );
    p_configWidget->HoverCloseButton->setChecked( config->readBoolEntry( "HoverCloseButton", false ) );
    p_configWidget->TabPosition->setCurrentText( config->readEntry( "TabPosition", "Top" ) );
    p_configWidget->MouseMiddleClickClosesTab->setChecked( config->readBoolEntry( "MouseMiddleClickClosesTab", false ) );
    p_configWidget->MinimumTabLength->setValue( config->readNumEntry( "MinimumTabLength", false ) );
    p_configWidget->MaximumTabLength->setValue( config->readNumEntry( "MaximumTabLength", false ) );
    config->setGroup( "HTML Settings" );
    p_configWidget->EnableFavicon->setChecked( config->readBoolEntry( "EnableFavicon", true ) );
    p_configWidget->ShowMouseScrollIndicator->setChecked( config->readBoolEntry( "ShowMouseScrollIndicator", true ) );
    // Read: share/config/khtmlrc
    config = new KSimpleConfig( KGlobal::dirs()->findResource("config", "khtmlrc") );
    config->setGroup( "Access Keys" );
    p_configWidget->AccessKeys->setChecked( config->readBoolEntry( "Enabled", true ) );
    config->sync();
    // Read: share/config/kickerrc
    config = new KSimpleConfig( KGlobal::dirs()->findResource("config", "kickerrc") );
    config->setGroup( "menus" );
    p_configWidget->MenuEntryHeight->setCurrentText( config->readEntry( "MenuEntryHeight", "22" ) );
    p_configWidget->ShowMenuTitles->setChecked( config->readBoolEntry( "ShowMenuTitles", true ) );
    // Read: share/config/kdeglobals
    config = new KSimpleConfig( KGlobal::dirs()->findResource("config", "kdeglobals") );
    config->setGroup( "KDE" );
    p_configWidget->ButtonLayout->setChecked( config->readBoolEntry( "ButtonLayout", false ) );
    // Read: share/config/kmailrc
    // Read: share/config/kio_httprc
    config = new KSimpleConfig( KGlobal::dirs()->findResource("config", "kio_httprc") );
    config->setGroup( "General" );
    p_configWidget->SendReferrer->setChecked( config->readBoolEntry( "SendReferrer", true ) );
    // Read: share/config/konqsidebartng.rc
    config = new KSimpleConfig( KGlobal::dirs()->findResource("config", "konqsidebartng.rc") );
    config->setGroup( "" );
    p_configWidget->ShowArchivesAsFolders->setChecked( config->readBoolEntry( "ShowArchivesAsFolders", true ) );
    // Read: share/config/ktaskbarrc
    config = new KSimpleConfig( KGlobal::dirs()->findResource("config", "ktaskbarrc") );
    config->setGroup( "General" );
    p_configWidget->SortByApp->setChecked( config->readBoolEntry( "SortByApp", true ) );
    // Read: share/config/ksmserverrc
    config = new KSimpleConfig( KGlobal::dirs()->findResource("config", "ksmserverrc") );
    config->setGroup( "General" );
    p_configWidget->SortByApp->setChecked( config->readBoolEntry( "offerShutdown", true ) );

    config = new KSimpleConfig( KGlobal::dirs()->localkdedir() + "share/autostart/panel.desktop" );
    config->setGroup( "Desktop Entry" );
    p_configWidget->KickerHidden->setChecked ( ! config->readBoolEntry( "Hidden", true ) );
}


void tweak::defaults()
{
    // insert your default settings code here...
    emit changed(true);
}


void tweak::save()
{
	KSimpleConfig * config;
    // Read: share/config/kdesktoprc
    config = new KSimpleConfig( KGlobal::dirs()->findResource("config", "kdesktoprc") );
    config->setGroup( "Mouse Buttons" );
    config->writeEntry( "WheelDirection", p_configWidget->WheelDirection->currentText() );
    config->sync();
    // Read: share/config/konquerorrc
    config = new KSimpleConfig( KGlobal::dirs()->findResource("config", "konquerorrc") );
    config->setGroup( "FMSettings" );
    config->writeEntry( "AddTabButton", p_configWidget->AddTabButton->isChecked() );
    config->writeEntry( "CloseTabButton", p_configWidget->CloseTabButton->isChecked() );
    config->writeEntry( "HoverCloseButton", p_configWidget->HoverCloseButton->isChecked() );
    config->writeEntry( "TabPosition", p_configWidget->TabPosition->currentText() );
    config->writeEntry( "MouseMiddleClickClosesTab", p_configWidget->MouseMiddleClickClosesTab->isChecked() );
    config->writeEntry( "MinimumTabLength", p_configWidget->MinimumTabLength->value() );
    config->writeEntry( "MaximumTabLength", p_configWidget->MaximumTabLength->value() );
    config->setGroup( "HTML Settings" );
    config->writeEntry( "EnableFavicon", p_configWidget->EnableFavicon->isChecked() );
    config->writeEntry( "ShowMouseScrollIndicator", p_configWidget->ShowMouseScrollIndicator->isChecked() );
    config->sync();
    // Read: share/config/khtmlrc
    config = new KSimpleConfig( KGlobal::dirs()->findResource("config", "khtmlrc") );
    config->setGroup( "Access Keys" );
    config->writeEntry( "Enabled", p_configWidget->AccessKeys->isChecked() );
    config->sync();
    // Read: share/config/kickerrc
    config = new KSimpleConfig( KGlobal::dirs()->findResource("config", "kickerrc") );
    config->setGroup( "menus" );
    config->writeEntry( "MenuEntryHeight", p_configWidget->MenuEntryHeight->currentText() );
    config->writeEntry( "ShowMenuTitles", p_configWidget->ShowMenuTitles->isChecked() );
    config->sync();
    // Read: share/config/kdeglobals
    config = new KSimpleConfig( KGlobal::dirs()->findResource("config", "kdeglobals") );
    config->setGroup( "KDE" );
    config->writeEntry( "ButtonLayout", p_configWidget->ButtonLayout->isChecked() );
    config->sync();
    // Read: share/config/kmailrc
    // Read: share/config/kio_httprc
    config = new KSimpleConfig( KGlobal::dirs()->findResource("config", "kio_httprc") );
    config->setGroup( "General" );
    config->writeEntry( "SendReferrer", p_configWidget->SendReferrer->isChecked() );
    config->sync();
    // Read: share/config/konqsidebartng.rc
    config = new KSimpleConfig( KGlobal::dirs()->findResource("config", "konqsidebartng.rc") );
    config->setGroup( "" );
    config->writeEntry( "ShowArchivesAsFolders", p_configWidget->ShowArchivesAsFolders->isChecked() );
    config->sync();
    // Read: share/config/ktaskbarrc
    config = new KSimpleConfig( KGlobal::dirs()->findResource("config", "ktaskbarrc") );
    config->setGroup( "General" );
    config->writeEntry( "SortByApp", p_configWidget->SortByApp->isChecked() );
    config->sync();
    // Read: share/config/ksmserverrc
    config = new KSimpleConfig( KGlobal::dirs()->findResource("config", "ksmserverrc") );
    config->setGroup( "General" );
    config->writeEntry( "offerShutdown", p_configWidget->offerShutdown->isChecked() );
    config->sync();

    if ( p_configWidget->KickerHidden->isChecked() &&
    	 KGlobal::dirs()->exists( KGlobal::dirs()->localkdedir() + "share/autostart/panel.desktop" ) ) {
    	KIO::del( KGlobal::dirs()->localkdedir() + "share/autostart/panel.desktop" );
    } else {
		config = new KSimpleConfig( KGlobal::dirs()->localkdedir() + "share/autostart/panel.desktop" );
		config->setGroup( "Desktop Entry" );
		config->writeEntry( "Hidden", !p_configWidget->KickerHidden->isChecked() );
		config->sync();
	}

    emit changed(true);
}


int tweak::buttons()
{
    return KCModule::Default|KCModule::Apply|KCModule::Help;
}


void tweak::configChanged()
{
    // insert your saving code here...
    emit changed(true);
}


QString tweak::quickHelp() const
{
    return i18n("Helpful information about the tweak module.");
}


#include "tweak.moc"
