//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Collections.Generic;

	/// <remarks>
	///  The dir lister deals with the kiojob used to list and update a directory
	///  and has signals for the user of this class (e.g. konqueror view or
	///  kdesktop) to create/destroy its items when asked.
	///  This class is independent from the graphical representation of the dir
	///  (icon container, tree view, ...) and it stores the items (as KFileItems).
	///  Typical usage :
	/// 
	/// <li>
	/// Create an instance.
	/// </li>
	/// 
	/// <li>
	/// Connect to at least update, clear, newItem, and deleteItem.
	/// </li>
	/// 
	/// <li>
	/// Call openUrl - the signals will be called.
	/// </li>
	/// 
	/// <li>
	/// Reuse the instance when opening a new url (openUrl).
	/// </li>
	/// 
	/// <li>
	/// Destroy the instance when not needed anymore (usually destructor).
	/// </li>
	///  Advanced usage : call openUrl with _keep = true to list directories
	///  without forgetting the ones previously read (e.g. for a tree view)
	///  See <see cref="IKDirListerSignals"></see> for signals emitted by KDirLister
	/// </remarks>		<author> Michael Brade <brade@kde.org>
	///  </author>
	/// 		<short> Helper class for the kiojob used to list and update a directory. </short>

	[SmokeClass("KDirLister")]
	public class KDirLister : QObject, IDisposable {
 		protected KDirLister(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KDirLister), this);
		}
		public enum OpenUrlFlag {
			NoFlags = 0x0,
			Keep = 0x1,
			Reload = 0x2,
		}
		/// <remarks>
		///  Used by items() and itemsForDir() to specify whether you want
		///  all items for a directory or just the filtered ones.
		///    </remarks>		<short>    Used by items() and itemsForDir() to specify whether you want  all items for a directory or just the filtered ones.</short>
		public enum WhichItems {
			AllItems = 0,
			FilteredItems = 1,
		}
		public enum Changes {
			NONE = 0,
			NAME_FILTER = 1,
			MIME_FILTER = 2,
			DOT_FILES = 4,
			DIR_ONLY_MODE = 8,
		}
		[Q_PROPERTY("bool", "autoUpdate")]
		public bool AutoUpdate {
			get { return (bool) interceptor.Invoke("autoUpdate", "autoUpdate()", typeof(bool)); }
			set { interceptor.Invoke("setAutoUpdate$", "setAutoUpdate(bool)", typeof(void), typeof(bool), value); }
		}
		[Q_PROPERTY("bool", "showingDotFiles")]
		public bool ShowingDotFiles {
			get { return (bool) interceptor.Invoke("showingDotFiles", "showingDotFiles()", typeof(bool)); }
			set { interceptor.Invoke("setShowingDotFiles$", "setShowingDotFiles(bool)", typeof(void), typeof(bool), value); }
		}
		[Q_PROPERTY("bool", "dirOnlyMode")]
		public bool DirOnlyMode {
			get { return (bool) interceptor.Invoke("dirOnlyMode", "dirOnlyMode()", typeof(bool)); }
			set { interceptor.Invoke("setDirOnlyMode$", "setDirOnlyMode(bool)", typeof(void), typeof(bool), value); }
		}
		[Q_PROPERTY("bool", "autoErrorHandlingEnabled")]
		public bool AutoErrorHandlingEnabled {
			get { return (bool) interceptor.Invoke("autoErrorHandlingEnabled", "autoErrorHandlingEnabled()", typeof(bool)); }
		}
		[Q_PROPERTY("bool", "delayedMimeTypes")]
		public bool DelayedMimeTypes {
			get { return (bool) interceptor.Invoke("delayedMimeTypes", "delayedMimeTypes()", typeof(bool)); }
			set { interceptor.Invoke("setDelayedMimeTypes$", "setDelayedMimeTypes(bool)", typeof(void), typeof(bool), value); }
		}
		[Q_PROPERTY("QString", "nameFilter")]
		public string NameFilter {
			get { return (string) interceptor.Invoke("nameFilter", "nameFilter()", typeof(string)); }
			set { interceptor.Invoke("setNameFilter$", "setNameFilter(QString)", typeof(void), typeof(string), value); }
		}
		[Q_PROPERTY("QStringList", "mimeFilter")]
		public List<string> MimeFilter {
			get { return (List<string>) interceptor.Invoke("mimeFilters", "mimeFilters()", typeof(List<string>)); }
			set { interceptor.Invoke("setMimeFilter?", "setMimeFilter(QStringList)", typeof(void), typeof(List<string>), value); }
		}
		// bool doNameFilter(const QString& arg1,const QList<QRegExp>& arg2); >>>> NOT CONVERTED
		/// <remarks>
		///  Create a directory lister.
		///    </remarks>		<short>    Create a directory lister.</short>
		public KDirLister(QObject parent) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KDirLister#", "KDirLister(QObject*)", typeof(void), typeof(QObject), parent);
		}
		public KDirLister() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KDirLister", "KDirLister()", typeof(void));
		}
		/// <remarks>
		///  Run the directory lister on the given url.
		///  This method causes KDirLister to emit _all_ the items of <code>_url</code>, in any case.
		///  Depending on <code>_keep</code> either clear() or clear(KUrl) will be
		///  emitted first.
		///  The newItems() signal may be emitted more than once to supply you
		///  with KFileItems, up until the signal completed() is emitted
		///  (and isFinished() returns true).
		/// <param> name="_url" the directory URL.
		/// </param><param> name="_flags" whether to keep previous directories, and whether to reload, see OpenUrlFlags
		/// </param></remarks>		<return> true    if successful,
		///          false   otherwise (e.g. invalid <code>_url</code>)
		///    </return>
		/// 		<short>    Run the directory lister on the given url.</short>
		[SmokeMethod("openUrl(const KUrl&, KDirLister::OpenUrlFlags)")]
		public virtual bool OpenUrl(KUrl _url, uint _flags) {
			return (bool) interceptor.Invoke("openUrl#$", "openUrl(const KUrl&, KDirLister::OpenUrlFlags)", typeof(bool), typeof(KUrl), _url, typeof(uint), _flags);
		}
		[SmokeMethod("openUrl(const KUrl&)")]
		public virtual bool OpenUrl(KUrl _url) {
			return (bool) interceptor.Invoke("openUrl#", "openUrl(const KUrl&)", typeof(bool), typeof(KUrl), _url);
		}
		/// <remarks>
		///  Stop listing all directories currently being listed.
		///  Emits canceled() if there was at least one job running.
		///  Emits canceled( KUrl ) for each stopped job if
		///  there are at least two dirctories being watched by KDirLister.
		///    </remarks>		<short>    Stop listing all directories currently being listed.</short>
		[SmokeMethod("stop()")]
		public virtual void Stop() {
			interceptor.Invoke("stop", "stop()", typeof(void));
		}
		/// <remarks>
		///  Stop listing the given directory.
		///  Emits canceled() if the killed job was the last running one.
		///  Emits canceled( KUrl ) for the killed job if
		///  there are at least two directories being watched by KDirLister.
		///  No signal is emitted if there was no job running for <code>_url.</code>
		/// <param> name="_url" the directory URL
		///    </param></remarks>		<short>    Stop listing the given directory.</short>
		[SmokeMethod("stop(const KUrl&)")]
		public virtual void Stop(KUrl _url) {
			interceptor.Invoke("stop#", "stop(const KUrl&)", typeof(void), typeof(KUrl), _url);
		}
		/// <remarks>
		///  Enable/disable automatic directory updating, when a directory changes
		///  (using KDirWatch).
		/// <param> name="enable" true to enable, false to disable
		///    </param></remarks>		<short>    Enable/disable automatic directory updating, when a directory changes  (using KDirWatch).</short>
		[SmokeMethod("setAutoUpdate(bool)")]
		public virtual void SetAutoUpdate(bool enable) {
			interceptor.Invoke("setAutoUpdate$", "setAutoUpdate(bool)", typeof(void), typeof(bool), enable);
		}
		/// <remarks>
		///  Enable or disable auto error handling is enabled.
		///  If enabled, it will show an error dialog to the user when an
		///  error occurs. It is turned on by default.
		/// <param> name="enable" true to enable auto error handling, false to disable
		/// </param><param> name="parent" the parent widget for the error dialogs, can be 0 for
		///                top-level
		/// </param></remarks>		<short>    Enable or disable auto error handling is enabled.</short>
		/// 		<see> autoErrorHandlingEnabled</see>
		public void SetAutoErrorHandlingEnabled(bool enable, QWidget parent) {
			interceptor.Invoke("setAutoErrorHandlingEnabled$#", "setAutoErrorHandlingEnabled(bool, QWidget*)", typeof(void), typeof(bool), enable, typeof(QWidget), parent);
		}
		/// <remarks>
		///  Changes the "is viewing dot files" setting.
		///  Calls updateDirectory() if setting changed.
		///  By default this option is disabled (hidden files will not be shown).
		/// <param> name="_showDotFiles" true to enable showing hidden files, false to
		///         disable
		/// </param></remarks>		<short>    Changes the "is viewing dot files" setting.</short>
		/// 		<see> showingDotFiles</see>
		[SmokeMethod("setShowingDotFiles(bool)")]
		public virtual void SetShowingDotFiles(bool _showDotFiles) {
			interceptor.Invoke("setShowingDotFiles$", "setShowingDotFiles(bool)", typeof(void), typeof(bool), _showDotFiles);
		}
		/// <remarks>
		///  Call this to list only directories.
		///  By default this option is disabled (all files will be shown).
		/// <param> name="dirsOnly" true to list only directories
		///    </param></remarks>		<short>    Call this to list only directories.</short>
		[SmokeMethod("setDirOnlyMode(bool)")]
		public virtual void SetDirOnlyMode(bool dirsOnly) {
			interceptor.Invoke("setDirOnlyMode$", "setDirOnlyMode(bool)", typeof(void), typeof(bool), dirsOnly);
		}
		/// <remarks>
		///  Returns the top level URL that is listed by this KDirLister.
		///  It might be different from the one given with openUrl() if there was a
		///  redirection. If you called openUrl() with <code>_keep</code> == true this is the
		///  first url opened (e.g. in a treeview this is the root).
		/// </remarks>		<return> the url used by this instance to list the files.
		///    </return>
		/// 		<short>    Returns the top level URL that is listed by this KDirLister.</short>
		public KUrl Url() {
			return (KUrl) interceptor.Invoke("url", "url() const", typeof(KUrl));
		}
		/// <remarks>
		///  Returns all URLs that are listed by this KDirLister. This is only
		///  useful if you called openUrl() with <code>_keep</code> == true, as it happens in a
		///  treeview, for example. (Note that the base url is included in the list
		///  as well, of course.)
		/// </remarks>		<return> the list of all listed URLs
		///    </return>
		/// 		<short>    Returns all URLs that are listed by this KDirLister.</short>
		public List<KUrl> Directories() {
			return (List<KUrl>) interceptor.Invoke("directories", "directories() const", typeof(List<KUrl>));
		}
		/// <remarks>
		///  Actually emit the changes made with setShowingDotFiles, setDirOnlyMode,
		///  setNameFilter and setMimeFilter.
		///    </remarks>		<short>    Actually emit the changes made with setShowingDotFiles, setDirOnlyMode,  setNameFilter and setMimeFilter.</short>
		[SmokeMethod("emitChanges()")]
		public virtual void EmitChanges() {
			interceptor.Invoke("emitChanges", "emitChanges()", typeof(void));
		}
		/// <remarks>
		///  Update the directory <code>_dir.</code> This method causes KDirLister to _only_ emit
		///  the items of <code>_dir</code> that actually changed compared to the current state in the
		///  cache and updates the cache.
		///  The current implementation calls updateDirectory automatically for
		///  local files, using KDirWatch (if autoUpdate() is true), but it might be
		///  useful to force an update manually.
		/// <param> name="_dir" the directory URL
		///    </param></remarks>		<short>    Update the directory <code>_dir.</code></short>
		[SmokeMethod("updateDirectory(const KUrl&)")]
		public virtual void UpdateDirectory(KUrl _dir) {
			interceptor.Invoke("updateDirectory#", "updateDirectory(const KUrl&)", typeof(void), typeof(KUrl), _dir);
		}
		/// <remarks>
		///  Returns true if no io operation is currently in progress.
		/// </remarks>		<return> true if finished, false otherwise
		///    </return>
		/// 		<short>    Returns true if no io operation is currently in progress.</short>
		public bool IsFinished() {
			return (bool) interceptor.Invoke("isFinished", "isFinished() const", typeof(bool));
		}
		/// <remarks>
		///  Returns the file item of the URL.
		///  Can return an empty KFileItem.
		/// </remarks>		<return> the file item for url() itself (".")
		///    </return>
		/// 		<short>    Returns the file item of the URL.</short>
		public KFileItem RootItem() {
			return (KFileItem) interceptor.Invoke("rootItem", "rootItem() const", typeof(KFileItem));
		}
		/// <remarks>
		///  Find an item by its URL.
		/// <param> name="_url" the item URL
		/// </param></remarks>		<return> the KFileItem
		///    </return>
		/// 		<short>    Find an item by its URL.</short>
		[SmokeMethod("findByUrl(const KUrl&) const")]
		public virtual KFileItem FindByUrl(KUrl _url) {
			return (KFileItem) interceptor.Invoke("findByUrl#", "findByUrl(const KUrl&) const", typeof(KFileItem), typeof(KUrl), _url);
		}
		/// <remarks>
		///  Find an item by its name.
		/// <param> name="name" the item name
		/// </param></remarks>		<return> the KFileItem
		///    </return>
		/// 		<short>    Find an item by its name.</short>
		[SmokeMethod("findByName(const QString&) const")]
		public virtual KFileItem FindByName(string name) {
			return (KFileItem) interceptor.Invoke("findByName$", "findByName(const QString&) const", typeof(KFileItem), typeof(string), name);
		}
		/// <remarks>
		///  Set a name filter to only list items matching this name, e.g. "*.cpp".
		///  You can set more than one filter by separating them with whitespace, e.g
		///  "*.cpp .h".
		///  Note: the directory is not automatically reloaded.
		/// <param> name="filter" the new filter, string() to disable filtering
		/// </param></remarks>		<short>    Set a name filter to only list items matching this name, e.</short>
		/// 		<see> matchesFilter</see>
		[SmokeMethod("setNameFilter(const QString&)")]
		public virtual void SetNameFilter(string filter) {
			interceptor.Invoke("setNameFilter$", "setNameFilter(const QString&)", typeof(void), typeof(string), filter);
		}
		/// <remarks>
		///  Set mime-based filter to only list items matching the given mimetypes.
		///  NOTE: setting the filter does not automatically reload directory.
		///  Also calling this function will not affect any named filter already set.
		/// <param> name="mimeList" a list of mime-types.
		/// </param></remarks>		<short>    Set mime-based filter to only list items matching the given mimetypes.</short>
		/// 		<see> clearMimeFilter</see>
		/// 		<see> matchesMimeFilter</see>
		[SmokeMethod("setMimeFilter(const QStringList&)")]
		public virtual void SetMimeFilter(List<string> mimeList) {
			interceptor.Invoke("setMimeFilter?", "setMimeFilter(const QStringList&)", typeof(void), typeof(List<string>), mimeList);
		}
		/// <remarks>
		///  Filtering should be done with KFileFilter. This will be implemented in a later
		///  revision of KDirLister. This method may be removed then.
		///  Set mime-based exclude filter to only list items not matching the given mimetypes
		///  NOTE: setting the filter does not automatically reload directory.
		///  Also calling this function will not affect any named filter already set.
		/// <param> name="mimeList" a list of mime-types.
		/// </param>   </remarks>		<short>    Filtering should be done with KFileFilter.</short>
		/// 		<see> clearMimeFilter</see>
		/// 		<see> matchesMimeFilter</see>
		public void SetMimeExcludeFilter(List<string> mimeList) {
			interceptor.Invoke("setMimeExcludeFilter?", "setMimeExcludeFilter(const QStringList&)", typeof(void), typeof(List<string>), mimeList);
		}
		/// <remarks>
		///  Clears the mime based filter.
		/// </remarks>		<short>    Clears the mime based filter.</short>
		/// 		<see> setMimeFilter</see>
		[SmokeMethod("clearMimeFilter()")]
		public virtual void ClearMimeFilter() {
			interceptor.Invoke("clearMimeFilter", "clearMimeFilter()", typeof(void));
		}
		/// <remarks>
		///  Checks whether <code>name</code> matches a filter in the list of name filters.
		/// </remarks>		<return> true if <code>name</code> matches a filter in the list,
		///  otherwise false.
		/// </return>
		/// 		<short>    Checks whether <code>name</code> matches a filter in the list of name filters.</short>
		/// 		<see> setNameFilter</see>
		public bool MatchesFilter(string name) {
			return (bool) interceptor.Invoke("matchesFilter$", "matchesFilter(const QString&) const", typeof(bool), typeof(string), name);
		}
		/// <remarks>
		///  Checks whether <code>mime</code> matches a filter in the list of mime types
		/// <param> name="mime" the mimetype to find in the filter list.
		/// </param></remarks>		<return> true if <code>name</code> matches a filter in the list,
		///  otherwise false.
		/// </return>
		/// 		<short>    Checks whether <code>mime</code> matches a filter in the list of mime types </short>
		/// 		<see> setMimeFilter.</see>
		public bool MatchesMimeFilter(string mime) {
			return (bool) interceptor.Invoke("matchesMimeFilter$", "matchesMimeFilter(const QString&) const", typeof(bool), typeof(string), mime);
		}
		/// <remarks>
		///  Pass the main window this object is associated with
		///  this is used for caching authentication data
		/// <param> name="window" the window to associate with, 0 to disassociate
		///    </param></remarks>		<short>    Pass the main window this object is associated with  this is used for caching authentication data </short>
		public void SetMainWindow(QWidget window) {
			interceptor.Invoke("setMainWindow#", "setMainWindow(QWidget*)", typeof(void), typeof(QWidget), window);
		}
		/// <remarks>
		///  Returns the main window associated with this object.
		/// </remarks>		<return> the associated main window, or 0 if there is none
		///    </return>
		/// 		<short>    Returns the main window associated with this object.</short>
		public QWidget MainWindow() {
			return (QWidget) interceptor.Invoke("mainWindow", "mainWindow()", typeof(QWidget));
		}
		/// <remarks>
		///  Returns the items listed for the current url().
		///  This method will NOT start listing a directory, you should only call
		///  this when receiving the finished() signal.
		///  The items in the KFileItemList are references to the items used
		///  by KDirLister, so e.g. an item gets destroyed when the deleteItem()
		///  signal is emitted.
		/// <param> name="which" specifies whether the returned list will contain all entries
		///               or only the ones that passed the nameFilter(), mimeFilter(),
		///               etc. Note that the latter causes iteration over all the
		///               items, filtering them. If this is too slow for you, use the
		///               newItems() signal, sending out filtered items in chunks.
		/// </param></remarks>		<return> the items listed for the current url().
		///    </return>
		/// 		<short>    Returns the items listed for the current url().</short>
		public List<KFileItem> Items(KDirLister.WhichItems which) {
			return (List<KFileItem>) interceptor.Invoke("items$", "items(KDirLister::WhichItems) const", typeof(List<KFileItem>), typeof(KDirLister.WhichItems), which);
		}
		public List<KFileItem> Items() {
			return (List<KFileItem>) interceptor.Invoke("items", "items() const", typeof(List<KFileItem>));
		}
		/// <remarks>
		///  Returns the items listed for the given <code>dir.</code>
		///  This method will NOT start listing <code>dir</code>, you should only call
		///  this when receiving the finished() signal.
		///  The items in the KFileItemList are references to the items used
		///  by KDirLister, so e.g. an item gets destroyed when the deleteItem()
		///  signal is emitted.
		/// <param> name="dir" specifies the url for which the items should be returned. This
		///             is only useful if you use KDirLister with multiple URLs
		///             i.e. using bool keep = true in openUrl().
		/// </param><param> name="which" specifies whether the returned list will contain all entries
		///               or only the ones that passed the nameFilter, mimeFilter, etc.
		///               Note that the latter causes iteration over all the items,
		///               filtering them. If this is too slow for you, use the
		///  newItems() signal, sending out filtered items in chunks.
		/// </param></remarks>		<return> the items listed for <code>dir.</code>
		///    </return>
		/// 		<short>    Returns the items listed for the given <code>dir.</code></short>
		public List<KFileItem> ItemsForDir(KUrl dir, KDirLister.WhichItems which) {
			return (List<KFileItem>) interceptor.Invoke("itemsForDir#$", "itemsForDir(const KUrl&, KDirLister::WhichItems) const", typeof(List<KFileItem>), typeof(KUrl), dir, typeof(KDirLister.WhichItems), which);
		}
		public List<KFileItem> ItemsForDir(KUrl dir) {
			return (List<KFileItem>) interceptor.Invoke("itemsForDir#", "itemsForDir(const KUrl&) const", typeof(List<KFileItem>), typeof(KUrl), dir);
		}
		/// <remarks>
		///  Called for every new item before emitting newItems().
		///  You may reimplement this method in a subclass to implement your own
		///  filtering.
		///  The default implementation filters out ".." and everything not matching
		///  the name filter(s)
		/// </remarks>		<return> true if the item is "ok".
		///          false if the item shall not be shown in a view, e.g.
		///  files not matching a pattern *.cpp ( KFileItem.IsHidden())
		/// </return>
		/// 		<short>    Called for every new item before emitting newItems().</short>
		/// 		<see> matchesFilter</see>
		/// 		<see> setNameFilter</see>
		[SmokeMethod("matchesFilter(const KFileItem&) const")]
		protected virtual bool MatchesFilter(KFileItem arg1) {
			return (bool) interceptor.Invoke("matchesFilter#", "matchesFilter(const KFileItem&) const", typeof(bool), typeof(KFileItem), arg1);
		}
		/// <remarks>
		///  Called for every new item before emitting newItems().
		///  You may reimplement this method in a subclass to implement your own
		///  filtering.
		///  The default implementation filters out ".." and everything not matching
		///  the name filter(s)
		/// </remarks>		<return> true if the item is "ok".
		///          false if the item shall not be shown in a view, e.g.
		///  files not matching a pattern *.cpp ( KFileItem.IsHidden())
		/// </return>
		/// 		<short>    Called for every new item before emitting newItems().</short>
		/// 		<see> matchesMimeFilter</see>
		/// 		<see> setMimeFilter</see>
		[SmokeMethod("matchesMimeFilter(const KFileItem&) const")]
		protected virtual bool MatchesMimeFilter(KFileItem arg1) {
			return (bool) interceptor.Invoke("matchesMimeFilter#", "matchesMimeFilter(const KFileItem&) const", typeof(bool), typeof(KFileItem), arg1);
		}
		/// <remarks>
		///  Called by the public matchesFilter() to do the
		///  actual filtering. Those methods may be reimplemented to customize
		///  filtering.
		/// <param> name="name" the name to filter
		/// </param><param> name="filters" a list of regular expressions for filtering
		///    </param></remarks>		<short>    Called by the public matchesFilter() to do the  actual filtering.</short>
		/// <remarks>
		///  Called by the public matchesMimeFilter() to do the
		///  actual filtering. Those methods may be reimplemented to customize
		///  filtering.
		/// <param> name="mime" the mime type to filter
		/// </param><param> name="filters" the list of mime types to filter
		///    </param></remarks>		<short>    Called by the public matchesMimeFilter() to do the  actual filtering.</short>
		[SmokeMethod("doMimeFilter(const QString&, const QStringList&) const")]
		protected virtual bool DoMimeFilter(string mime, List<string> filters) {
			return (bool) interceptor.Invoke("doMimeFilter$?", "doMimeFilter(const QString&, const QStringList&) const", typeof(bool), typeof(string), mime, typeof(List<string>), filters);
		}
		/// <remarks> Reimplement to customize error handling </remarks>		<short>   Reimplement to customize error handling </short>
		[SmokeMethod("handleError(KIO::Job*)")]
		protected virtual void HandleError(KIO.Job arg1) {
			interceptor.Invoke("handleError#", "handleError(KIO::Job*)", typeof(void), typeof(KIO.Job), arg1);
		}
		~KDirLister() {
			interceptor.Invoke("~KDirLister", "~KDirLister()", typeof(void));
		}
		public new void Dispose() {
			interceptor.Invoke("~KDirLister", "~KDirLister()", typeof(void));
		}
		protected new IKDirListerSignals Emit {
			get { return (IKDirListerSignals) Q_EMIT; }
		}
	}

	public interface IKDirListerSignals : IQObjectSignals {
		/// <remarks>
		///  Tell the view that we started to list <code>_url.</code> NOTE: this does _not_ imply that there
		///  is really a job running! I.e. KDirLister.Jobs() may return an empty list. In this case
		///  the items are taken from the cache.
		///  The view knows that openUrl should start it, so it might seem useless,
		///  but the view also needs to know when an automatic update happens.
		/// <param> name="_url" the URL to list
		///    </param></remarks>		<short>    Tell the view that we started to list <code>_url.</code></short>
		[Q_SIGNAL("void started(const KUrl&)")]
		void Started(KUrl _url);
		/// <remarks>
		///  Tell the view that listing is finished. There are no jobs running anymore.
		///    </remarks>		<short>    Tell the view that listing is finished.</short>
		[Q_SIGNAL("void completed()")]
		void Completed();
		/// <remarks>
		///  Tell the view that the listing of the directory <code>_url</code> is finished.
		///  There might be other running jobs left.
		/// <param> name="_url" the directory URL
		///    </param></remarks>		<short>    Tell the view that the listing of the directory <code>_url</code> is finished.</short>
		[Q_SIGNAL("void completed(const KUrl&)")]
		void Completed(KUrl _url);
		/// <remarks>
		///  Tell the view that the user canceled the listing. No running jobs are left.
		///    </remarks>		<short>    Tell the view that the user canceled the listing.</short>
		[Q_SIGNAL("void canceled()")]
		void Canceled();
		/// <remarks>
		///  Tell the view that the listing of the directory <code>_url</code> was canceled.
		///  There might be other running jobs left.
		/// <param> name="_url" the directory URL
		///    </param></remarks>		<short>    Tell the view that the listing of the directory <code>_url</code> was canceled.</short>
		[Q_SIGNAL("void canceled(const KUrl&)")]
		void Canceled(KUrl _url);
		/// <remarks>
		///  Signal a redirection.
		///  Only emitted if there's just one directory to list, i.e. most
		///  probably openUrl() has been called with <code>_keep</code> == <code>false.</code>
		/// <param> name="_url" the new URL
		///    </param></remarks>		<short>    Signal a redirection.</short>
		[Q_SIGNAL("void redirection(const KUrl&)")]
		void Redirection(KUrl _url);
		/// <remarks>
		///  Signal a redirection.
		/// <param> name="oldUrl" the original URL
		/// </param><param> name="newUrl" the new URL
		///    </param></remarks>		<short>    Signal a redirection.</short>
		[Q_SIGNAL("void redirection(const KUrl&, const KUrl&)")]
		void Redirection(KUrl oldUrl, KUrl newUrl);
		/// <remarks>
		///  Signal to clear all items.
		///  It must always be connected to this signal to avoid doubled items!
		///    </remarks>		<short>    Signal to clear all items.</short>
		[Q_SIGNAL("void clear()")]
		void Clear();
		/// <remarks>
		///  Signal to empty the directory <code>_url.</code>
		///  It is only emitted if the lister is holding more than one directory.
		/// <param> name="_url" the directory that will be emptied
		///    </param></remarks>		<short>    Signal to empty the directory <code>_url.</code></short>
		[Q_SIGNAL("void clear(const KUrl&)")]
		void Clear(KUrl _url);
		/// <remarks>
		///  Signal new items.
		///  So use this signal only if you want to modify original KFileItems
		/// <param> name="items" a list of new items
		///    </param></remarks>		<short>    Signal new items.</short>
		[Q_SIGNAL("void newItems(const KFileItemList&)")]
		void NewItems(List<KFileItem> items);
		/// <remarks>
		///  Send a list of items filtered-out by mime-type.
		/// <param> name="items" the list of filtered items
		///    </param></remarks>		<short>    Send a list of items filtered-out by mime-type.</short>
		[Q_SIGNAL("void itemsFilteredByMime(const KFileItemList&)")]
		void ItemsFilteredByMime(List<KFileItem> items);
		/// <remarks>
		///  Signal an item to remove.
		/// <param> name="_fileItem" the fileItem to delete
		///    </param></remarks>		<short>    Signal an item to remove.</short>
		[Q_SIGNAL("void deleteItem(const KFileItem&)")]
		void DeleteItem(KFileItem _fileItem);
		// void refreshItems(const QList<QPair<KFileItem, KFileItem> >& arg1); >>>> NOT CONVERTED
		/// <remarks>
		///  Emitted to display information about running jobs.
		///  Examples of message are "Resolving host", "Connecting to host...", etc.
		/// <param> name="msg" the info message
		///    </param></remarks>		<short>    Emitted to display information about running jobs.</short>
		[Q_SIGNAL("void infoMessage(const QString&)")]
		void InfoMessage(string msg);
		/// <remarks>
		///  Progress signal showing the overall progress of the KDirLister.
		///  This allows using a progress bar very easily. (see QProgressBar)
		/// <param> name="percent" the progress in percent
		///    </param></remarks>		<short>    Progress signal showing the overall progress of the KDirLister.</short>
		[Q_SIGNAL("void percent(int)")]
		void Percent(int percent);
		// void totalSize(KIO::filesize_t arg1); >>>> NOT CONVERTED
		// void processedSize(KIO::filesize_t arg1); >>>> NOT CONVERTED
		/// <remarks>
		///  Emitted to display information about the speed of the jobs.
		/// <param> name="bytes_per_second" the speed in bytes/s
		///    </param></remarks>		<short>    Emitted to display information about the speed of the jobs.</short>
		[Q_SIGNAL("void speed(int)")]
		void Speed(int bytes_per_second);
	}
}
