//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	namespace KParts {

	using System;
	using Qyoto;

	/// <remarks>
	///  Base class for an "editor" part.
	///  This class handles network transparency for you.
	///  Anything that can open a URL, allow modifications, and save
	///  (to the same URL or a different one).
	///  A read-write part can be set to read-only mode, using setReadWrite().
	///  Part writers :
	///  Any part inheriting ReadWritePart should check isReadWrite
	///  before allowing any action that modifies the part.
	///  The part probably wants to reimplement setReadWrite, disable those
	///  actions. Don't forget to call the parent setReadWrite.
	///   See <see cref="IReadWritePartSignals"></see> for signals emitted by ReadWritePart
	/// </remarks>		<short>    Base class for an "editor" part.</short>

	[SmokeClass("KParts::ReadWritePart")]
	public abstract class ReadWritePart : KParts.ReadOnlyPart {
 		protected ReadWritePart(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(ReadWritePart), this);
		}
		/// <remarks>
		///  Constructor
		///  See parent constructor for instructions.
		///      </remarks>		<short>    Constructor  See parent constructor for instructions.</short>
		public ReadWritePart(QObject parent) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("ReadWritePart#", "ReadWritePart(QObject*)", typeof(void), typeof(QObject), parent);
		}
		public ReadWritePart() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("ReadWritePart", "ReadWritePart()", typeof(void));
		}
		/// <remarks>
		/// </remarks>		<return> true if the part is in read-write mode
		///      </return>
		/// 		<short>   </short>
		public bool IsReadWrite() {
			return (bool) interceptor.Invoke("isReadWrite", "isReadWrite() const", typeof(bool));
		}
		/// <remarks>
		///  Changes the behavior of this part to readonly or readwrite.
		/// <param> name="readwrite" set to true to enable readwrite mode
		///      </param></remarks>		<short>    Changes the behavior of this part to readonly or readwrite.</short>
		[SmokeMethod("setReadWrite(bool)")]
		public virtual void SetReadWrite(bool readwrite) {
			interceptor.Invoke("setReadWrite$", "setReadWrite(bool)", typeof(void), typeof(bool), readwrite);
		}
		[SmokeMethod("setReadWrite()")]
		public virtual void SetReadWrite() {
			interceptor.Invoke("setReadWrite", "setReadWrite()", typeof(void));
		}
		/// <remarks>
		/// </remarks>		<return> true if the document has been modified.
		///      </return>
		/// 		<short>   </short>
		public bool IsModified() {
			return (bool) interceptor.Invoke("isModified", "isModified() const", typeof(bool));
		}
		/// <remarks>
		///  If the document has been modified, ask the user to save changes.
		///  This method is meant to be called from KMainWindow.QueryClose().
		///  It will also be called from closeUrl().
		/// </remarks>		<return> true if closeUrl() can be called without the user losing
		///  important data, false if the user chooses to cancel.
		///      </return>
		/// 		<short>    If the document has been modified, ask the user to save changes.</short>
		[SmokeMethod("queryClose()")]
		public virtual bool QueryClose() {
			return (bool) interceptor.Invoke("queryClose", "queryClose()", typeof(bool));
		}
		/// <remarks>
		///  Called when closing the current url (e.g. document), for instance
		///  when switching to another url (note that openUrl() calls it
		///  automatically in this case).
		///  If the current URL is not fully loaded yet, aborts loading.
		///  If isModified(), queryClose() will be called.
		/// </remarks>		<return> false on cancel
		///      </return>
		/// 		<short>    Called when closing the current url (e.</short>
		[SmokeMethod("closeUrl()")]
		public override bool CloseUrl() {
			return (bool) interceptor.Invoke("closeUrl", "closeUrl()", typeof(bool));
		}
		/// <remarks>
		///  Call this method instead of the above if you need control if
		///  the save prompt is shown. For example, if you call queryClose()
		///  from KMainWindow.QueryClose(), you would not want to prompt
		///  again when closing the url.
		///  Equivalent to promptToSave ? closeUrl() : ReadOnlyPart.CloseUrl()
		///      </remarks>		<short>    Call this method instead of the above if you need control if  the save prompt is shown.</short>
		[SmokeMethod("closeUrl(bool)")]
		public virtual bool CloseUrl(bool promptToSave) {
			return (bool) interceptor.Invoke("closeUrl$", "closeUrl(bool)", typeof(bool), typeof(bool), promptToSave);
		}
		/// <remarks>
		///  Save the file to a new location.
		///  Calls save(), no need to reimplement
		///      </remarks>		<short>    Save the file to a new location.</short>
		[SmokeMethod("saveAs(const KUrl&)")]
		public virtual bool SaveAs(KUrl url) {
			return (bool) interceptor.Invoke("saveAs#", "saveAs(const KUrl&)", typeof(bool), typeof(KUrl), url);
		}
		/// <remarks>
		///   Sets the modified flag of the part.
		///      </remarks>		<short>     Sets the modified flag of the part.</short>
		[SmokeMethod("setModified(bool)")]
		public virtual void SetModified(bool modified) {
			interceptor.Invoke("setModified$", "setModified(bool)", typeof(void), typeof(bool), modified);
		}
		/// <remarks>
		///  Call setModified() whenever the contents get modified.
		///  This is a slot for convenience, so that you can connect it
		///  to a signal, like textChanged().
		///      </remarks>		<short>    Call setModified() whenever the contents get modified.</short>
		[Q_SLOT("void setModified()")]
		[SmokeMethod("setModified()")]
		public virtual void SetModified() {
			interceptor.Invoke("setModified", "setModified()", typeof(void));
		}
		/// <remarks>
		///  Save the file in the location from which it was opened.
		///  You can connect this to the "save" action.
		///  Calls saveFile() and saveToUrl(), no need to reimplement.
		///      </remarks>		<short>    Save the file in the location from which it was opened.</short>
		[Q_SLOT("bool save()")]
		[SmokeMethod("save()")]
		public virtual bool Save() {
			return (bool) interceptor.Invoke("save", "save()", typeof(bool));
		}
		/// <remarks>
		///  Waits for any pending upload job to finish and returns whether the
		///  last save() action was successful.
		///      </remarks>		<short>    Waits for any pending upload job to finish and returns whether the  last save() action was successful.</short>
		[Q_SLOT("bool waitSaveComplete()")]
		public bool WaitSaveComplete() {
			return (bool) interceptor.Invoke("waitSaveComplete", "waitSaveComplete()", typeof(bool));
		}
		/// <remarks>
		///  Save to a local file.
		///  You need to implement it, to save to the local file.
		///  The framework takes care of re-uploading afterwards.
		/// </remarks>		<return> true on success, false on failure.
		///  On failure the function should inform the user about the
		///  problem with an appropriate message box. Standard error
		///  messages can be constructed using KIO.BuildErrorString()
		///  in combination with the error codes defined in kio/global.h
		///      </return>
		/// 		<short>    Save to a local file.</short>
		[SmokeMethod("saveFile()")]
		protected abstract bool SaveFile();
		/// <remarks>
		///  Save the file.
		///  Uploads the file, if <code>url</code> is remote.
		///  This will emit started(), and either completed() or canceled(),
		///  in case you want to provide feedback.
		/// </remarks>		<return> true on success, false on failure.
		///      </return>
		/// 		<short>    Save the file.</short>
		[SmokeMethod("saveToUrl()")]
		protected virtual bool SaveToUrl() {
			return (bool) interceptor.Invoke("saveToUrl", "saveToUrl()", typeof(bool));
		}
		protected new IReadWritePartSignals Emit {
			get { return (IReadWritePartSignals) Q_EMIT; }
		}
	}

	public interface IReadWritePartSignals : KParts.IReadOnlyPartSignals {
		/// <remarks>
		///  set handled to true, if you don't want the default handling
		///  set abortClosing to true, if you handled the request,
		///  but for any reason don't  want to allow closing the document
		///      </remarks>		<short>    set handled to true, if you don't want the default handling  set abortClosing to true, if you handled the request,  but for any reason don't  want to allow closing the document      </short>
		[Q_SIGNAL("void sigQueryClose(bool*, bool*)")]
		void SigQueryClose(ref bool handled, ref bool abortClosing);
	}
	}
}
