#
# Find the FFMPEG includes and library
#

FIND_PATH(LIBFFMPEG_INCLUDE_DIR 
  NAMES ffmpeg/avformat.h
  PATHS ${MLT_PATH}/include /usr/local/include /usr/include
  NO_DEFAULT_PATH
)

MESSAGE(STATUS "Found FFMPEG INCLUDES: ${LIBFFMPEG_INCLUDE_DIR}")

FIND_LIBRARY(LIBFFMPEG_LIBRARY
  NAMES avformat
  PATHS ${MLT_PATH}/lib /usr/lib /usr/local/lib
  NO_DEFAULT_PATH
)

MESSAGE(STATUS "Found FFMPEG LIBR: ${LIBFFMPEG_LIBRARY}")

IF (LIBFFMPEG_LIBRARY AND LIBFFMPEG_INCLUDE_DIR)
  SET( LIBFFMPEG_FOUND 1 )
  SET( LIBFFMPEG_LIBRARIES ${LIBFFMPEG_LIBRARY} )
ELSE (LIBFFMPEG_LIBRARY AND LIBFFMPEG_INCLUDE_DIR)
  SET( LIBFFMPEG_FOUND 0 )
ENDIF (LIBFFMPEG_LIBRARY AND LIBFFMPEG_INCLUDE_DIR)

IF (LIBFFMPEG_FOUND)
  IF (NOT LIBFFMPEG_FIND_QUIETLY)
    MESSAGE(STATUS "Found FFMPEG library: ${LIBFFMPEG_LIBRARY}")
  ENDIF (NOT LIBFFMPEG_FIND_QUIETLY)
ELSE (LIBFFMPEG_FOUND)
  IF (LIBFFMPEG_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "Could not find FFMPEG library")
  ENDIF (LIBFFMPEG_FIND_REQUIRED)
ENDIF (LIBFFMPEG_FOUND)

