/*
 *
 * Copyright (C) 2002 Stefan Hellwig <stefan@stefanhellwig.de>
 *
 *   This program is free software; you can redistribute it and/or modify 
 *   it under the terms of the GNU General Public License as published by 
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#ifndef _SAVERCONTROL_H
#define _SAVERCONTROL_H

/**
 * KDE ScreenSaver Control class
 *
 * This class can be used by either creating a new object and
 * using the regular ("dynamic") methods to get the status of
 * the KDE screensaver or to enable/disable it.
 *
 * You can also call the static methods of this class directly
 * from within another class to control the KDE screensaver or
 * to get its current status.
 *
 */
class SaverControl
{
       
public:
    /* ------------------- DYNAMIC METHODS --------------------- */

    SaverControl();
    ~SaverControl();
    
    /**
     * Get the DCOP interface to communicate with the KDE screensaver
     */
    bool getSaverDCOPIface();

    /**
     * Get the current status of the KDE screensaver. Usually only
     * called once on startup of the application to find out if we
     * have to enable it later on when the application is stopped.
     * This method is using DCOP to communicate with the screensaver.
     */
    bool isScreenSaverEnabled();

    /**
     * Disable the KDE screensaver if TRUE is passed to this slot.
     * Uses the DCOP interface to communicate with the screensaver.
     */
    void disableScreenSaver( bool disable );
    
    /* ------------------- STATIC METHODS --------------------- */
    
    /**
     * Static accessor method to get the status of the screensaver.
     * Returns true if the KDE screensaver is currently enabled,
     * false if it is disabled.
     */
    static bool getSaverStatus();

    /**
     * Static accessor method to disable the screensaver. Returns
     * true if the operation was successful, false if it was not.
     */
    static bool disableSaver();

    /**
     * Static accessor method to enable the screensaver. Returns
     * true if the operation was successful, false if it was not.
     */
    static bool enableSaver();

    /**
     * Static accessor method to enable or disable the screen-
     * saver, depending on the provided parameter.
     */
    static bool toggleSaver( bool enable );

private:

    // DCOP variables to control the KDE screensaver and a
    // variable to hold the info if it was enabled on startup
    // (used by the dynamic methods)

    bool        dcop_KDESaver;
    QByteArray  dcop_data;
    QCString    dcop_screenSaverApp, dcop_screenSaverObj;
    bool	      saverWasEnabled;

};

#endif

