/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */


#include "miscmanager.h"

#include "kdetvmiscplugin.h"
#include "pluginfactory.h"
#include <kdebug.h>


MiscManager::MiscManager(PluginFactory *pf, QWidget* view)
    : _view(view),
      _pf(pf)
{
    scanPlugins();
}

MiscManager::~MiscManager()
{
    while (KdetvMiscPlugin *p = _plugs.first()) {
        p->destroy();
        _plugs.remove(p);
    }
}

void MiscManager::scanPlugins()
{
    if (!_view) {
        //        kdDebug() << "MiscManager: Info: No screenwidget set. Cannot scan Misc plugins." << endl;
        return;
    }

    QPtrList<PluginDesc>& miscPlugins(_pf->miscPlugins());
    
    for (PluginDesc *plug = miscPlugins.first(); plug;
         plug = miscPlugins.next()) {
        bool skip = false;
        for (KdetvMiscPlugin *p = _plugs.first(); p; p = _plugs.next()) {
            if (p->pluginDescription() == plug) {
                if (!plug->enabled) {
                    _plugs.remove(p);
                    p->destroy();
                }
                skip = true;
                break;
            }
        }
	
        if (skip)
            continue;

        kdDebug() << "MiscManager: Found a plugin: " << plug->name << endl;
        if (plug->enabled) {
            KdetvMiscPlugin *p = _pf->getMiscPlugin(plug, _view);
            if (p)
                _plugs.append(p);
        } else
            kdDebug() << "MiscManager: The plugin is disabled" << endl;
    }
}

bool MiscManager::filterNumberKey(int key)
{
    for (KdetvMiscPlugin *p = _plugs.first(); p; p = _plugs.next())
        if (p->filterNumberKey(key))
            return true;
    return false;
}

void MiscManager::setScreen(QWidget* screen)
{
    _view = screen;
    scanPlugins();
}

#include "miscmanager.moc"

// vim: sw=4 ts=4
