/***************************************************************************
                           DScalerFilterTomsmocomp.cpp
                           ---------------------------
    begin                : Sat Jul 10 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
***************************************************************************/

/*
 * TomsMoComp algorithm taken from DScaler.
 * Copyright (c) 2002 Tom Barry.  All rights reserved.
 *
 * Ported by: Dirk Ziegelmeier
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */

#include <stdlib.h>

#include <klocale.h>

#include "dscalerfiltertomsmocomp.h"
#include "tomsmocompmacros.h"
#include "x86-64_macros.inc"

DScalerFilterTomsMoComp::DScalerFilterTomsMoComp()
    : KdetvDScalerFilter(i18n("TomsMoComp")),
      SearchEffort(SEARCHEFFORT_DEFAULT),
      UseStrangeBob(USESTRANGEBOB_DEFAULT)
{
}


DScalerFilterTomsMoComp::~DScalerFilterTomsMoComp()
{
}

#define IS_MMX
#define SSE_TYPE MMX
#define FUNCT_NAME DScalerFilterTomsMoComp::filterDScaler_MMX
#include "TomsMoCompAll.inc"
#undef  IS_MMX
#undef  SSE_TYPE
#undef  FUNCT_NAME

#define IS_3DNOW
#define SSE_TYPE 3DNOW
#define FUNCT_NAME DScalerFilterTomsMoComp::filterDScaler_3DNOW
#include "TomsMoCompAll.inc"
#undef  IS_3DNOW
#undef  SSE_TYPE
#undef  FUNCT_NAME

#define IS_SSE
#define SSE_TYPE SSE
#define FUNCT_NAME DScalerFilterTomsMoComp::filterDScaler_SSE
#include "TomsMoCompAll.inc"
#undef  IS_SSE
#undef  SSE_TYPE
#undef  FUNCT_NAME

int DScalerFilterTomsMoComp::Fieldcopy(void *dest, const void *src, size_t count,
                                       int rows, int dst_pitch, int src_pitch)
{
    unsigned char* pDest = (unsigned char*) dest;
    unsigned char* pSrc = (unsigned char*) src;
    int i;

    for (i=0; i < rows; i++) {
        pMyMemcpy(pDest, pSrc, count);
        pSrc += src_pitch;
        pDest += dst_pitch;
    }
    return 0;
}
