// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */



#ifndef __KDETVHAZE_PLUGIN_H
#define __KDETVHAZE_PLUGIN_H

#include <kdetvosdplugin.h>
#include <qtimer.h>
#include <qlabel.h>


class TransparentLabel : public QLabel
{
public:
    TransparentLabel(QWidget *parent = 0, const char *name = 0);
    virtual ~TransparentLabel();
    
    virtual void updateMask();
};

/**
 * Haze OSD Plugin
 */
class KdetvHaze : public KdetvOSDPlugin
{
    Q_OBJECT

public:
    KdetvHaze(Kdetv *ktv, QWidget *parent = 0, const char* name = 0);
    virtual ~KdetvHaze();

public slots:
    virtual void displayMisc(const QString& text);
    virtual void displayChannel(int channel, const QString& name);
    virtual void displayMuted(bool muted);
    virtual void displayVolume(int vol);
    virtual void displayCC(const QString& text);
    virtual void clear();

    void viewResized(int w, int h);

    void colourKeyChanged(QColor key);

private:
    TransparentLabel _lower;
    QLabel _cc;
    QWidget* _parent;
    QTimer _timer;
    void displayLower();
};


#endif

