/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 Thomas Nagy                            *
 *   Thomas Nagy <tnagyemail-com@yahoo.fr>                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <kiconloader.h>
#include <klocale.h>
#include <kdebug.h>

#include "settings.h"
#include "DCanvasView.h"
#include "DCanvasPopup.h"
#include "DDataControl.h"

DCanvasPopup::DCanvasPopup(QWidget *parent) : KPopupMenu(parent)
{
	m_canvas = (DCanvasView*) parent;

	// new object on the canvas / canvas manipulation
	QString label_newitem = i18n("New Item");
	if (m_canvas->itemsAreSelected()) label_newitem = i18n("New Child");
	insertItem(label_newitem, e_item);

	// edit actions
	if ( m_canvas->itemsAreSelected() )
	{
		insertSeparator();
		insertItem(i18n("Delete"), e_delete);

		insertSeparator();
	}

	// disconnect actions
	KPopupMenu *disc_pop = new KPopupMenu(this, i18n("Disconnect"));

	disc_pop->insertItem(i18n("Parent"), e_discon_parent);
	disc_pop->insertItem(i18n("Object(s)"), e_discon_obj);
	disc_pop->insertItem(i18n("Subtree"), e_discon_subtree);
	if (m_canvas->selectedRef())
		disc_pop->insertItem(i18n("Reference"), e_discon_link);
	else if (m_canvas->selectedLink())
		disc_pop->insertItem(i18n("Link"), e_discon_link);

	if (!m_canvas->oneItemIsSelected()) disc_pop->setItemEnabled(e_discon_parent, false);

	if (m_canvas->oneItemIsSelected())
	{
		insertItem(i18n("Select Subtree"), e_select_subtree);
		insertSeparator();
	}

	insertItem( i18n("Disconnect"), disc_pop);

	if (disc_pop) connect(disc_pop, SIGNAL(activated(int)), this, SIGNAL(activated(int)));

	if (m_canvas->oneItemIsSelected())
	{
		DDataItem *item = m_canvas->dataTree()->singleSelection();
		if (item)
		{
			bool hasparent = (item->Parent() != DItem::NOITEM);
			bool haschild  = (item->countChildren() > 0);

			setItemEnabled(e_discon_parent, hasparent);
			setItemEnabled(e_discon_obj, hasparent && haschild);
			setItemEnabled(e_discon_subtree, haschild);

			disc_pop->setEnabled( haschild || hasparent );
		}
	}
	else if (m_canvas->itemsAreSelected())
	{
		setItemEnabled(e_discon_subtree, m_canvas->oneItemIsSelected());
		setItemEnabled(e_discon_obj, m_canvas->itemsAreSelected());
		disc_pop->setEnabled( true );
	}
	else if (m_canvas->selectedRef() || m_canvas->selectedLink())
	{
		disc_pop->setEnabled( true );
		setItemEnabled(e_discon_parent, false);
		setItemEnabled(e_discon_obj, false);
		setItemEnabled(e_discon_subtree, false);
	}

	insertSeparator();

	KPopupMenu *tidy_pop = new KPopupMenu(this, i18n("Tidy"));

	tidy_pop->insertItem(i18n("Quick Reorganization"), e_tidy_clean);
	tidy_pop->insertItem(i18n("Smart Reorganization (tm)"), e_tidy_all);
	tidy_pop->insertItem(i18n("Unclutter Mindmap"), e_tidy_unclutter);

	insertItem( i18n("Tidy"), tidy_pop);
	connect(tidy_pop, SIGNAL(activated(int)), this, SIGNAL(activated(int)));

	tidy_pop->setEnabled(true);
	insertSeparator();

	KPopupMenu *col_pop = new KPopupMenu(this, i18n("Colors"));

	col_pop->insertItem(i18n("Default Color"), Settings::EnumColorMode::default_);
	if (Settings::annotation(Settings::EnumColorMode::theme1_).length())
		col_pop->insertItem(Settings::annotation(Settings::EnumColorMode::theme1_), Settings::EnumColorMode::theme1_);
	else
		col_pop->insertItem(i18n("Theme 1"), Settings::EnumColorMode::theme1_);

	if (Settings::annotation(Settings::EnumColorMode::theme2_).length())
		col_pop->insertItem(Settings::annotation(Settings::EnumColorMode::theme2_), Settings::EnumColorMode::theme2_);
	else
		col_pop->insertItem(i18n("Theme 2"), Settings::EnumColorMode::theme2_);

	if (Settings::annotation(Settings::EnumColorMode::theme3_).length())
		col_pop->insertItem(Settings::annotation(Settings::EnumColorMode::theme3_), Settings::EnumColorMode::theme3_);
	else
		col_pop->insertItem(i18n("Theme 3"), Settings::EnumColorMode::theme3_);

	if (Settings::annotation(Settings::EnumColorMode::theme4_).length())
		col_pop->insertItem(Settings::annotation(Settings::EnumColorMode::theme4_), Settings::EnumColorMode::theme4_);
	else
		col_pop->insertItem(i18n("Theme 4"), Settings::EnumColorMode::theme4_);

	if (Settings::annotation(Settings::EnumColorMode::theme5_).length())
		col_pop->insertItem(Settings::annotation(Settings::EnumColorMode::theme5_), Settings::EnumColorMode::theme5_);
	else
		col_pop->insertItem(i18n("Theme 5"), Settings::EnumColorMode::theme5_);

	if (Settings::annotation(Settings::EnumColorMode::theme6_).length())
		col_pop->insertItem(Settings::annotation(Settings::EnumColorMode::theme6_), Settings::EnumColorMode::theme6_);
	else
		col_pop->insertItem(i18n("Theme 6"), Settings::EnumColorMode::theme6_);

	col_pop->insertSeparator();
	col_pop->insertItem(i18n("Custom..."), Settings::EnumColorMode::custom_);

	if (m_canvas->oneItemIsSelected())
	{
		DDataItem *item = m_canvas->dataTree()->singleSelection();
		if (item) col_pop->setItemChecked( item->colorScheme(), true);
	}

	connect(col_pop, SIGNAL(activated(int)), this, SIGNAL(activated(int)));

	insertItem( i18n("Colors"), col_pop);
	col_pop->setEnabled( m_canvas->itemsAreSelected() );

	insertItem(i18n("Select Font..."), e_font);
	setItemEnabled(e_font, m_canvas->itemsAreSelected() );

	KPopupMenu *align_pop = new KPopupMenu(this, i18n("Align and Distribute"));
	align_pop->insertItem(i18n("Align Top"), e_align_top);
	align_pop->insertItem(i18n("Align Bottom"), e_align_bottom);
	align_pop->insertItem(i18n("Align Left"), e_align_left);
	align_pop->insertItem(i18n("Align Right"), e_align_right);
	align_pop->insertSeparator();
	align_pop->insertItem(i18n("Distribute Horizontal"), e_distribute_horiz);
	align_pop->insertItem(i18n("Distribute Vertical"), e_distribute_vert);

	connect(align_pop, SIGNAL(activated(int)), this, SIGNAL(activated(int)));
	insertItem(i18n("Align and Distribute"), align_pop);
	align_pop->setEnabled( m_canvas->itemsAreSelected() and not m_canvas->oneItemIsSelected() );
}
