/* 
 *  Copyright (C) 2004 Girish Ramakrishnan All Rights Reserved.
 *    
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

// $Id: main.cpp,v 1.7 2004/11/08 07:14:18 cs19713 Exp $

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>

#include <qdir.h>
#include "kdocker.h"
#include "traylabelmgr.h"
#include "trace.h"
#include <X11/Xlib.h>

static void sighandler(int sig)
{
  if (sig == SIGUSR1)
  {
    DUMP_TRACE(QDir::homeDirPath() + "/kdocker.trace");
    return;
  }
  
  qDebug(qApp->translate("KDocker", "Caught signal %1. Cleaning up.").arg(sig));
  ((KDocker *)qApp)->trayLabelMgr()->undockAll();
}

int main(int argc, char *argv[])
{
  // setup signal handlers that undock and quit
  signal(SIGHUP, sighandler);
  signal(SIGSEGV, sighandler);
  signal(SIGTERM, sighandler);
  signal(SIGINT, sighandler);
  signal(SIGUSR1, sighandler);

  KDocker app(argc, argv);
  return app.exec();
}
