/***************************************************************************
 *   Copyright (C) 2005 by Debajyoti Bera <dbera.web@gmail.com>            *
 *   Copyright (C) 2005 Novell, Inc.                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA           *
 ***************************************************************************/

#ifndef BEAGLESEARCH_H
#define BEAGLESEARCH_H

#include <qobject.h>
#include <qthread.h>
#include <qstringlist.h>
#include <qregexp.h>
#include <qmutex.h>

extern "C" {
#include <glib.h>
#include <beagle/beagle.h>
#include <beagle/beagle-query-part-property.h>
}

#define RESULTFOUND (QEvent::Type)1001 /* QEvent::User + 1 */
#define RESULTGONE  (QEvent::Type)1002 /* QEvent::User + 2 */
#define SEARCHOVER  (QEvent::Type)1003 /* QEvent::User + 3 */
#define KILLME      (QEvent::Type)1004 /* QEvent::User + 4 */

/**
  Interface to beagle-query
*/
class BeagleSearch : public QThread {

public:

enum TileGroup {
	Application=1, 	// in scope list
	Contact,
	Folder,
	Documents,  	// in scope list
	Conversations,  // in scope list
	Image,  	// in scope list
	Audio,  	// in scope list
	Video,  	// in scope list
	Website,        // in scope list
	Feed,
	Note,
	Packages,
	Unknown
};

typedef QValueList<QString> PropertyList;

class beagle_result_struct {
public:
        beagle_result_struct () {
                uri = NULL;
                parent_uri = NULL;
                source = NULL;
                mime_type = NULL;
                snippet = NULL;
                last_index_time = 0;
                show_expanded = false;
        }       
        
        ~beagle_result_struct () {
                delete uri;
                delete parent_uri;
                delete source;
                delete mime_type;
                delete snippet;
        }       
        
        QString         *uri;
        QString         *parent_uri;
        QString         *source;
        PropertyList    properties;
        QString         hit_type;
        QString         *mime_type;
        time_t          last_index_time;
        double          score;
        QString         *snippet;
        TileGroup       tilegroup;
        int             client_id;
        bool            show_expanded;
};

typedef QPtrList<beagle_result_struct> BeagleResultList;

typedef QValueList<QString> VanishedURIList;

class BeagleVanishedURIList {
public:
        BeagleVanishedURIList() {
                client_id = 0;
        }

        ~BeagleVanishedURIList () {}

        int             client_id;
	VanishedURIList list;
};

    BeagleSearch(int id, QObject *parent, QString term);
    ~BeagleSearch();

    virtual void run();

    void stopClient();

    int id;
    bool kill_me;

private:
	QObject	       *parent;

	static void hits_added_cb (BeagleQuery *, BeagleHitsAddedResponse *, BeagleSearch* client);
	static void hits_subtracted_cb (BeagleQuery *, BeagleHitsSubtractedResponse *, BeagleSearch* client);
	static void finished_cb (BeagleQuery *, BeagleFinishedResponse *, BeagleSearch* client);

	static QString *get_uri_from_feed_hit (BeagleHit *);
	static QString *get_uri_from_file_hit (BeagleHit *);
	static QString *get_parent_uri_from_file_hit (BeagleHit *);
	static QString *get_source_from_file_hit (BeagleHit *);

	QMutex *client_mutex;

	BeagleClient   *client;
	BeagleQuery    *query;
	GMainLoop      *main_loop;
};

#endif
