
#  _   _______                 _ _ _   _       _   _  __ _
# | | / /  __ \               (_) | \ | |     | | (_)/ _(_)
# | |/ /| |  \/_ __ ___   __ _ _| |  \| | ___ | |_ _| |_ _  ___ _ __
# |    \| | __| '_ ` _ \ / _` | | | . ` |/ _ \| __| |  _| |/ _ \ '__|
# | |\  \ |_\ \ | | | | | (_| | | | |\  | (_) | |_| | | | |  __/ |
# \_| \_/\____/_| |_| |_|\__,_|_|_\_| \_/\___/ \__|_|_| |_|\___|_|

############################################################################
#    Copyright (C) 2007 by Marcel Hasler                                   #
#    mahasler@gmail.com                                                    #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License version 2        #
#    as published by the Free Software Foundation.                         #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

import gmailatom
import socket

class AccountManager:
	def __init__(self,name,password):
		
		# Set up
		self.accountName = name
		self.accountPassword = password
		self.account = gmailatom.GmailAtom(self.accountName, self.accountPassword)
		self.oldUnreadMsgCount = 0
		self.unreadMsgCount = 0


	def Connect(self):
		self.account.refreshInfo()


	def SetConnectionTimeout(self, timeout):
		# Timeout in seconds
		socket.setdefaulttimeout(timeout)


	def GetUnreadMailCount(self):
		self.unreadMsgCount = self.account.getUnreadMsgCount()
		if self.unreadMsgCount < self.oldUnreadMsgCount:
			self.oldUnreadMsgCount = self.unreadMsgCount
		return self.unreadMsgCount


	def HasNewMail(self):
		self.unreadMsgCount = self.account.getUnreadMsgCount()
		
		if self.unreadMsgCount > self.oldUnreadMsgCount:
			self.oldUnreadMsgCount = self.unreadMsgCount
			return True
		else:
			self.oldUnreadMsgCount = self.unreadMsgCount
			return False


	def GetLastSenderAddress(self):
		return self.account.getMsgAuthorEmail(0)


	def GetLastMessageTitle(self):
		return self.account.getMsgTitle(0)


	def UpdateAccount(self,name,password):
		if name != self.accountName or password != self.accountPassword:
			del self.account
			self.accountName = name
			self.accountPassword = password
			self.account = gmailatom.GmailAtom(self.accountName, self.accountPassword)
		