/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef KHALKHI_PROPERTYSERVICE_H
#define KHALKHI_PROPERTYSERVICE_H


// lib
#include "service.h"


namespace Khalkhi {

class PropertyAdapter;

// TODO: store here ability to support lists?

// TODO: show unavailability instead of ignoring? Or both, chosen by service?
/**
 * Base class for all services.
 *
 * A service operates on an item of a given property of a person.
 * 
 */
class KDE_EXPORT PropertyService : public Service
{
protected:
    PropertyService( QObject* Parent, const char* Name, const QStringList& Arguments );
public:
    virtual ~PropertyService();

public: // interface
    /** */
    virtual void setAdapter( PropertyAdapter *Adapter );

public:
    /** @return the servicetype unique identifier of the service */
    const PropertyAdapter *adapter() const;

protected:
    PropertyAdapter *Adapter;
};


inline PropertyService::PropertyService( QObject* Parent, const char* Name, const QStringList& Arguments )
: Service( Parent, Name, Arguments ) {}
inline PropertyService::~PropertyService() {}

inline const PropertyAdapter *PropertyService::adapter() const { return Adapter; }
inline void PropertyService::setAdapter( PropertyAdapter *A ) { Adapter = A; }

}

#endif
