/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef KHALKHI_SERVICE_H
#define KHALKHI_SERVICE_H


// qt specific
#include <qobject.h>
#include <qstringlist.h>
// kde
#include <kdemacros.h>

namespace Khalkhi {

// TODO: show unavailability instead of ignoring? Or both, chosen by service?
/**
 * Base class for all services.
 *
 * A service operates on an item of a given property of a person.
 * 
 */
class KDE_EXPORT Service : public QObject
{
public:
    enum EntryFlags {
        NoFlags = 0,
        /**  */
        ReferItem = 1,
        /** */
        Always = 2 };

protected:
    Service( QObject* Parent, const char* Name, const QStringList& Arguments );
public:
    ~Service();

public:
    /** this function gets called if the service gets changed
     * reimplement it if your service is configurable
     * The function defaults to a noop.
     * TODO: should services handle this themselves? what if they depend on third parties configuration?
     */
    virtual void reloadConfig();

public:
    /** @return the servicetype unique identifier of the service */
    const QString &id() const;
    bool fitsIn( const QString &Context ) const;

private:
    QString Id;
    QStringList OnlyShowInContext;
    QStringList NotShowInContext;
};

}

#endif
