/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef PROPERTYALLDATAACTIONSERVICEMENUFILLER_H
#define PROPERTYALLDATAACTIONSERVICEMENUFILLER_H


// qt specific
#include <qobject.h>
#include <qstringlist.h>
// kde specific
#include <kabc/addressee.h>
// khalkhi core
#include "propertyalldataactionserviceclient.h"

class QPopupMenu;

namespace Khalkhi {


class KDE_EXPORT PropertyAllDataActionServiceMenuFiller : public QObject, public PropertyAllDataActionServiceClient
{
    Q_OBJECT
public:
    PropertyAllDataActionServiceMenuFiller();
    virtual ~PropertyAllDataActionServiceMenuFiller();

public:
    void set( const KABC::Addressee& Person, const QString &PropertyId, int ItemIndex, QMimeSource *DataSource );
    int fillMenu( QPopupMenu *Menu, int BaseMenuId );

public: // AllServiceClient API
    virtual int itemIndex() const;
    virtual QString propertyId() const;
    virtual void onAllDataActionServiceChange();

public: // DropServiceClient API
    virtual const KABC::Addressee &person() const;
    virtual QMimeSource *dataSource() const;
    virtual void onDataActionServiceStateChange( const PropertyDataActionService &Service, int Change,
                                                 int ItemIndex );

protected slots:
    void onMenuSelection( int Id );
    void onMenuDestruction();

protected:
    KABC::Addressee Person;
    QString PropertyId;
    int ItemIndex;
    QMimeSource *DataSource;

    QPopupMenu *Menu;
    int BaseMenuId;
    QStringList MenuServiceIds;
};

}

#endif
