/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/



#ifndef KHALKHI_CARD_H
#define KHALKHI_CARD_H

// qt specific
#include <qstring.h>


namespace Khalkhi {

class Card
{
public:
    Card();
    ~Card();

public:
    QString data() const;

public:
    void initiate();
    void appendHeader( const QString &ImageURL, const QString &RealName,
                       const QString &Role, const QString &Organization );
    void appendItem( const QString &Name, const QString &Entry, const QString &Status = QString::null );
    void finalize();

protected:
    QString Data;
};


inline Card::Card()  {}
inline Card::~Card() {}

inline QString Card::data() const { return Data; }

}

#endif
