/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef ACTIONSERVICE_H
#define ACTIONSERVICE_H


// khalkhi core specific
#include <propertyactionservice.h>
// type specific
#include "typepropertyadapter.h"


// This template is useful for action services which are static and operate on all instances of a type
// like copy to clipboard, browse to url, create new email to address, etc.
// If the service depends on certain attributes, like fax for phone, or on the state of the system,
// take the dynamicactionservice template as example.
class ACTION_Service : public PropertyActionService
{
public:
    ACTION_Service( QObject* Parent, const char* Name, const QStringList& Arguments );
    virtual ~ACTION_Service();

public: // PropertyActionService API
    virtual void execute( const KABC::Addressee &Person, int ItemIndex );
    virtual ServiceAction action( const KABC::Addressee &Person, int ItemIndex, int Flags ) const;

    virtual bool isAvailable() const;

    virtual void setAdapter( PropertyAdapter *Adapter );

protected:
    TYPE_PropertyAdapter *TypeAdapter;
};

#endif
