/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kiaxcallregisteritem.h"

KiaxCallRegisterItem::KiaxCallRegisterItem(KiaxCallRecord* record, QString iconsPath)
    : QListBoxItem()
{

  bool outgoing = record->isOutgoing();
  bool answered = record->isAnswered();
  int hours = 0;
  int minutes = 0;
  int seconds = 0;
  uint duration = 0; 

  QString recordIcon = "outgoing.png";
  if (!outgoing)
  {
    recordIcon = "incoming.png";
    if (!answered) recordIcon ="missed.png";
  }
  else
    if (!answered) recordIcon="failed.png";
  pm = QPixmap( iconsPath + recordIcon );

  QDateTime startTime;
  startTime.setTime_t(record->getCallStartTime().toUInt());
  dateString = startTime.toString();
  uint startT = record->getCallStartTime().toUInt();
  uint endT = record->getCallEndTime().toUInt();
  if (endT>startT) duration = endT-startT;
  div_t hours_calc = div(duration, 3600);
  hours = hours_calc.quot;
  div_t minutes_calc = div(hours_calc.rem, 60);
  minutes = minutes_calc.quot;
  seconds = minutes_calc.rem;
  QString hoursStr = QString::number(hours);
  if (hours<10) hoursStr = "0" + hoursStr;
  QString minutesStr = QString::number(minutes);
  if (minutes<10) minutesStr = "0" + minutesStr;
  QString secondsStr = QString::number(seconds);
  if (seconds<10) secondsStr = "0" + secondsStr;
  durationString = hoursStr + ":" + minutesStr + ":" + secondsStr;
  cidName = record->getCallerIdName();
}

void KiaxCallRegisterItem::paint( QPainter *painter )
{
  int topYPos = 3;

  int itemHeight = height( listBox() );

  const QPixmap *pm = pixmap();
  if ( pm && ! pm->isNull() )
  {
    painter->drawPixmap( 3, topYPos, *pm);
  }

  QFontMetrics fm = painter->fontMetrics();
  painter->drawText( pm->width() + 5, topYPos + fm.height(), cidName + "," + dateString  );
  painter->drawText( pm->width() + 5, topYPos + 2*fm.height() + 5, tr("Duration") + " " + durationString  );

}

int KiaxCallRegisterItem::height( const QListBox* lb) const
{
  return lb->fontMetrics().height()*2 + lb->fontMetrics().lineSpacing() + 2;
}

int KiaxCallRegisterItem::width( const QListBox* lb) const
{
  if ( text().isEmpty() )
    return QMAX( pm.width() + 6, QApplication::globalStrut().width() );
  return QMAX( pm.width() + lb->fontMetrics().width( text() ) + 6,
               QApplication::globalStrut().width() );

}

KiaxCallRegisterItem::~KiaxCallRegisterItem()
{}



