/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KIAXCALLTAB_H
#define KIAXCALLTAB_H

#include <qstring.h>
#include <qlabel.h>
#include <qprogressbar.h>
#include "kiaxcalltab.h"
#include "calltab.h"

class KiaxCallTab : public KiaxCallTabUi
{
  Q_OBJECT

public:
  KiaxCallTab(QWidget* parent = 0, const char* name = 0, WFlags fl = 0,QString callerId ="Caller", QString callerStatus = "" );
  ~KiaxCallTab();
  /*$PUBLIC_FUNCTIONS$*/

public:

public slots:
  /*$PUBLIC_SLOTS$*/
  void setCallNumber(int callNo);
  void setCallerId(QString callerId);
  void setCallerStatus(QString status);
  void setMicLevel(int value, int threshold);
  void setAudioLevel(int value, int threshold);
  int getCallNumber();

protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/

private:
  int callNumber;
};

#endif

