/***************************************************************************
 *   Copyright (C) 2004 by Ingo Stierand, Stierand-LinuxIt                 *
 *   linuxit@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <klocale.h>
#include "kpkgtable.h"


KPkgTableItem::KPkgTableItem(QTable * table, TPackageInfo * info, const QString & text)
  : QTableItem(table,QTableItem::Never,text)
{
  m_info = info;
}


/*!
 */
TPackageInfo * KPkgTableItem::info()
{
  return(m_info);
}


/******************************************************************************
*/

KPkgTable::KPkgTable(QWidget *parent, const char *name)
 : QTable(parent, name)
{
  // set outfit
  horizontalHeader()->show();
  verticalHeader()->hide();
  setLeftMargin(0);

  setNumCols(3);
  horizontalHeader()->setLabel(0,i18n("Name"));
  horizontalHeader()->setLabel(1,i18n("Version"));
  horizontalHeader()->setLabel(2,i18n("Type"));
  
  // set table behaviour
  setReadOnly(true);
  setColumnMovingEnabled(false);
  setColumnStretchable(0,true);
  setSelectionMode(SingleRow);
  setShowGrid(false);
  setFocusStyle(FollowStyle);

  setHScrollBarMode(QScrollView::AlwaysOff);
  setVScrollBarMode(QScrollView::AlwaysOn);
  
  setSorting(true);
  horizontalHeader()->setSortIndicator(0,Ascending);
  sortColumn(0,true,true);

  m_selectedPackage = 0;

  connect(this, SIGNAL(selectionChanged()), this, SLOT(slotSelectionChanged()));
}


KPkgTable::~KPkgTable()
{
}


/*!
 */
bool KPkgTable::updatePackageInfos(TPackageInfoList * infoList)
{
  TPackageInfo * info;
  uint num;
  KPkgTableItem * item;


  if (infoList == 0)
  {
    setNumRows(0);
  }
  else
  {
    setNumRows(infoList->count());
    
    info = infoList->firstInfo();
    num = 0;
    while (info != 0)
    {
      item = new KPkgTableItem(this,info,info->pkgName);
      setItem(num,0,item);
      if (info->pkgRelease.isEmpty() || info->pkgRelease == "0")
        setText(num,1,info->pkgVersion + " ");
      else
        setText(num,1,info->pkgVersion + "-" + info->pkgRelease);
      setText(num,2,info->installType);
      ++num;
      info = infoList->nextInfo();
    }
  }
  
  m_selectedPackage = 0;
  clearSelection();
  slotSelectionChanged();
  
  sortColumn(horizontalHeader()->sortIndicatorSection(),
             horizontalHeader()->sortIndicatorOrder() == Ascending);
  
  return(true);
}


/*!
 */
TPackageInfo * KPkgTable::selectedPackage()
{
  return(m_selectedPackage);
}


/*!
 */
void KPkgTable::sortColumn(int col, bool ascending, bool wholeRows)
{
  QTable::sortColumn( col, ascending, TRUE );
}


/*!
 */
void KPkgTable::slotSelectionChanged()
{
  KPkgTableItem * itm;

  
  if (currentSelection() < 0)
  {
    m_selectedPackage = 0;
  }
  else if (selection(currentSelection()).isActive() == false)
  {
    m_selectedPackage = 0;    
  }
  else
  {
    itm = (KPkgTableItem *)item(selection(currentSelection()).topRow(),0);

    if (itm == 0)
      m_selectedPackage = 0;
    else
      m_selectedPackage = itm->info();
  }

  emit selectedPackageChanged();
}


#include "kpkgtable.moc"
