#include <locale.h>

#include "src/kppresetdata.h"
#include "src/kpsettings.h"

#include "src/html/kphtmlwriter.h"

#include "src/kipina-i18n.h"
#include "src/kplogstat.h"
#include "src/kpconv.h"

void
test_html_writer (KPTrainingLog *log, const gchar *dir)
{ 
  KPHtmlWriter *writer;
  GError *err = NULL;

  writer = kp_html_writer_new ();
  kp_html_writer_write (writer, log, dir, &err);

  if (err) {
    g_print ("%s\n", err->message);
    g_error_free (err);
    return;
  }
}


int 
main (int argc, char **argv)
{
  KPTrainingLog *log;
  const gchar *file;
  const gchar *dir;
  
  if (argc == 3) {
    file = argv[2];
    dir = argv[1];
  } else {
    g_print ("Usage: %s dir log\n", argv[0]);
    return 1;
  }

  bindtextdomain (GETTEXT_PACKAGE, KIPINA_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
  setlocale (LC_ALL, "");
  
  /* Init things */
  g_type_init ();
  kp_preset_data_init (NULL);
  kp_settings_init (NULL);
  kp_conv_init ();
  
  log = kp_training_log_new_from_file (file, NULL);
  if (log == NULL) {
    g_print ("Can't open the log!");
    exit (1);
  }
 
  /* Do it! */
  test_html_writer (log, dir);
  
  return 0;
}
