#include <gtk/gtk.h>
#include <glib-object.h>

#include "kpentryviewmodel.h"
#include "../kpcalendarentry.h"

static void         kp_entry_view_model_base_init         (GObjectClass *klass);


GType
kp_entry_view_model_get_type ()
{
  static GType kp_entry_view_model_type = 0;

  if (!kp_entry_view_model_type) {
    static const GTypeInfo kp_entry_view_model_info = {
      sizeof (KPEntryViewModelIface),
      (GBaseInitFunc) kp_entry_view_model_base_init,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL
    };
    kp_entry_view_model_type = g_type_register_static (G_TYPE_INTERFACE,
                                                      "KPEntryViewModel",
                                                      &kp_entry_view_model_info,
                                                       0);
    g_type_interface_add_prerequisite (kp_entry_view_model_type, 
                                       KP_TYPE_CALENDAR_ENTRY);
  }
  return kp_entry_view_model_type;
}

static void
kp_entry_view_model_base_init (GObjectClass *klass)
{
}



void
kp_entry_view_model_show_prop_dialog (KPEntryViewModel *model)
{
  g_return_if_fail (KP_IS_ENTRY_VIEW_MODEL (model));
  KP_ENTRY_VIEW_MODEL_GET_CLASS (model)->show_prop_dialog (model);  
}

  
void
kp_entry_view_model_show_edit_dialog (KPEntryViewModel *model)
{
  g_return_if_fail (KP_IS_ENTRY_VIEW_MODEL (model));
  KP_ENTRY_VIEW_MODEL_GET_CLASS (model)->show_edit_dialog (model);  
}


void
kp_entry_view_model_show_new_dialog (KPEntryViewModel *model)
{
  g_return_if_fail (KP_IS_ENTRY_VIEW_MODEL (model));
  KP_ENTRY_VIEW_MODEL_GET_CLASS (model)->show_new_dialog (model);  
}

