#ifndef KP_TREE_VIEW_H_
#define KP_TREE_VIEW_H_

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include "../kptraininglog.h"

#define KP_TYPE_TREE_VIEW (kp_tree_view_get_type())
#define KP_TREE_VIEW(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_TREE_VIEW, KPTreeView))
#define KP_TREE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_TREE_VIEW, KPTreeViewClass))
#define KP_IS_TREE_VIEW(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_TREE_VIEW))
#define KP_IS_TREE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_TREE_VIEW))
#define KP_TREE_VIEW_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_TREE_VIEW, KPTreeViewClass))

typedef struct KPTreeView_
{
  GtkTreeView     parent;

  gpointer        private_data;
} KPTreeView;

typedef struct KPTreeViewClass_
{
  GtkTreeViewClass  parent;

} KPTreeViewClass;

GtkWidget      *kp_tree_view_new (KPTrainingLog *log);

GType           kp_tree_view_get_type (void);

void            kp_tree_view_remove_mark (KPTreeView *tv,
                                          guint d,
                                          guint m,
                                          guint y,
                                          const gchar *mark);

void            kp_tree_view_add_mark (KPTreeView *tv,
                                       guint d,
                                       guint m,
                                       guint y,
                                       const gchar *mark);

#endif
