#include <string.h>
#include <errno.h>

#include "kphtmldiagram.h"
#include "kphtmlwriter.h"
#include "kphtmlutil.h"
#include "page-year.h"

#include "../kpworkoutmodel.h"
#include "../kipina-i18n.h"
#include "../kpconv.h"


static KPHtmlNaviData navi_data = 
{
  0, 0, 0,
  { NULL, NULL, NULL, NULL, NULL },
  { NULL, NULL, NULL, NULL, NULL }
};


static void
sport_table (KPHtmlWriter *writer, FILE *fp)
{
  KPSportEntryData *s_data;
  KPLogStatItem *yitem;
  KPLogStatItem *item;
  GSList *snode;
  GList *node;
  TYear *ty;

  kp_html_table_start (fp);
  
  for (node = writer->log->year_list; node; node = node->next) {
    ty = node->data;

    yitem = kp_log_stat_get_year_stats (writer->stat, ty->year, NULL, NULL);
 
    /* Sub heading */ 
    kp_html_table_row_start (fp);
    kp_html_table_head_cell (fp, "<strong>%u</strong> %s", ty->year, _("by sport"));
    kp_html_table_head_cell (fp, "<strong>%s</strong>", _("Total Distance"));
    kp_html_table_head_cell (fp, "<strong>%s</strong>", _("Total Duration"));
    kp_html_table_head_cell (fp, "<strong>%s</strong>", _("Avg Distance"));
    kp_html_table_head_cell (fp, "<strong>%s</strong>", _("Avg Duration"));
    kp_html_table_head_cell (fp, "<strong>%s</strong>", _("Avg Speed"));
    kp_html_table_head_cell (fp, "<strong>%s</strong>", _("N Workouts"));
    kp_html_table_row_end (fp);

    for (snode = writer->log->sports; snode; snode = snode->next) {
      s_data = snode->data;
      
      item = kp_log_stat_get_year_stats (writer->stat, ty->year, s_data->name, NULL);
      if (item->n_workouts == 0)
        continue;
        
      kp_html_table_row_start (fp);
      /* Sport */
      kp_html_table_cell (fp, "%s", s_data->name);

#if 0
      /* Distance share */
      if (yitem->tot_di != 0)
        kp_html_table_cell (fp, "%.0f%%", (double) item->tot_di / yitem->tot_di * 100.0);
      else
        kp_html_table_cell (fp, "0%%");
      
      /* Duration share */
      if (yitem->tot_du != 0)
        kp_html_table_cell (fp, "%.0f%%", (double) item->tot_du / yitem->tot_du * 100.0);
      else
        kp_html_table_cell (fp, "0%%");
#endif

      /* Tot distance */
      kp_html_table_cell (fp, "%.2f", item->tot_di);
      /* Tot duration */
      kp_html_table_cell (fp, "%.1f h", item->tot_du / 3600000.0f);

      /* Average distance */
      kp_html_table_cell (fp, "%.1f", item->avg_di);
      /* Average duration */
      kp_html_table_cell (fp, "%s", 
            kp_conv_msec_to_str (item->avg_du / 1000 * 1000));
      /* Avg speed */
      kp_html_table_cell (fp, "%s",
         kp_conv_msec_to_str ((guint)(item->avg_du / item->avg_di) / 1000 * 1000));
      
      /* N Workouts */
      kp_html_table_cell (fp, "%u", item->n_workouts);
      kp_html_table_row_end (fp);
  
      kp_log_stat_item_free (item);
    }
    kp_log_stat_item_free (yitem);
  }

  kp_html_table_foot (fp);

  return;
}


void
page_index_sport (KPHtmlWriter *writer, GError **err)
{
  GError *tmp_error = NULL;
  FILE *fp;
  
  fp = kp_html_writer_open (writer, "index-sport.html", &tmp_error);

  if (fp == NULL) {
    if (tmp_error) {
      g_warning ("Can't open index.html: %s\n", tmp_error->message);
      g_propagate_error (err, tmp_error);
    } 
    else
      g_warning ("Can't open index.html for writing: %s\n", strerror (errno));
    return;
  }

  /* Navi bar */ 
  kp_html_navi (fp, &navi_data, 0, 0, 0);

  /* Stats by sports */
  kp_html_h1 (fp, _("Statistics by Sports"));
  sport_table (writer, fp);
  
  kp_html_writer_close (fp);
}

