#ifndef KP_PARAM_H_
#define KP_PARAM_H_

#include <libxml/tree.h>
#include <glib.h>
#include <glib-object.h>

#define KP_TYPE_PARAM (kp_param_get_type())
#define KP_PARAM(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_PARAM, KPParam))
#define KP_PARAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_PARAM, KPParamClass))
#define KP_IS_PARAM(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_PARAM))
#define KP_IS_PARAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_PARAM))
#define KP_PARAM_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_PARAM, KPParamClass))

typedef enum {
  KP_PARAM_TYPE_INT,
  KP_PARAM_TYPE_UINT,
  KP_PARAM_TYPE_DOUBLE,
  KP_PARAM_TYPE_BOOLEAN,
  KP_PARAM_TYPE_STRING,
  KP_PARAM_TYPE_POINTER,
  KP_PARAM_TYPE_OBJECT,
  KP_PARAM_TYPE_UNSET,
  KP_PARAM_TYPE_TIME,
  KP_PARAM_TYPE_N
} KPParamType;


typedef struct KPParam_
{
  GObject           parent_instance;

  gchar             *name;
  KPParamType       type;

  gint              v_int;
  guint             v_uint;
  gdouble           v_double;
  gboolean          v_bool;
  
  gchar            *v_string;
  gpointer          v_pointer;
  GObject          *v_object;
}
KPParam;

typedef struct KPParamClass_ {
  GObjectClass parent_class;

  void       (*changed) (KPParam *);
} KPParamClass;


GType         kp_param_get_type                     (void);

KPParam      *kp_param_new                          (const gchar *name);
KPParam      *kp_param_copy                         (KPParam *param);
void          kp_param_unset                        (KPParam *param);
gboolean      kp_param_isset                        (KPParam *param,
                                                     KPParamType type);
void          kp_param_set_name                     (KPParam *param,
                                                     const gchar *name);
G_CONST_RETURN
gchar        *kp_param_get_name                     (KPParam *param);

/* Set */
void          kp_param_set_uint                     (KPParam *param,
                                                     guint value);
void          kp_param_set_int                      (KPParam *param,
                                                     gint value);
void          kp_param_set_double                   (KPParam *param,
                                                     gdouble value);
void          kp_param_set_boolean                  (KPParam *param,
                                                     gboolean value);
void          kp_param_set_string                   (KPParam *param,
                                                     const gchar *value);
void          kp_param_set_pointer                  (KPParam *param,
                                                     gpointer value);
void          kp_param_set_object                   (KPParam *param,
                                                     GObject *object);
void          kp_param_set_time                     (KPParam *param,
                                                     guint value);
/* Get */
gint          kp_param_get_int                      (KPParam *param);
guint         kp_param_get_uint                     (KPParam *param);
gdouble       kp_param_get_double                   (KPParam *param);
gboolean      kp_param_get_boolean                  (KPParam *param);
G_CONST_RETURN
gchar        *kp_param_get_string                   (KPParam *param);
gpointer      kp_param_get_pointer                  (KPParam *param);
GObject      *kp_param_get_object                   (KPParam *param);

guint         kp_param_get_time                     (KPParam *param);


void          kp_param_set_automatic_as_string      (KPParam *param,
                                                     const gchar *string);
gchar        *kp_param_get_as_string                (KPParam *param);
void          kp_param_export_as_xml                (KPParam *param,
                                                     xmlNodePtr parent);

#endif
