#ifndef KP_WORKOUT_MODEL_H_
#define KP_WORKOUT_MODEL_H_

#include "kputil.h"

#define KP_TYPE_WORKOUT_MODEL (kp_workout_model_get_type())
#define KP_WORKOUT_MODEL(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_WORKOUT_MODEL, KPWorkoutModel))
#define KP_WORKOUT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_WORKOUT_MODEL, KPWorkoutModelClass))
#define KP_IS_WORKOUT_MODEL(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_WORKOUT_MODEL))
#define KP_IS_WORKOUT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_WORKOUT_MODEL))
#define KP_WORKOUT_MODEL_GET_CLASS(object) (G_TYPE_INSTANCE_GET_INTERFACE ((object), KP_TYPE_WORKOUT_MODEL, KPWorkoutModelIface))

typedef struct KPWorkoutModel_      KPWorkoutModel; /* dummy object */
typedef struct KPWorkoutModelIface_ KPWorkoutModelIface;


struct KPWorkoutModelIface_ {
  GTypeInterface      g_iface;

  /* Signals */
  /* Virtual table */

  guint            (* get_duration)  (KPWorkoutModel *model);
  gdouble          (* get_distance)  (KPWorkoutModel *model);
  guint            (* get_pace)      (KPWorkoutModel *model);
  gdouble          (* get_speed)     (KPWorkoutModel *model);
};

/* Functions */
GType                 kp_workout_model_get_type       (void);
guint                 kp_workout_model_get_duration   (KPWorkoutModel *model);
gdouble               kp_workout_model_get_distance   (KPWorkoutModel *model);
guint                 kp_workout_model_get_pace       (KPWorkoutModel *model);
gdouble               kp_workout_model_get_speed      (KPWorkoutModel *model);


#endif /* KP_WORKOUT_MODEL_H_ */


