/**************************************************************************/
/*  Klavaro - a flexible touch typing tutor                               */
/*  Copyright (C) 2005 - 2008  Felipe Castro                              */
/*                                                                        */
/*  This program is free software, licensed under the terms of the GNU    */
/*  General Public License as published by the Free Software Foundation,  */
/*  which is also included in this package, in a file named "COPYING".    */
/**************************************************************************/

/*
 * DO NOT EDIT THIS FILE - it is generated by Glade.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

GtkWidget *
create_window_main (void)
{
	GtkWidget *window_main;
	GtkWidget *vbox40;
	GtkWidget *frame53;
	GtkWidget *hbox59;
	GtkWidget *pixmap3;
	GtkWidget *button_help;
	GtkWidget *button_about;
	GtkWidget *button_exit;
	GtkWidget *frame54;
	GtkWidget *vbox41;
	GtkWidget *hbox60;
	GtkWidget *label_keyboard;
	GtkWidget *label28;
	GtkWidget *frame44;
	GtkWidget *entry_keyboard;
	GtkWidget *button_keyboard;
	GtkWidget *hseparator6;
	GtkWidget *hbox61;
	GtkWidget *label40;
	GtkWidget *label30;
	GtkWidget *frame47;
	GtkWidget *combo_language;
	GList *combo_language_items = NULL;
	GtkWidget *entry_language;
	GtkWidget *button_update_language;
	GtkWidget *label1;
	GtkWidget *frame55;
	GtkWidget *table3;
	GtkWidget *label2;
	GtkWidget *label3;
	GtkWidget *label4;
	GtkWidget *label5;
	GtkWidget *label118;
	GtkWidget *label119;
	GtkWidget *label120;
	GtkWidget *label121;
	GtkWidget *label6;
	GtkWidget *label7;
	GtkWidget *label8;
	GtkWidget *label9;
	GtkWidget *button_intro;
	GtkWidget *button_basic;
	GtkWidget *button_adapt;
	GtkWidget *button_velo;
	GtkWidget *button_fluid;
	GtkWidget *label10;
	GtkWidget *label54;
	GtkWidget *label53;
	GtkWidget *label41;
	GtkAccelGroup *accel_group;
	GtkTooltips *tooltips;

	tooltips = gtk_tooltips_new ();

	accel_group = gtk_accel_group_new ();

	window_main = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_name (window_main, "window_main");
	gtk_window_set_title (GTK_WINDOW (window_main), _("Klavaro - Main menu"));
	gtk_window_set_position (GTK_WINDOW (window_main), GTK_WIN_POS_CENTER);

	vbox40 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox40, "vbox40");
	gtk_widget_show (vbox40);
	gtk_container_add (GTK_CONTAINER (window_main), vbox40);

	frame53 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame53, "frame53");
	gtk_widget_show (frame53);
	gtk_box_pack_start (GTK_BOX (vbox40), frame53, FALSE, FALSE, 0);

	hbox59 = gtk_hbox_new (FALSE, 0);
	gtk_widget_set_name (hbox59, "hbox59");
	gtk_widget_show (hbox59);
	gtk_container_add (GTK_CONTAINER (frame53), hbox59);

	pixmap3 = create_pixmap (window_main, "logo.xpm");
	gtk_widget_set_name (pixmap3, "pixmap3");
	gtk_widget_show (pixmap3);
	gtk_box_pack_start (GTK_BOX (hbox59), pixmap3, TRUE, TRUE, 0);
	gtk_misc_set_alignment (GTK_MISC (pixmap3), 0, 0.5);

	button_help = gtk_button_new_with_mnemonic (_("Help"));
	gtk_widget_set_name (button_help, "button_help");
	gtk_widget_show (button_help);
	gtk_box_pack_start (GTK_BOX (hbox59), button_help, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_help), 3);
	gtk_tooltips_set_tip (tooltips, button_help, _("Little tip about this program."), NULL);
	gtk_button_set_relief (GTK_BUTTON (button_help), GTK_RELIEF_NONE);

	button_about = gtk_button_new_with_mnemonic (_("About..."));
	gtk_widget_set_name (button_about, "button_about");
	gtk_widget_show (button_about);
	gtk_box_pack_start (GTK_BOX (hbox59), button_about, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_about), 3);
	gtk_tooltips_set_tip (tooltips, button_about, _("Informations about this application, Klavaro."), NULL);
	gtk_button_set_relief (GTK_BUTTON (button_about), GTK_RELIEF_NONE);

	button_exit = gtk_button_new_with_mnemonic (_("Exit"));
	gtk_widget_set_name (button_exit, "button_exit");
	gtk_widget_show (button_exit);
	gtk_box_pack_start (GTK_BOX (hbox59), button_exit, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_exit), 3);
	gtk_tooltips_set_tip (tooltips, button_exit, _("Exit the application immediately. Hotkey: [Ctrl-Q]"), NULL);
	gtk_widget_add_accelerator (button_exit, "clicked", accel_group,
				    GDK_Q, (GdkModifierType) GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	gtk_widget_add_accelerator (button_exit, "clicked", accel_group,
				    GDK_q, (GdkModifierType) GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	gtk_button_set_relief (GTK_BUTTON (button_exit), GTK_RELIEF_NONE);

	frame54 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame54, "frame54");
	gtk_widget_show (frame54);
	gtk_box_pack_start (GTK_BOX (vbox40), frame54, TRUE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame54), 10);
	gtk_frame_set_label_align (GTK_FRAME (frame54), 0.5, 0.5);

	vbox41 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox41, "vbox41");
	gtk_widget_show (vbox41);
	gtk_container_add (GTK_CONTAINER (frame54), vbox41);

	hbox60 = gtk_hbox_new (FALSE, 0);
	gtk_widget_set_name (hbox60, "hbox60");
	gtk_widget_show (hbox60);
	gtk_box_pack_start (GTK_BOX (vbox41), hbox60, TRUE, TRUE, 0);

	label_keyboard = gtk_label_new (_("Keyboard"));
	gtk_widget_set_name (label_keyboard, "label_keyboard");
	gtk_widget_show (label_keyboard);
	gtk_box_pack_start (GTK_BOX (hbox60), label_keyboard, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label_keyboard), GTK_JUSTIFY_CENTER);
	gtk_misc_set_padding (GTK_MISC (label_keyboard), 5, 0);

	label28 = gtk_label_new (_(" -->"));
	gtk_widget_set_name (label28, "label28");
	gtk_widget_show (label28);
	gtk_box_pack_start (GTK_BOX (hbox60), label28, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label28), GTK_JUSTIFY_CENTER);
	gtk_misc_set_alignment (GTK_MISC (label28), 0, 0.5);

	frame44 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame44, "frame44");
	gtk_widget_show (frame44);
	gtk_box_pack_start (GTK_BOX (hbox60), frame44, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame44), 5);
	gtk_frame_set_shadow_type (GTK_FRAME (frame44), GTK_SHADOW_OUT);

	entry_keyboard = gtk_entry_new ();
	gtk_widget_set_name (entry_keyboard, "entry_keyboard");
	gtk_widget_show (entry_keyboard);
	gtk_container_add (GTK_CONTAINER (frame44), entry_keyboard);
	GTK_WIDGET_UNSET_FLAGS (entry_keyboard, GTK_CAN_FOCUS);
	gtk_editable_set_editable (GTK_EDITABLE (entry_keyboard), FALSE);

	button_keyboard = gtk_button_new_with_mnemonic (_("Define"));
	gtk_widget_set_name (button_keyboard, "button_keyboard");
	gtk_widget_show (button_keyboard);
	gtk_box_pack_start (GTK_BOX (hbox60), button_keyboard, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_keyboard), 5);
	gtk_tooltips_set_tip (tooltips, button_keyboard, _("Choose or edit the keyboard layout used by you."), NULL);

	hseparator6 = gtk_hseparator_new ();
	gtk_widget_set_name (hseparator6, "hseparator6");
	gtk_widget_show (hseparator6);
	gtk_box_pack_start (GTK_BOX (vbox41), hseparator6, TRUE, TRUE, 0);

	hbox61 = gtk_hbox_new (FALSE, 0);
	gtk_widget_set_name (hbox61, "hbox61");
	gtk_widget_show (hbox61);
	gtk_box_pack_start (GTK_BOX (vbox41), hbox61, TRUE, TRUE, 0);

	label40 = gtk_label_new (_("Language"));
	gtk_widget_set_name (label40, "label40");
	gtk_widget_show (label40);
	gtk_box_pack_start (GTK_BOX (hbox61), label40, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label40), GTK_JUSTIFY_CENTER);
	gtk_misc_set_padding (GTK_MISC (label40), 5, 0);

	label30 = gtk_label_new (_(" -->"));
	gtk_widget_set_name (label30, "label30");
	gtk_widget_show (label30);
	gtk_box_pack_start (GTK_BOX (hbox61), label30, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label30), GTK_JUSTIFY_CENTER);
	gtk_misc_set_alignment (GTK_MISC (label30), 0, 0.5);

	frame47 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame47, "frame47");
	gtk_widget_show (frame47);
	gtk_box_pack_start (GTK_BOX (hbox61), frame47, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame47), 5);
	gtk_frame_set_label_align (GTK_FRAME (frame47), 0, 1);
	gtk_frame_set_shadow_type (GTK_FRAME (frame47), GTK_SHADOW_OUT);

	combo_language = gtk_combo_new ();
	g_object_set_data (G_OBJECT (GTK_COMBO (combo_language)->popwin), "GladeParentKey", combo_language);
	gtk_widget_set_name (combo_language, "combo_language");
	gtk_widget_show (combo_language);
	gtk_container_add (GTK_CONTAINER (frame47), combo_language);
	gtk_combo_set_value_in_list (GTK_COMBO (combo_language), TRUE, FALSE);
	gtk_combo_set_use_arrows_always (GTK_COMBO (combo_language), TRUE);
	combo_language_items = g_list_append (combo_language_items, (gpointer) "");
	gtk_combo_set_popdown_strings (GTK_COMBO (combo_language), combo_language_items);
	g_list_free (combo_language_items);

	entry_language = GTK_COMBO (combo_language)->entry;
	gtk_widget_set_name (entry_language, "entry_language");
	gtk_widget_show (entry_language);
	gtk_tooltips_set_tip (tooltips, entry_language,
			      _("Choose the language of this interface and of the whole course."), NULL);
	gtk_editable_set_editable (GTK_EDITABLE (entry_language), FALSE);

	button_update_language = gtk_button_new_with_mnemonic (_("Update!"));
	gtk_widget_set_name (button_update_language, "button_update_language");
	gtk_widget_show (button_update_language);
	gtk_box_pack_start (GTK_BOX (hbox61), button_update_language, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_update_language), 5);
	gtk_tooltips_set_tip (tooltips, button_update_language, _("Apply the language selected beside."), NULL);

	label1 = gtk_label_new (_("< Configuring >"));
	gtk_widget_set_name (label1, "label1");
	gtk_widget_show (label1);
	gtk_frame_set_label_widget (GTK_FRAME (frame54), label1);

	frame55 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame55, "frame55");
	gtk_widget_show (frame55);
	gtk_box_pack_start (GTK_BOX (vbox40), frame55, TRUE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame55), 10);
	gtk_frame_set_label_align (GTK_FRAME (frame55), 0.5, 0.5);

	table3 = gtk_table_new (5, 4, FALSE);
	gtk_widget_set_name (table3, "table3");
	gtk_widget_show (table3);
	gtk_container_add (GTK_CONTAINER (frame55), table3);

	label2 = gtk_label_new_with_mnemonic (_("[ _1 ] -"));
	gtk_widget_set_name (label2, "label2");
	gtk_widget_show (label2);
	gtk_table_attach (GTK_TABLE (table3), label2, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (label2), 5, 0);

	label3 = gtk_label_new_with_mnemonic (_("[ _2 ] -"));
	gtk_widget_set_name (label3, "label3");
	gtk_widget_show (label3);
	gtk_table_attach (GTK_TABLE (table3), label3, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label3), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (label3), 5, 0);

	label4 = gtk_label_new_with_mnemonic (_("[ _3 ] -"));
	gtk_widget_set_name (label4, "label4");
	gtk_widget_show (label4);
	gtk_table_attach (GTK_TABLE (table3), label4, 0, 1, 3, 4,
			  (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label4), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (label4), 5, 0);

	label5 = gtk_label_new_with_mnemonic (_("[ _4 ] -"));
	gtk_widget_set_name (label5, "label5");
	gtk_widget_show (label5);
	gtk_table_attach (GTK_TABLE (table3), label5, 0, 1, 4, 5,
			  (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label5), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label5), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (label5), 5, 0);

	label118 = gtk_label_new (_(" -->"));
	gtk_widget_set_name (label118, "label118");
	gtk_widget_show (label118);
	gtk_table_attach (GTK_TABLE (table3), label118, 2, 3, 1, 2,
			  (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label118), GTK_JUSTIFY_CENTER);
	gtk_misc_set_alignment (GTK_MISC (label118), 0, 0.5);

	label119 = gtk_label_new (_(" -->"));
	gtk_widget_set_name (label119, "label119");
	gtk_widget_show (label119);
	gtk_table_attach (GTK_TABLE (table3), label119, 2, 3, 2, 3,
			  (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label119), GTK_JUSTIFY_CENTER);
	gtk_misc_set_alignment (GTK_MISC (label119), 0, 0.5);

	label120 = gtk_label_new (_(" -->"));
	gtk_widget_set_name (label120, "label120");
	gtk_widget_show (label120);
	gtk_table_attach (GTK_TABLE (table3), label120, 2, 3, 3, 4,
			  (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label120), GTK_JUSTIFY_CENTER);
	gtk_misc_set_alignment (GTK_MISC (label120), 0, 0.5);

	label121 = gtk_label_new (_(" -->"));
	gtk_widget_set_name (label121, "label121");
	gtk_widget_show (label121);
	gtk_table_attach (GTK_TABLE (table3), label121, 2, 3, 4, 5,
			  (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label121), GTK_JUSTIFY_CENTER);
	gtk_misc_set_alignment (GTK_MISC (label121), 0, 0.5);

	label6 = gtk_label_new (_("initial training"));
	gtk_widget_set_name (label6, "label6");
	gtk_widget_show (label6);
	gtk_table_attach (GTK_TABLE (table3), label6, 3, 4, 1, 2,
			  (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label6), GTK_JUSTIFY_CENTER);
	gtk_misc_set_alignment (GTK_MISC (label6), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (label6), 5, 0);

	label7 = gtk_label_new (_("random keys"));
	gtk_widget_set_name (label7, "label7");
	gtk_widget_show (label7);
	gtk_table_attach (GTK_TABLE (table3), label7, 3, 4, 2, 3,
			  (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label7), GTK_JUSTIFY_CENTER);
	gtk_misc_set_alignment (GTK_MISC (label7), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (label7), 5, 0);

	label8 = gtk_label_new (_("random words"));
	gtk_widget_set_name (label8, "label8");
	gtk_widget_show (label8);
	gtk_table_attach (GTK_TABLE (table3), label8, 3, 4, 3, 4,
			  (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label8), GTK_JUSTIFY_CENTER);
	gtk_misc_set_alignment (GTK_MISC (label8), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (label8), 5, 0);

	label9 = gtk_label_new (_("complete texts"));
	gtk_widget_set_name (label9, "label9");
	gtk_widget_show (label9);
	gtk_table_attach (GTK_TABLE (table3), label9, 3, 4, 4, 5,
			  (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label9), GTK_JUSTIFY_CENTER);
	gtk_misc_set_alignment (GTK_MISC (label9), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (label9), 5, 0);

	button_intro = gtk_button_new_with_mnemonic (_("Introduction"));
	gtk_widget_set_name (button_intro, "button_intro");
	gtk_widget_show (button_intro);
	gtk_table_attach (GTK_TABLE (table3), button_intro, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_intro), 3);
	gtk_tooltips_set_tip (tooltips, button_intro, _("Don't be shy about learning the basics!"), NULL);
	gtk_widget_add_accelerator (button_intro, "clicked", accel_group,
				    GDK_0, (GdkModifierType) 0, GTK_ACCEL_VISIBLE);

	button_basic = gtk_button_new_with_mnemonic (_("Basic course"));
	gtk_widget_set_name (button_basic, "button_basic");
	gtk_widget_show (button_basic);
	gtk_table_attach (GTK_TABLE (table3), button_basic, 1, 2, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_basic), 3);
	gtk_tooltips_set_tip (tooltips, button_basic, _("Initial training for your fingers."), NULL);
	gtk_widget_add_accelerator (button_basic, "clicked", accel_group,
				    GDK_1, (GdkModifierType) 0, GTK_ACCEL_VISIBLE);

	button_adapt = gtk_button_new_with_mnemonic (_("Adaptability"));
	gtk_widget_set_name (button_adapt, "button_adapt");
	gtk_widget_show (button_adapt);
	gtk_table_attach (GTK_TABLE (table3), button_adapt, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_adapt), 3);
	gtk_tooltips_set_tip (tooltips, button_adapt,
			      _("Memorizing the keyboard practicing random keys exercises."), NULL);
	gtk_widget_add_accelerator (button_adapt, "clicked", accel_group,
				    GDK_2, (GdkModifierType) 0, GTK_ACCEL_VISIBLE);

	button_velo = gtk_button_new_with_mnemonic (_("Velocity"));
	gtk_widget_set_name (button_velo, "button_velo");
	gtk_widget_show (button_velo);
	gtk_table_attach (GTK_TABLE (table3), button_velo, 1, 2, 3, 4,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_velo), 3);
	gtk_tooltips_set_tip (tooltips, button_velo,
			      _("Accelerating the touchs practicing random words exercises."), NULL);
	gtk_widget_add_accelerator (button_velo, "clicked", accel_group, GDK_3, (GdkModifierType) 0, GTK_ACCEL_VISIBLE);

	button_fluid = gtk_button_new_with_mnemonic (_("Fluidness"));
	gtk_widget_set_name (button_fluid, "button_fluid");
	gtk_widget_show (button_fluid);
	gtk_table_attach (GTK_TABLE (table3), button_fluid, 1, 2, 4, 5,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_fluid), 3);
	gtk_tooltips_set_tip (tooltips, button_fluid,
			      _("Becoming proficient practicing complete paragraphs exercises."), NULL);
	gtk_widget_add_accelerator (button_fluid, "clicked", accel_group,
				    GDK_4, (GdkModifierType) 0, GTK_ACCEL_VISIBLE);

	label10 = gtk_label_new (_("how to type correctly"));
	gtk_widget_set_name (label10, "label10");
	gtk_widget_show (label10);
	gtk_table_attach (GTK_TABLE (table3), label10, 3, 4, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label10), GTK_JUSTIFY_CENTER);
	gtk_misc_set_alignment (GTK_MISC (label10), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (label10), 5, 0);

	label54 = gtk_label_new (_(" -->"));
	gtk_widget_set_name (label54, "label54");
	gtk_widget_show (label54);
	gtk_table_attach (GTK_TABLE (table3), label54, 2, 3, 0, 1,
			  (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label54), GTK_JUSTIFY_CENTER);
	gtk_misc_set_alignment (GTK_MISC (label54), 0, 0.5);

	label53 = gtk_label_new_with_mnemonic (_("[ _0 ] -"));
	gtk_widget_set_name (label53, "label53");
	gtk_widget_show (label53);
	gtk_table_attach (GTK_TABLE (table3), label53, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label53), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label53), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (label53), 5, 0);

	label41 = gtk_label_new (_("< Learning >"));
	gtk_widget_set_name (label41, "label41");
	gtk_widget_show (label41);
	gtk_frame_set_label_widget (GTK_FRAME (frame55), label41);

	g_signal_connect ((gpointer) window_main, "destroy", G_CALLBACK (on_window_main_destroy), NULL);
	g_signal_connect ((gpointer) button_help, "clicked", G_CALLBACK (on_button_help_clicked), NULL);
	g_signal_connect ((gpointer) button_about, "clicked", G_CALLBACK (on_button_about_clicked), NULL);
	g_signal_connect_after ((gpointer) button_exit, "clicked", G_CALLBACK (on_button_exit_clicked), NULL);
	g_signal_connect ((gpointer) button_keyboard, "clicked", G_CALLBACK (on_button_keyboard_clicked), NULL);
	g_signal_connect ((gpointer) button_update_language, "clicked",
			  G_CALLBACK (on_button_change_language_clicked), NULL);
	g_signal_connect ((gpointer) button_intro, "clicked", G_CALLBACK (on_button_intro_clicked), NULL);
	g_signal_connect ((gpointer) button_basic, "clicked", G_CALLBACK (on_button_basic_clicked), NULL);
	g_signal_connect ((gpointer) button_adapt, "clicked", G_CALLBACK (on_button_adapt_clicked), NULL);
	g_signal_connect ((gpointer) button_velo, "clicked", G_CALLBACK (on_button_velo_clicked), NULL);
	g_signal_connect ((gpointer) button_fluid, "clicked", G_CALLBACK (on_button_fluid_clicked), NULL);

	gtk_label_set_mnemonic_widget (GTK_LABEL (label2), button_basic);
	gtk_label_set_mnemonic_widget (GTK_LABEL (label3), button_adapt);
	gtk_label_set_mnemonic_widget (GTK_LABEL (label4), button_velo);
	gtk_label_set_mnemonic_widget (GTK_LABEL (label5), button_fluid);
	gtk_label_set_mnemonic_widget (GTK_LABEL (label53), button_intro);

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (window_main, window_main, "window_main");
	GLADE_HOOKUP_OBJECT (window_main, vbox40, "vbox40");
	GLADE_HOOKUP_OBJECT (window_main, frame53, "frame53");
	GLADE_HOOKUP_OBJECT (window_main, hbox59, "hbox59");
	GLADE_HOOKUP_OBJECT (window_main, pixmap3, "pixmap3");
	GLADE_HOOKUP_OBJECT (window_main, button_help, "button_help");
	GLADE_HOOKUP_OBJECT (window_main, button_about, "button_about");
	GLADE_HOOKUP_OBJECT (window_main, button_exit, "button_exit");
	GLADE_HOOKUP_OBJECT (window_main, frame54, "frame54");
	GLADE_HOOKUP_OBJECT (window_main, vbox41, "vbox41");
	GLADE_HOOKUP_OBJECT (window_main, hbox60, "hbox60");
	GLADE_HOOKUP_OBJECT (window_main, label_keyboard, "label_keyboard");
	GLADE_HOOKUP_OBJECT (window_main, label28, "label28");
	GLADE_HOOKUP_OBJECT (window_main, frame44, "frame44");
	GLADE_HOOKUP_OBJECT (window_main, entry_keyboard, "entry_keyboard");
	GLADE_HOOKUP_OBJECT (window_main, button_keyboard, "button_keyboard");
	GLADE_HOOKUP_OBJECT (window_main, hseparator6, "hseparator6");
	GLADE_HOOKUP_OBJECT (window_main, hbox61, "hbox61");
	GLADE_HOOKUP_OBJECT (window_main, label40, "label40");
	GLADE_HOOKUP_OBJECT (window_main, label30, "label30");
	GLADE_HOOKUP_OBJECT (window_main, frame47, "frame47");
	GLADE_HOOKUP_OBJECT (window_main, combo_language, "combo_language");
	GLADE_HOOKUP_OBJECT (window_main, entry_language, "entry_language");
	GLADE_HOOKUP_OBJECT (window_main, button_update_language, "button_update_language");
	GLADE_HOOKUP_OBJECT (window_main, label1, "label1");
	GLADE_HOOKUP_OBJECT (window_main, frame55, "frame55");
	GLADE_HOOKUP_OBJECT (window_main, table3, "table3");
	GLADE_HOOKUP_OBJECT (window_main, label2, "label2");
	GLADE_HOOKUP_OBJECT (window_main, label3, "label3");
	GLADE_HOOKUP_OBJECT (window_main, label4, "label4");
	GLADE_HOOKUP_OBJECT (window_main, label5, "label5");
	GLADE_HOOKUP_OBJECT (window_main, label118, "label118");
	GLADE_HOOKUP_OBJECT (window_main, label119, "label119");
	GLADE_HOOKUP_OBJECT (window_main, label120, "label120");
	GLADE_HOOKUP_OBJECT (window_main, label121, "label121");
	GLADE_HOOKUP_OBJECT (window_main, label6, "label6");
	GLADE_HOOKUP_OBJECT (window_main, label7, "label7");
	GLADE_HOOKUP_OBJECT (window_main, label8, "label8");
	GLADE_HOOKUP_OBJECT (window_main, label9, "label9");
	GLADE_HOOKUP_OBJECT (window_main, button_intro, "button_intro");
	GLADE_HOOKUP_OBJECT (window_main, button_basic, "button_basic");
	GLADE_HOOKUP_OBJECT (window_main, button_adapt, "button_adapt");
	GLADE_HOOKUP_OBJECT (window_main, button_velo, "button_velo");
	GLADE_HOOKUP_OBJECT (window_main, button_fluid, "button_fluid");
	GLADE_HOOKUP_OBJECT (window_main, label10, "label10");
	GLADE_HOOKUP_OBJECT (window_main, label54, "label54");
	GLADE_HOOKUP_OBJECT (window_main, label53, "label53");
	GLADE_HOOKUP_OBJECT (window_main, label41, "label41");
	GLADE_HOOKUP_OBJECT_NO_REF (window_main, tooltips, "tooltips");

	gtk_widget_grab_focus (button_intro);
	gtk_window_add_accel_group (GTK_WINDOW (window_main), accel_group);

	return window_main;
}

GtkWidget *
create_window_keyboard (void)
{
	GtkWidget *window_keyboard;
	GtkWidget *hbox56;
	GtkWidget *vbox_kb_left;
	GtkWidget *vbox38;
	GtkWidget *notebook_kb;
	GtkWidget *vbox24;
	GtkWidget *frame22;
	GtkWidget *vbox20;
	GtkWidget *frame45;
	GtkWidget *combo_kb_main;
	GList *combo_kb_main_items = NULL;
	GtkWidget *entry_kb_main;
	GtkWidget *label122;
	GtkWidget *frame23;
	GtkWidget *vbox21;
	GtkWidget *frame46;
	GtkWidget *combo_kb_user;
	GList *combo_kb_user_items = NULL;
	GtkWidget *entry_kb_user;
	GtkWidget *label123;
	GtkWidget *label_kb_load;
	GtkWidget *vbox26;
	GtkWidget *frame34;
	GtkWidget *vbox33;
	GtkWidget *combo_kb_edit;
	GList *combo_kb_edit_items = NULL;
	GtkWidget *entry_kb_edit;
	GtkWidget *hbox27;
	GtkWidget *button_kb_save;
	GtkWidget *button_kb_remove;
	GtkWidget *label124;
	GtkWidget *label46;
	GtkWidget *vseparator3;
	GtkWidget *frame43;
	GtkWidget *vbox36;
	GtkWidget *frame42;
	GtkWidget *frame51;
	GtkWidget *label_kb_name;
	GtkWidget *hbox53;
	GtkWidget *button_keyboard_select;
	GtkWidget *button_keyboard_cancel;
	GtkWidget *label125;
	GtkWidget *vbox19;
	GtkWidget *frame52;
	GtkWidget *frame50;
	GtkWidget *hbox30;
	GtkWidget *label_virtual_kb;
	GtkWidget *label_modified;
	GtkWidget *label_saved_tmp;
	GtkWidget *hbox54;
	GtkWidget *vseparator4;
	GtkWidget *vseparator5;
	GtkWidget *frame24;
	GtkWidget *frame25;
	GtkWidget *fixed2;
	GtkWidget *but4;
	GtkWidget *lab4;
	GtkWidget *but5;
	GtkWidget *lab5;
	GtkWidget *but6;
	GtkWidget *lab6;
	GtkWidget *but7;
	GtkWidget *lab7;
	GtkWidget *but8;
	GtkWidget *lab8;
	GtkWidget *but_2;
	GtkWidget *lab_2;
	GtkWidget *but_3;
	GtkWidget *lab_3;
	GtkWidget *but__2;
	GtkWidget *lab__2;
	GtkWidget *but__3;
	GtkWidget *lab__3;
	GtkWidget *but_5;
	GtkWidget *lab_5;
	GtkWidget *but_6;
	GtkWidget *lab_6;
	GtkWidget *but_7;
	GtkWidget *lab_7;
	GtkWidget *but_9;
	GtkWidget *lab_9;
	GtkWidget *but___11;
	GtkWidget *lab___11;
	GtkWidget *but__9;
	GtkWidget *lab__9;
	GtkWidget *but__8;
	GtkWidget *lab__8;
	GtkWidget *but_8;
	GtkWidget *lab_8;
	GtkWidget *but__5;
	GtkWidget *lab__5;
	GtkWidget *but__6;
	GtkWidget *lab__6;
	GtkWidget *but__7;
	GtkWidget *lab__7;
	GtkWidget *but___8;
	GtkWidget *lab___8;
	GtkWidget *but___7;
	GtkWidget *lab___7;
	GtkWidget *but___6;
	GtkWidget *lab___6;
	GtkWidget *but___5;
	GtkWidget *lab___5;
	GtkWidget *but___4;
	GtkWidget *lab___4;
	GtkWidget *but__4;
	GtkWidget *lab__4;
	GtkWidget *but___3;
	GtkWidget *lab___3;
	GtkWidget *but___2;
	GtkWidget *lab___2;
	GtkWidget *but9;
	GtkWidget *lab9;
	GtkWidget *but10;
	GtkWidget *lab10;
	GtkWidget *but11;
	GtkWidget *lab11;
	GtkWidget *but12;
	GtkWidget *lab12;
	GtkWidget *but_1;
	GtkWidget *lab_1;
	GtkWidget *but__1;
	GtkWidget *lab__1;
	GtkWidget *but__10;
	GtkWidget *lab__10;
	GtkWidget *but13;
	GtkWidget *lab13;
	GtkWidget *but___1;
	GtkWidget *lab___1;
	GtkWidget *but_10;
	GtkWidget *lab_10;
	GtkWidget *but2;
	GtkWidget *lab2;
	GtkWidget *but__11;
	GtkWidget *lab__11;
	GtkWidget *but___13;
	GtkWidget *but___14;
	GtkWidget *button_kbd5;
	GtkWidget *button_kbd4;
	GtkWidget *button_kbd1;
	GtkWidget *button_kbd2;
	GtkWidget *button_kbd6;
	GtkWidget *toggle_shift2;
	GtkWidget *pixmap9;
	GtkWidget *but_4;
	GtkWidget *lab_4;
	GtkWidget *but_11;
	GtkWidget *lab_11;
	GtkWidget *but_12;
	GtkWidget *lab_12;
	GtkWidget *but__14;
	GtkWidget *but3;
	GtkWidget *lab3;
	GtkWidget *but___9;
	GtkWidget *lab___9;
	GtkWidget *but___10;
	GtkWidget *lab___10;
	GtkWidget *but___12;
	GtkWidget *lab___12;
	GtkWidget *but_space;
	GtkWidget *but__12;
	GtkWidget *lab__12;
	GtkWidget *but_13;
	GtkWidget *lab_13;
	GtkWidget *but_14;
	GtkWidget *but14;
	GtkWidget *lab14;
	GtkWidget *but_tab;
	GtkWidget *but__13;
	GtkWidget *toggle_shift1;
	GtkWidget *pixmap8;
	GtkWidget *but1;
	GtkWidget *lab1;
	GtkWidget *hbox_kb_tutor;
	GtkWidget *label107;
	GtkWidget *pix_hands;
	GtkWidget *vbox39;
	GtkWidget *checkbutton_hints;
	GtkWidget *button_keyboard_close;
	GtkAccelGroup *accel_group;
	GtkTooltips *tooltips;

	tooltips = gtk_tooltips_new ();

	accel_group = gtk_accel_group_new ();

	window_keyboard = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_name (window_keyboard, "window_keyboard");
	gtk_container_set_border_width (GTK_CONTAINER (window_keyboard), 5);
	gtk_window_set_title (GTK_WINDOW (window_keyboard), _("Klavaro - Select or create your keyboard layout"));
	gtk_window_set_position (GTK_WINDOW (window_keyboard), GTK_WIN_POS_CENTER);
	gtk_window_set_type_hint (GTK_WINDOW (window_keyboard), GDK_WINDOW_TYPE_HINT_DIALOG);

	hbox56 = gtk_hbox_new (FALSE, 0);
	gtk_widget_set_name (hbox56, "hbox56");
	gtk_widget_show (hbox56);
	gtk_container_add (GTK_CONTAINER (window_keyboard), hbox56);

	vbox_kb_left = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox_kb_left, "vbox_kb_left");
	gtk_widget_show (vbox_kb_left);
	gtk_box_pack_start (GTK_BOX (hbox56), vbox_kb_left, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (vbox_kb_left), 5);

	vbox38 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox38, "vbox38");
	gtk_widget_show (vbox38);
	gtk_box_pack_start (GTK_BOX (vbox_kb_left), vbox38, TRUE, TRUE, 0);

	notebook_kb = gtk_notebook_new ();
	gtk_widget_set_name (notebook_kb, "notebook_kb");
	gtk_widget_show (notebook_kb);
	gtk_box_pack_start (GTK_BOX (vbox38), notebook_kb, FALSE, FALSE, 0);

	vbox24 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox24, "vbox24");
	gtk_widget_show (vbox24);
	gtk_container_add (GTK_CONTAINER (notebook_kb), vbox24);

	frame22 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame22, "frame22");
	gtk_widget_show (frame22);
	gtk_box_pack_start (GTK_BOX (vbox24), frame22, TRUE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame22), 5);
	gtk_frame_set_label_align (GTK_FRAME (frame22), 0.0500002, 0.5);

	vbox20 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox20, "vbox20");
	gtk_widget_show (vbox20);
	gtk_container_add (GTK_CONTAINER (frame22), vbox20);

	frame45 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame45, "frame45");
	gtk_widget_show (frame45);
	gtk_box_pack_start (GTK_BOX (vbox20), frame45, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame45), 5);
	gtk_frame_set_shadow_type (GTK_FRAME (frame45), GTK_SHADOW_OUT);

	combo_kb_main = gtk_combo_new ();
	g_object_set_data (G_OBJECT (GTK_COMBO (combo_kb_main)->popwin), "GladeParentKey", combo_kb_main);
	gtk_widget_set_name (combo_kb_main, "combo_kb_main");
	gtk_widget_show (combo_kb_main);
	gtk_container_add (GTK_CONTAINER (frame45), combo_kb_main);
	GTK_WIDGET_SET_FLAGS (combo_kb_main, GTK_CAN_FOCUS);
	gtk_combo_set_case_sensitive (GTK_COMBO (combo_kb_main), TRUE);
	gtk_combo_set_use_arrows_always (GTK_COMBO (combo_kb_main), TRUE);
	combo_kb_main_items = g_list_append (combo_kb_main_items, (gpointer) "");
	combo_kb_main_items = g_list_append (combo_kb_main_items, (gpointer) "");
	gtk_combo_set_popdown_strings (GTK_COMBO (combo_kb_main), combo_kb_main_items);
	g_list_free (combo_kb_main_items);

	entry_kb_main = GTK_COMBO (combo_kb_main)->entry;
	gtk_widget_set_name (entry_kb_main, "entry_kb_main");
	gtk_widget_show (entry_kb_main);
	GTK_WIDGET_UNSET_FLAGS (entry_kb_main, GTK_CAN_FOCUS);
	gtk_tooltips_set_tip (tooltips, entry_kb_main,
			      _("Choose one of the originally available keyboard layouts."), NULL);
	gtk_editable_set_editable (GTK_EDITABLE (entry_kb_main), FALSE);

	label122 = gtk_label_new (_("Original layouts"));
	gtk_widget_set_name (label122, "label122");
	gtk_widget_show (label122);
	gtk_frame_set_label_widget (GTK_FRAME (frame22), label122);

	frame23 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame23, "frame23");
	gtk_widget_show (frame23);
	gtk_box_pack_start (GTK_BOX (vbox24), frame23, TRUE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame23), 5);
	gtk_frame_set_label_align (GTK_FRAME (frame23), 0.05, 0.5);

	vbox21 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox21, "vbox21");
	gtk_widget_show (vbox21);
	gtk_container_add (GTK_CONTAINER (frame23), vbox21);

	frame46 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame46, "frame46");
	gtk_widget_show (frame46);
	gtk_box_pack_start (GTK_BOX (vbox21), frame46, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame46), 5);
	gtk_frame_set_shadow_type (GTK_FRAME (frame46), GTK_SHADOW_OUT);

	combo_kb_user = gtk_combo_new ();
	g_object_set_data (G_OBJECT (GTK_COMBO (combo_kb_user)->popwin), "GladeParentKey", combo_kb_user);
	gtk_widget_set_name (combo_kb_user, "combo_kb_user");
	gtk_widget_show (combo_kb_user);
	gtk_container_add (GTK_CONTAINER (frame46), combo_kb_user);
	GTK_WIDGET_SET_FLAGS (combo_kb_user, GTK_CAN_FOCUS);
	gtk_combo_set_case_sensitive (GTK_COMBO (combo_kb_user), TRUE);
	gtk_combo_set_use_arrows_always (GTK_COMBO (combo_kb_user), TRUE);
	combo_kb_user_items = g_list_append (combo_kb_user_items, (gpointer) "");
	combo_kb_user_items = g_list_append (combo_kb_user_items, (gpointer) "");
	gtk_combo_set_popdown_strings (GTK_COMBO (combo_kb_user), combo_kb_user_items);
	g_list_free (combo_kb_user_items);

	entry_kb_user = GTK_COMBO (combo_kb_user)->entry;
	gtk_widget_set_name (entry_kb_user, "entry_kb_user");
	gtk_widget_show (entry_kb_user);
	GTK_WIDGET_UNSET_FLAGS (entry_kb_user, GTK_CAN_FOCUS);
	gtk_tooltips_set_tip (tooltips, entry_kb_user, _("Choose one of these user defined keyboard layouts."), NULL);
	gtk_editable_set_editable (GTK_EDITABLE (entry_kb_user), FALSE);

	label123 = gtk_label_new (_("Custom layouts"));
	gtk_widget_set_name (label123, "label123");
	gtk_widget_show (label123);
	gtk_frame_set_label_widget (GTK_FRAME (frame23), label123);

	label_kb_load = gtk_label_new (_("Load"));
	gtk_widget_set_name (label_kb_load, "label_kb_load");
	gtk_widget_show (label_kb_load);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook_kb),
				    gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook_kb), 0), label_kb_load);
	gtk_label_set_justify (GTK_LABEL (label_kb_load), GTK_JUSTIFY_CENTER);

	vbox26 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox26, "vbox26");
	gtk_widget_show (vbox26);
	gtk_container_add (GTK_CONTAINER (notebook_kb), vbox26);

	frame34 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame34, "frame34");
	gtk_widget_show (frame34);
	gtk_box_pack_start (GTK_BOX (vbox26), frame34, TRUE, FALSE, 5);
	gtk_container_set_border_width (GTK_CONTAINER (frame34), 5);
	gtk_frame_set_label_align (GTK_FRAME (frame34), 0.02, 0.5);

	vbox33 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox33, "vbox33");
	gtk_widget_show (vbox33);
	gtk_container_add (GTK_CONTAINER (frame34), vbox33);

	combo_kb_edit = gtk_combo_new ();
	g_object_set_data (G_OBJECT (GTK_COMBO (combo_kb_edit)->popwin), "GladeParentKey", combo_kb_edit);
	gtk_widget_set_name (combo_kb_edit, "combo_kb_edit");
	gtk_widget_show (combo_kb_edit);
	gtk_box_pack_start (GTK_BOX (vbox33), combo_kb_edit, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (combo_kb_edit), 5);
	GTK_WIDGET_SET_FLAGS (combo_kb_edit, GTK_CAN_FOCUS);
	gtk_combo_set_case_sensitive (GTK_COMBO (combo_kb_edit), TRUE);
	combo_kb_edit_items = g_list_append (combo_kb_edit_items, (gpointer) "");
	gtk_combo_set_popdown_strings (GTK_COMBO (combo_kb_edit), combo_kb_edit_items);
	g_list_free (combo_kb_edit_items);

	entry_kb_edit = GTK_COMBO (combo_kb_edit)->entry;
	gtk_widget_set_name (entry_kb_edit, "entry_kb_edit");
	gtk_widget_show (entry_kb_edit);
	gtk_tooltips_set_tip (tooltips, entry_kb_edit, _("Write a name for a new keyboard layout."), NULL);

	hbox27 = gtk_hbox_new (TRUE, 0);
	gtk_widget_set_name (hbox27, "hbox27");
	gtk_widget_show (hbox27);
	gtk_box_pack_start (GTK_BOX (vbox33), hbox27, TRUE, TRUE, 0);

	button_kb_save = gtk_button_new_with_mnemonic (_("Save"));
	gtk_widget_set_name (button_kb_save, "button_kb_save");
	gtk_widget_show (button_kb_save);
	gtk_box_pack_start (GTK_BOX (hbox27), button_kb_save, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_kb_save), 5);
	gtk_tooltips_set_tip (tooltips, button_kb_save,
			      _("Save the current keyboard layout with the name specified above."), NULL);

	button_kb_remove = gtk_button_new_with_mnemonic (_("Remove"));
	gtk_widget_set_name (button_kb_remove, "button_kb_remove");
	gtk_widget_show (button_kb_remove);
	gtk_box_pack_start (GTK_BOX (hbox27), button_kb_remove, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_kb_remove), 5);
	gtk_tooltips_set_tip (tooltips, button_kb_remove,
			      _("Remove the layout shown above from the user defined list of available ones."), NULL);

	label124 = gtk_label_new (_("New custom layout"));
	gtk_widget_set_name (label124, "label124");
	gtk_widget_show (label124);
	gtk_frame_set_label_widget (GTK_FRAME (frame34), label124);

	label46 = gtk_label_new (_("Edit"));
	gtk_widget_set_name (label46, "label46");
	gtk_widget_show (label46);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook_kb),
				    gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook_kb), 1), label46);
	gtk_label_set_justify (GTK_LABEL (label46), GTK_JUSTIFY_CENTER);

	vseparator3 = gtk_vseparator_new ();
	gtk_widget_set_name (vseparator3, "vseparator3");
	gtk_widget_show (vseparator3);
	gtk_box_pack_start (GTK_BOX (vbox38), vseparator3, TRUE, TRUE, 3);

	frame43 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame43, "frame43");
	gtk_widget_show (frame43);
	gtk_box_pack_start (GTK_BOX (vbox38), frame43, FALSE, FALSE, 0);
	gtk_frame_set_label_align (GTK_FRAME (frame43), 0.5, 0.5);

	vbox36 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox36, "vbox36");
	gtk_widget_show (vbox36);
	gtk_container_add (GTK_CONTAINER (frame43), vbox36);

	frame42 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame42, "frame42");
	gtk_widget_show (frame42);
	gtk_box_pack_start (GTK_BOX (vbox36), frame42, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame42), 5);
	gtk_frame_set_shadow_type (GTK_FRAME (frame42), GTK_SHADOW_OUT);

	frame51 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame51, "frame51");
	gtk_widget_show (frame51);
	gtk_container_add (GTK_CONTAINER (frame42), frame51);
	gtk_frame_set_shadow_type (GTK_FRAME (frame51), GTK_SHADOW_IN);

	label_kb_name = gtk_label_new ("");
	gtk_widget_set_name (label_kb_name, "label_kb_name");
	gtk_widget_show (label_kb_name);
	gtk_container_add (GTK_CONTAINER (frame51), label_kb_name);
	gtk_label_set_justify (GTK_LABEL (label_kb_name), GTK_JUSTIFY_CENTER);

	hbox53 = gtk_hbox_new (TRUE, 0);
	gtk_widget_set_name (hbox53, "hbox53");
	gtk_widget_show (hbox53);
	gtk_box_pack_start (GTK_BOX (vbox36), hbox53, TRUE, TRUE, 0);

	button_keyboard_select = gtk_button_new_with_mnemonic (_("Select"));
	gtk_widget_set_name (button_keyboard_select, "button_keyboard_select");
	gtk_widget_show (button_keyboard_select);
	gtk_box_pack_start (GTK_BOX (hbox53), button_keyboard_select, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_keyboard_select), 4);
	gtk_tooltips_set_tip (tooltips, button_keyboard_select, _("Select the above keyboard layout."), NULL);

	button_keyboard_cancel = gtk_button_new_with_mnemonic (_("Cancel"));
	gtk_widget_set_name (button_keyboard_cancel, "button_keyboard_cancel");
	gtk_widget_show (button_keyboard_cancel);
	gtk_box_pack_start (GTK_BOX (hbox53), button_keyboard_cancel, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_keyboard_cancel), 4);
	gtk_tooltips_set_tip (tooltips, button_keyboard_cancel,
			      _("Return without any modification. Hotkey: [Esc]"), NULL);
	gtk_widget_add_accelerator (button_keyboard_cancel, "clicked",
				    accel_group, GDK_Escape, (GdkModifierType) 0, GTK_ACCEL_VISIBLE);

	label125 = gtk_label_new (_("Layout to be selected"));
	gtk_widget_set_name (label125, "label125");
	gtk_widget_show (label125);
	gtk_frame_set_label_widget (GTK_FRAME (frame43), label125);

	vbox19 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox19, "vbox19");
	gtk_widget_show (vbox19);
	gtk_box_pack_start (GTK_BOX (hbox56), vbox19, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (vbox19), 4);

	frame52 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame52, "frame52");
	gtk_widget_show (frame52);
	gtk_box_pack_start (GTK_BOX (vbox19), frame52, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type (GTK_FRAME (frame52), GTK_SHADOW_OUT);

	frame50 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame50, "frame50");
	gtk_widget_show (frame50);
	gtk_container_add (GTK_CONTAINER (frame52), frame50);
	gtk_container_set_border_width (GTK_CONTAINER (frame50), 2);
	gtk_frame_set_shadow_type (GTK_FRAME (frame50), GTK_SHADOW_IN);

	hbox30 = gtk_hbox_new (FALSE, 0);
	gtk_widget_set_name (hbox30, "hbox30");
	gtk_widget_show (hbox30);
	gtk_container_add (GTK_CONTAINER (frame50), hbox30);

	label_virtual_kb = gtk_label_new (_("VIRTUAL KEYBOARD"));
	gtk_widget_set_name (label_virtual_kb, "label_virtual_kb");
	gtk_widget_show (label_virtual_kb);
	gtk_box_pack_start (GTK_BOX (hbox30), label_virtual_kb, TRUE, TRUE, 0);
	gtk_label_set_justify (GTK_LABEL (label_virtual_kb), GTK_JUSTIFY_CENTER);
	gtk_misc_set_padding (GTK_MISC (label_virtual_kb), 0, 3);

	label_modified = gtk_label_new (_("( layout modified: save it before get out )"));
	gtk_widget_set_name (label_modified, "label_modified");
	gtk_box_pack_start (GTK_BOX (hbox30), label_modified, FALSE, TRUE, 0);
	gtk_label_set_justify (GTK_LABEL (label_modified), GTK_JUSTIFY_CENTER);
	gtk_misc_set_padding (GTK_MISC (label_modified), 3, 3);

	label_saved_tmp = gtk_label_new (_("( layout saved as \".tmp\" )"));
	gtk_widget_set_name (label_saved_tmp, "label_saved_tmp");
	gtk_box_pack_start (GTK_BOX (hbox30), label_saved_tmp, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (label_saved_tmp), 5, 0);

	hbox54 = gtk_hbox_new (FALSE, 0);
	gtk_widget_set_name (hbox54, "hbox54");
	gtk_widget_show (hbox54);
	gtk_box_pack_start (GTK_BOX (vbox19), hbox54, TRUE, TRUE, 0);

	vseparator4 = gtk_vseparator_new ();
	gtk_widget_set_name (vseparator4, "vseparator4");
	gtk_widget_show (vseparator4);
	gtk_box_pack_start (GTK_BOX (hbox54), vseparator4, TRUE, TRUE, 0);

	vseparator5 = gtk_vseparator_new ();
	gtk_widget_set_name (vseparator5, "vseparator5");
	gtk_widget_show (vseparator5);
	gtk_box_pack_start (GTK_BOX (hbox54), vseparator5, TRUE, TRUE, 0);

	frame24 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame24, "frame24");
	gtk_widget_show (frame24);
	gtk_box_pack_start (GTK_BOX (vbox19), frame24, FALSE, FALSE, 2);
	gtk_frame_set_shadow_type (GTK_FRAME (frame24), GTK_SHADOW_OUT);

	frame25 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame25, "frame25");
	gtk_widget_show (frame25);
	gtk_container_add (GTK_CONTAINER (frame24), frame25);
	gtk_container_set_border_width (GTK_CONTAINER (frame25), 5);
	gtk_frame_set_shadow_type (GTK_FRAME (frame25), GTK_SHADOW_IN);

	fixed2 = gtk_fixed_new ();
	gtk_widget_set_name (fixed2, "fixed2");
	gtk_widget_show (fixed2);
	gtk_container_add (GTK_CONTAINER (frame25), fixed2);

	but4 = gtk_button_new ();
	gtk_widget_set_name (but4, "but4");
	gtk_widget_show (but4);
	gtk_fixed_put (GTK_FIXED (fixed2), but4, 96, 0);
	gtk_widget_set_size_request (but4, 32, 32);
	gtk_tooltips_set_tip (tooltips, but4, _("second finger"), NULL);

	lab4 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab4, "lab4");
	gtk_widget_show (lab4);
	gtk_container_add (GTK_CONTAINER (but4), lab4);
	gtk_label_set_justify (GTK_LABEL (lab4), GTK_JUSTIFY_CENTER);

	but5 = gtk_button_new ();
	gtk_widget_set_name (but5, "but5");
	gtk_widget_show (but5);
	gtk_fixed_put (GTK_FIXED (fixed2), but5, 128, 0);
	gtk_widget_set_size_request (but5, 32, 32);
	gtk_tooltips_set_tip (tooltips, but5, _("index finger"), NULL);

	lab5 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab5, "lab5");
	gtk_widget_show (lab5);
	gtk_container_add (GTK_CONTAINER (but5), lab5);
	gtk_label_set_justify (GTK_LABEL (lab5), GTK_JUSTIFY_CENTER);

	but6 = gtk_button_new ();
	gtk_widget_set_name (but6, "but6");
	gtk_widget_show (but6);
	gtk_fixed_put (GTK_FIXED (fixed2), but6, 160, 0);
	gtk_widget_set_size_request (but6, 32, 32);
	gtk_tooltips_set_tip (tooltips, but6, _("index finger"), NULL);

	lab6 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab6, "lab6");
	gtk_widget_show (lab6);
	gtk_container_add (GTK_CONTAINER (but6), lab6);
	gtk_label_set_justify (GTK_LABEL (lab6), GTK_JUSTIFY_CENTER);

	but7 = gtk_button_new ();
	gtk_widget_set_name (but7, "but7");
	gtk_widget_show (but7);
	gtk_fixed_put (GTK_FIXED (fixed2), but7, 192, 0);
	gtk_widget_set_size_request (but7, 32, 32);
	gtk_tooltips_set_tip (tooltips, but7, _("index finger"), NULL);

	lab7 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab7, "lab7");
	gtk_widget_show (lab7);
	gtk_container_add (GTK_CONTAINER (but7), lab7);
	gtk_label_set_justify (GTK_LABEL (lab7), GTK_JUSTIFY_CENTER);

	but8 = gtk_button_new ();
	gtk_widget_set_name (but8, "but8");
	gtk_widget_show (but8);
	gtk_fixed_put (GTK_FIXED (fixed2), but8, 224, 0);
	gtk_widget_set_size_request (but8, 32, 32);
	gtk_tooltips_set_tip (tooltips, but8, _("index finger"), NULL);

	lab8 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab8, "lab8");
	gtk_widget_show (lab8);
	gtk_container_add (GTK_CONTAINER (but8), lab8);
	gtk_label_set_justify (GTK_LABEL (lab8), GTK_JUSTIFY_CENTER);

	but_2 = gtk_button_new ();
	gtk_widget_set_name (but_2, "but_2");
	gtk_widget_show (but_2);
	gtk_fixed_put (GTK_FIXED (fixed2), but_2, 80, 32);
	gtk_widget_set_size_request (but_2, 32, 32);
	gtk_tooltips_set_tip (tooltips, but_2, _("third finger"), NULL);

	lab_2 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab_2, "lab_2");
	gtk_widget_show (lab_2);
	gtk_container_add (GTK_CONTAINER (but_2), lab_2);
	gtk_label_set_justify (GTK_LABEL (lab_2), GTK_JUSTIFY_CENTER);

	but_3 = gtk_button_new ();
	gtk_widget_set_name (but_3, "but_3");
	gtk_widget_show (but_3);
	gtk_fixed_put (GTK_FIXED (fixed2), but_3, 112, 32);
	gtk_widget_set_size_request (but_3, 32, 32);
	gtk_tooltips_set_tip (tooltips, but_3, _("second finger"), NULL);

	lab_3 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab_3, "lab_3");
	gtk_widget_show (lab_3);
	gtk_container_add (GTK_CONTAINER (but_3), lab_3);
	gtk_label_set_justify (GTK_LABEL (lab_3), GTK_JUSTIFY_CENTER);

	but__2 = gtk_button_new ();
	gtk_widget_set_name (but__2, "but__2");
	gtk_widget_show (but__2);
	gtk_fixed_put (GTK_FIXED (fixed2), but__2, 88, 64);
	gtk_widget_set_size_request (but__2, 32, 32);
	gtk_tooltips_set_tip (tooltips, but__2, _("third finger"), NULL);

	lab__2 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab__2, "lab__2");
	gtk_widget_show (lab__2);
	gtk_container_add (GTK_CONTAINER (but__2), lab__2);
	gtk_label_set_justify (GTK_LABEL (lab__2), GTK_JUSTIFY_CENTER);

	but__3 = gtk_button_new ();
	gtk_widget_set_name (but__3, "but__3");
	gtk_widget_show (but__3);
	gtk_fixed_put (GTK_FIXED (fixed2), but__3, 120, 64);
	gtk_widget_set_size_request (but__3, 32, 32);
	gtk_tooltips_set_tip (tooltips, but__3, _("second finger"), NULL);

	lab__3 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab__3, "lab__3");
	gtk_widget_show (lab__3);
	gtk_container_add (GTK_CONTAINER (but__3), lab__3);
	gtk_label_set_justify (GTK_LABEL (lab__3), GTK_JUSTIFY_CENTER);

	but_5 = gtk_button_new ();
	gtk_widget_set_name (but_5, "but_5");
	gtk_widget_show (but_5);
	gtk_fixed_put (GTK_FIXED (fixed2), but_5, 176, 32);
	gtk_widget_set_size_request (but_5, 32, 32);
	gtk_tooltips_set_tip (tooltips, but_5, _("index finger"), NULL);

	lab_5 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab_5, "lab_5");
	gtk_widget_show (lab_5);
	gtk_container_add (GTK_CONTAINER (but_5), lab_5);
	gtk_label_set_justify (GTK_LABEL (lab_5), GTK_JUSTIFY_CENTER);

	but_6 = gtk_button_new ();
	gtk_widget_set_name (but_6, "but_6");
	gtk_widget_show (but_6);
	gtk_fixed_put (GTK_FIXED (fixed2), but_6, 208, 32);
	gtk_widget_set_size_request (but_6, 32, 32);
	gtk_tooltips_set_tip (tooltips, but_6, _("index finger"), NULL);

	lab_6 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab_6, "lab_6");
	gtk_widget_show (lab_6);
	gtk_container_add (GTK_CONTAINER (but_6), lab_6);
	gtk_label_set_justify (GTK_LABEL (lab_6), GTK_JUSTIFY_CENTER);

	but_7 = gtk_button_new ();
	gtk_widget_set_name (but_7, "but_7");
	gtk_widget_show (but_7);
	gtk_fixed_put (GTK_FIXED (fixed2), but_7, 240, 32);
	gtk_widget_set_size_request (but_7, 32, 32);
	gtk_tooltips_set_tip (tooltips, but_7, _("index finger"), NULL);

	lab_7 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab_7, "lab_7");
	gtk_widget_show (lab_7);
	gtk_container_add (GTK_CONTAINER (but_7), lab_7);
	gtk_label_set_justify (GTK_LABEL (lab_7), GTK_JUSTIFY_CENTER);

	but_9 = gtk_button_new ();
	gtk_widget_set_name (but_9, "but_9");
	gtk_widget_show (but_9);
	gtk_fixed_put (GTK_FIXED (fixed2), but_9, 304, 32);
	gtk_widget_set_size_request (but_9, 32, 32);
	gtk_tooltips_set_tip (tooltips, but_9, _("third finger"), NULL);

	lab_9 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab_9, "lab_9");
	gtk_widget_show (lab_9);
	gtk_container_add (GTK_CONTAINER (but_9), lab_9);
	gtk_label_set_justify (GTK_LABEL (lab_9), GTK_JUSTIFY_CENTER);

	but___11 = gtk_button_new ();
	gtk_widget_set_name (but___11, "but___11");
	gtk_widget_show (but___11);
	gtk_fixed_put (GTK_FIXED (fixed2), but___11, 360, 96);
	gtk_widget_set_size_request (but___11, 32, 32);
	gtk_tooltips_set_tip (tooltips, but___11, _("fourth finger"), NULL);

	lab___11 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab___11, "lab___11");
	gtk_widget_show (lab___11);
	gtk_container_add (GTK_CONTAINER (but___11), lab___11);
	gtk_label_set_justify (GTK_LABEL (lab___11), GTK_JUSTIFY_CENTER);

	but__9 = gtk_button_new ();
	gtk_widget_set_name (but__9, "but__9");
	gtk_widget_show (but__9);
	gtk_fixed_put (GTK_FIXED (fixed2), but__9, 312, 64);
	gtk_widget_set_size_request (but__9, 32, 32);
	gtk_tooltips_set_tip (tooltips, but__9, _("third finger"), NULL);

	lab__9 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab__9, "lab__9");
	gtk_widget_show (lab__9);
	gtk_container_add (GTK_CONTAINER (but__9), lab__9);
	gtk_label_set_justify (GTK_LABEL (lab__9), GTK_JUSTIFY_CENTER);

	but__8 = gtk_button_new ();
	gtk_widget_set_name (but__8, "but__8");
	gtk_widget_show (but__8);
	gtk_fixed_put (GTK_FIXED (fixed2), but__8, 280, 64);
	gtk_widget_set_size_request (but__8, 32, 32);
	gtk_tooltips_set_tip (tooltips, but__8, _("second finger"), NULL);

	lab__8 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab__8, "lab__8");
	gtk_widget_show (lab__8);
	gtk_container_add (GTK_CONTAINER (but__8), lab__8);
	gtk_label_set_justify (GTK_LABEL (lab__8), GTK_JUSTIFY_CENTER);

	but_8 = gtk_button_new ();
	gtk_widget_set_name (but_8, "but_8");
	gtk_widget_show (but_8);
	gtk_fixed_put (GTK_FIXED (fixed2), but_8, 272, 32);
	gtk_widget_set_size_request (but_8, 32, 32);
	gtk_tooltips_set_tip (tooltips, but_8, _("second finger"), NULL);

	lab_8 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab_8, "lab_8");
	gtk_widget_show (lab_8);
	gtk_container_add (GTK_CONTAINER (but_8), lab_8);
	gtk_label_set_justify (GTK_LABEL (lab_8), GTK_JUSTIFY_CENTER);

	but__5 = gtk_button_new ();
	gtk_widget_set_name (but__5, "but__5");
	gtk_widget_show (but__5);
	gtk_fixed_put (GTK_FIXED (fixed2), but__5, 184, 64);
	gtk_widget_set_size_request (but__5, 32, 32);
	gtk_tooltips_set_tip (tooltips, but__5, _("index finger"), NULL);

	lab__5 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab__5, "lab__5");
	gtk_widget_show (lab__5);
	gtk_container_add (GTK_CONTAINER (but__5), lab__5);
	gtk_label_set_justify (GTK_LABEL (lab__5), GTK_JUSTIFY_CENTER);

	but__6 = gtk_button_new ();
	gtk_widget_set_name (but__6, "but__6");
	gtk_widget_show (but__6);
	gtk_fixed_put (GTK_FIXED (fixed2), but__6, 216, 64);
	gtk_widget_set_size_request (but__6, 32, 32);
	gtk_tooltips_set_tip (tooltips, but__6, _("index finger"), NULL);

	lab__6 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab__6, "lab__6");
	gtk_widget_show (lab__6);
	gtk_container_add (GTK_CONTAINER (but__6), lab__6);
	gtk_label_set_justify (GTK_LABEL (lab__6), GTK_JUSTIFY_CENTER);

	but__7 = gtk_button_new ();
	gtk_widget_set_name (but__7, "but__7");
	gtk_widget_show (but__7);
	gtk_fixed_put (GTK_FIXED (fixed2), but__7, 248, 64);
	gtk_widget_set_size_request (but__7, 32, 32);
	gtk_tooltips_set_tip (tooltips, but__7, _("index finger"), NULL);

	lab__7 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab__7, "lab__7");
	gtk_widget_show (lab__7);
	gtk_container_add (GTK_CONTAINER (but__7), lab__7);
	gtk_label_set_justify (GTK_LABEL (lab__7), GTK_JUSTIFY_CENTER);

	but___8 = gtk_button_new ();
	gtk_widget_set_name (but___8, "but___8");
	gtk_widget_show (but___8);
	gtk_fixed_put (GTK_FIXED (fixed2), but___8, 264, 96);
	gtk_widget_set_size_request (but___8, 32, 32);
	gtk_tooltips_set_tip (tooltips, but___8, _("index finger"), NULL);

	lab___8 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab___8, "lab___8");
	gtk_widget_show (lab___8);
	gtk_container_add (GTK_CONTAINER (but___8), lab___8);
	gtk_label_set_justify (GTK_LABEL (lab___8), GTK_JUSTIFY_CENTER);

	but___7 = gtk_button_new ();
	gtk_widget_set_name (but___7, "but___7");
	gtk_widget_show (but___7);
	gtk_fixed_put (GTK_FIXED (fixed2), but___7, 232, 96);
	gtk_widget_set_size_request (but___7, 32, 32);
	gtk_tooltips_set_tip (tooltips, but___7, _("index finger"), NULL);

	lab___7 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab___7, "lab___7");
	gtk_widget_show (lab___7);
	gtk_container_add (GTK_CONTAINER (but___7), lab___7);
	gtk_label_set_justify (GTK_LABEL (lab___7), GTK_JUSTIFY_CENTER);

	but___6 = gtk_button_new ();
	gtk_widget_set_name (but___6, "but___6");
	gtk_widget_show (but___6);
	gtk_fixed_put (GTK_FIXED (fixed2), but___6, 200, 96);
	gtk_widget_set_size_request (but___6, 32, 32);
	gtk_tooltips_set_tip (tooltips, but___6, _("index finger"), NULL);

	lab___6 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab___6, "lab___6");
	gtk_widget_show (lab___6);
	gtk_container_add (GTK_CONTAINER (but___6), lab___6);
	gtk_label_set_justify (GTK_LABEL (lab___6), GTK_JUSTIFY_CENTER);

	but___5 = gtk_button_new ();
	gtk_widget_set_name (but___5, "but___5");
	gtk_widget_show (but___5);
	gtk_fixed_put (GTK_FIXED (fixed2), but___5, 168, 96);
	gtk_widget_set_size_request (but___5, 32, 32);
	gtk_tooltips_set_tip (tooltips, but___5, _("index finger"), NULL);

	lab___5 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab___5, "lab___5");
	gtk_widget_show (lab___5);
	gtk_container_add (GTK_CONTAINER (but___5), lab___5);
	gtk_label_set_justify (GTK_LABEL (lab___5), GTK_JUSTIFY_CENTER);

	but___4 = gtk_button_new ();
	gtk_widget_set_name (but___4, "but___4");
	gtk_widget_show (but___4);
	gtk_fixed_put (GTK_FIXED (fixed2), but___4, 136, 96);
	gtk_widget_set_size_request (but___4, 32, 32);
	gtk_tooltips_set_tip (tooltips, but___4, _("second finger"), NULL);

	lab___4 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab___4, "lab___4");
	gtk_widget_show (lab___4);
	gtk_container_add (GTK_CONTAINER (but___4), lab___4);
	gtk_label_set_justify (GTK_LABEL (lab___4), GTK_JUSTIFY_CENTER);

	but__4 = gtk_button_new ();
	gtk_widget_set_name (but__4, "but__4");
	gtk_widget_show (but__4);
	gtk_fixed_put (GTK_FIXED (fixed2), but__4, 152, 64);
	gtk_widget_set_size_request (but__4, 32, 32);
	gtk_tooltips_set_tip (tooltips, but__4, _("index finger"), NULL);

	lab__4 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab__4, "lab__4");
	gtk_widget_show (lab__4);
	gtk_container_add (GTK_CONTAINER (but__4), lab__4);
	gtk_label_set_justify (GTK_LABEL (lab__4), GTK_JUSTIFY_CENTER);

	but___3 = gtk_button_new ();
	gtk_widget_set_name (but___3, "but___3");
	gtk_widget_show (but___3);
	gtk_fixed_put (GTK_FIXED (fixed2), but___3, 104, 96);
	gtk_widget_set_size_request (but___3, 32, 32);
	gtk_tooltips_set_tip (tooltips, but___3, _("third finger"), NULL);

	lab___3 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab___3, "lab___3");
	gtk_widget_show (lab___3);
	gtk_container_add (GTK_CONTAINER (but___3), lab___3);
	gtk_label_set_justify (GTK_LABEL (lab___3), GTK_JUSTIFY_CENTER);

	but___2 = gtk_button_new ();
	gtk_widget_set_name (but___2, "but___2");
	gtk_widget_show (but___2);
	gtk_fixed_put (GTK_FIXED (fixed2), but___2, 72, 96);
	gtk_widget_set_size_request (but___2, 32, 32);
	gtk_tooltips_set_tip (tooltips, but___2, _("fourth finger"), NULL);

	lab___2 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab___2, "lab___2");
	gtk_widget_show (lab___2);
	gtk_container_add (GTK_CONTAINER (but___2), lab___2);
	gtk_label_set_justify (GTK_LABEL (lab___2), GTK_JUSTIFY_CENTER);

	but9 = gtk_button_new ();
	gtk_widget_set_name (but9, "but9");
	gtk_widget_show (but9);
	gtk_fixed_put (GTK_FIXED (fixed2), but9, 256, 0);
	gtk_widget_set_size_request (but9, 32, 32);
	gtk_tooltips_set_tip (tooltips, but9, _("second finger"), NULL);

	lab9 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab9, "lab9");
	gtk_widget_show (lab9);
	gtk_container_add (GTK_CONTAINER (but9), lab9);
	gtk_label_set_justify (GTK_LABEL (lab9), GTK_JUSTIFY_CENTER);

	but10 = gtk_button_new ();
	gtk_widget_set_name (but10, "but10");
	gtk_widget_show (but10);
	gtk_fixed_put (GTK_FIXED (fixed2), but10, 288, 0);
	gtk_widget_set_size_request (but10, 32, 32);
	gtk_tooltips_set_tip (tooltips, but10, _("third finger"), NULL);

	lab10 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab10, "lab10");
	gtk_widget_show (lab10);
	gtk_container_add (GTK_CONTAINER (but10), lab10);
	gtk_label_set_justify (GTK_LABEL (lab10), GTK_JUSTIFY_CENTER);

	but11 = gtk_button_new ();
	gtk_widget_set_name (but11, "but11");
	gtk_widget_show (but11);
	gtk_fixed_put (GTK_FIXED (fixed2), but11, 320, 0);
	gtk_widget_set_size_request (but11, 32, 32);
	gtk_tooltips_set_tip (tooltips, but11, _("fourth finger"), NULL);

	lab11 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab11, "lab11");
	gtk_widget_show (lab11);
	gtk_container_add (GTK_CONTAINER (but11), lab11);
	gtk_label_set_justify (GTK_LABEL (lab11), GTK_JUSTIFY_CENTER);

	but12 = gtk_button_new ();
	gtk_widget_set_name (but12, "but12");
	gtk_widget_show (but12);
	gtk_fixed_put (GTK_FIXED (fixed2), but12, 352, 0);
	gtk_widget_set_size_request (but12, 32, 32);
	gtk_tooltips_set_tip (tooltips, but12, _("fourth finger"), NULL);

	lab12 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab12, "lab12");
	gtk_widget_show (lab12);
	gtk_container_add (GTK_CONTAINER (but12), lab12);
	gtk_label_set_justify (GTK_LABEL (lab12), GTK_JUSTIFY_CENTER);

	but_1 = gtk_button_new ();
	gtk_widget_set_name (but_1, "but_1");
	gtk_widget_show (but_1);
	gtk_fixed_put (GTK_FIXED (fixed2), but_1, 48, 32);
	gtk_widget_set_size_request (but_1, 32, 32);
	gtk_tooltips_set_tip (tooltips, but_1, _("fourth finger"), NULL);

	lab_1 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab_1, "lab_1");
	gtk_widget_show (lab_1);
	gtk_container_add (GTK_CONTAINER (but_1), lab_1);
	gtk_label_set_justify (GTK_LABEL (lab_1), GTK_JUSTIFY_CENTER);

	but__1 = gtk_button_new ();
	gtk_widget_set_name (but__1, "but__1");
	gtk_widget_show (but__1);
	gtk_fixed_put (GTK_FIXED (fixed2), but__1, 56, 64);
	gtk_widget_set_size_request (but__1, 32, 32);
	gtk_tooltips_set_tip (tooltips, but__1, _("fourth finger"), NULL);

	lab__1 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab__1, "lab__1");
	gtk_widget_show (lab__1);
	gtk_container_add (GTK_CONTAINER (but__1), lab__1);
	gtk_label_set_justify (GTK_LABEL (lab__1), GTK_JUSTIFY_CENTER);

	but__10 = gtk_button_new ();
	gtk_widget_set_name (but__10, "but__10");
	gtk_widget_show (but__10);
	gtk_fixed_put (GTK_FIXED (fixed2), but__10, 344, 64);
	gtk_widget_set_size_request (but__10, 32, 32);
	gtk_tooltips_set_tip (tooltips, but__10, _("fourth finger"), NULL);

	lab__10 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab__10, "lab__10");
	gtk_widget_show (lab__10);
	gtk_container_add (GTK_CONTAINER (but__10), lab__10);
	gtk_label_set_justify (GTK_LABEL (lab__10), GTK_JUSTIFY_CENTER);

	but13 = gtk_button_new ();
	gtk_widget_set_name (but13, "but13");
	gtk_widget_show (but13);
	gtk_fixed_put (GTK_FIXED (fixed2), but13, 384, 0);
	gtk_widget_set_size_request (but13, 32, 32);
	gtk_tooltips_set_tip (tooltips, but13, _("fourth finger"), NULL);

	lab13 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab13, "lab13");
	gtk_widget_show (lab13);
	gtk_container_add (GTK_CONTAINER (but13), lab13);
	gtk_label_set_justify (GTK_LABEL (lab13), GTK_JUSTIFY_CENTER);

	but___1 = gtk_button_new ();
	gtk_widget_set_name (but___1, "but___1");
	gtk_widget_show (but___1);
	gtk_fixed_put (GTK_FIXED (fixed2), but___1, 40, 96);
	gtk_widget_set_size_request (but___1, 32, 32);
	gtk_tooltips_set_tip (tooltips, but___1, _("fourth finger"), NULL);

	lab___1 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab___1, "lab___1");
	gtk_widget_show (lab___1);
	gtk_container_add (GTK_CONTAINER (but___1), lab___1);
	gtk_label_set_justify (GTK_LABEL (lab___1), GTK_JUSTIFY_CENTER);

	but_10 = gtk_button_new ();
	gtk_widget_set_name (but_10, "but_10");
	gtk_widget_show (but_10);
	gtk_fixed_put (GTK_FIXED (fixed2), but_10, 336, 32);
	gtk_widget_set_size_request (but_10, 32, 32);
	gtk_tooltips_set_tip (tooltips, but_10, _("fourth finger"), NULL);

	lab_10 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab_10, "lab_10");
	gtk_widget_show (lab_10);
	gtk_container_add (GTK_CONTAINER (but_10), lab_10);
	gtk_label_set_justify (GTK_LABEL (lab_10), GTK_JUSTIFY_CENTER);

	but2 = gtk_button_new ();
	gtk_widget_set_name (but2, "but2");
	gtk_widget_show (but2);
	gtk_fixed_put (GTK_FIXED (fixed2), but2, 32, 0);
	gtk_widget_set_size_request (but2, 32, 32);
	gtk_tooltips_set_tip (tooltips, but2, _("fourth finger"), NULL);

	lab2 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab2, "lab2");
	gtk_widget_show (lab2);
	gtk_container_add (GTK_CONTAINER (but2), lab2);
	gtk_label_set_justify (GTK_LABEL (lab2), GTK_JUSTIFY_CENTER);

	but__11 = gtk_button_new ();
	gtk_widget_set_name (but__11, "but__11");
	gtk_widget_show (but__11);
	gtk_fixed_put (GTK_FIXED (fixed2), but__11, 376, 64);
	gtk_widget_set_size_request (but__11, 32, 32);
	gtk_tooltips_set_tip (tooltips, but__11, _("fourth finger"), NULL);

	lab__11 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab__11, "lab__11");
	gtk_widget_show (lab__11);
	gtk_container_add (GTK_CONTAINER (but__11), lab__11);
	gtk_label_set_justify (GTK_LABEL (lab__11), GTK_JUSTIFY_CENTER);

	but___13 = gtk_button_new_with_mnemonic (_("Ctrl"));
	gtk_widget_set_name (but___13, "but___13");
	gtk_widget_show (but___13);
	gtk_fixed_put (GTK_FIXED (fixed2), but___13, 0, 128);
	gtk_widget_set_size_request (but___13, 40, 32);
	gtk_widget_set_sensitive (but___13, FALSE);
	GTK_WIDGET_UNSET_FLAGS (but___13, GTK_CAN_FOCUS);

	but___14 = gtk_button_new_with_mnemonic (_("Ctrl"));
	gtk_widget_set_name (but___14, "but___14");
	gtk_widget_show (but___14);
	gtk_fixed_put (GTK_FIXED (fixed2), but___14, 440, 128);
	gtk_widget_set_size_request (but___14, 40, 32);
	gtk_widget_set_sensitive (but___14, FALSE);
	GTK_WIDGET_UNSET_FLAGS (but___14, GTK_CAN_FOCUS);

	button_kbd5 = gtk_button_new_with_mnemonic ("");
	gtk_widget_set_name (button_kbd5, "button_kbd5");
	gtk_widget_show (button_kbd5);
	gtk_fixed_put (GTK_FIXED (fixed2), button_kbd5, 360, 128);
	gtk_widget_set_size_request (button_kbd5, 40, 32);
	gtk_widget_set_sensitive (button_kbd5, FALSE);
	GTK_WIDGET_UNSET_FLAGS (button_kbd5, GTK_CAN_FOCUS);

	button_kbd4 = gtk_button_new_with_mnemonic ("");
	gtk_widget_set_name (button_kbd4, "button_kbd4");
	gtk_widget_show (button_kbd4);
	gtk_fixed_put (GTK_FIXED (fixed2), button_kbd4, 320, 128);
	gtk_widget_set_size_request (button_kbd4, 40, 32);
	gtk_widget_set_sensitive (button_kbd4, FALSE);
	GTK_WIDGET_UNSET_FLAGS (button_kbd4, GTK_CAN_FOCUS);

	button_kbd1 = gtk_button_new_with_mnemonic ("");
	gtk_widget_set_name (button_kbd1, "button_kbd1");
	gtk_widget_show (button_kbd1);
	gtk_fixed_put (GTK_FIXED (fixed2), button_kbd1, 40, 128);
	gtk_widget_set_size_request (button_kbd1, 40, 32);
	gtk_widget_set_sensitive (button_kbd1, FALSE);
	GTK_WIDGET_UNSET_FLAGS (button_kbd1, GTK_CAN_FOCUS);

	button_kbd2 = gtk_button_new_with_mnemonic ("");
	gtk_widget_set_name (button_kbd2, "button_kbd2");
	gtk_widget_show (button_kbd2);
	gtk_fixed_put (GTK_FIXED (fixed2), button_kbd2, 80, 128);
	gtk_widget_set_size_request (button_kbd2, 40, 32);
	gtk_widget_set_sensitive (button_kbd2, FALSE);
	GTK_WIDGET_UNSET_FLAGS (button_kbd2, GTK_CAN_FOCUS);

	button_kbd6 = gtk_button_new_with_mnemonic ("");
	gtk_widget_set_name (button_kbd6, "button_kbd6");
	gtk_widget_show (button_kbd6);
	gtk_fixed_put (GTK_FIXED (fixed2), button_kbd6, 400, 128);
	gtk_widget_set_size_request (button_kbd6, 40, 32);
	gtk_widget_set_sensitive (button_kbd6, FALSE);
	GTK_WIDGET_UNSET_FLAGS (button_kbd6, GTK_CAN_FOCUS);

	toggle_shift2 = gtk_toggle_button_new ();
	gtk_widget_set_name (toggle_shift2, "toggle_shift2");
	gtk_widget_show (toggle_shift2);
	gtk_fixed_put (GTK_FIXED (fixed2), toggle_shift2, 424, 96);
	gtk_widget_set_size_request (toggle_shift2, 56, 32);
	gtk_tooltips_set_tip (tooltips, toggle_shift2,
			      _
			      ("Toggles the shift effect on the keys. Alternates between the upper and lower characters of the keys."),
			      NULL);

	pixmap9 = create_pixmap (window_keyboard, "shift.xpm");
	gtk_widget_set_name (pixmap9, "pixmap9");
	gtk_widget_show (pixmap9);
	gtk_container_add (GTK_CONTAINER (toggle_shift2), pixmap9);
	gtk_misc_set_alignment (GTK_MISC (pixmap9), 0.5, 0);

	but_4 = gtk_button_new ();
	gtk_widget_set_name (but_4, "but_4");
	gtk_widget_show (but_4);
	gtk_fixed_put (GTK_FIXED (fixed2), but_4, 144, 32);
	gtk_widget_set_size_request (but_4, 32, 32);
	gtk_tooltips_set_tip (tooltips, but_4, _("index finger"), NULL);

	lab_4 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab_4, "lab_4");
	gtk_widget_show (lab_4);
	gtk_container_add (GTK_CONTAINER (but_4), lab_4);
	gtk_label_set_justify (GTK_LABEL (lab_4), GTK_JUSTIFY_CENTER);

	but_11 = gtk_button_new ();
	gtk_widget_set_name (but_11, "but_11");
	gtk_widget_show (but_11);
	gtk_fixed_put (GTK_FIXED (fixed2), but_11, 368, 32);
	gtk_widget_set_size_request (but_11, 32, 32);
	gtk_tooltips_set_tip (tooltips, but_11, _("fourth finger"), NULL);

	lab_11 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab_11, "lab_11");
	gtk_widget_show (lab_11);
	gtk_container_add (GTK_CONTAINER (but_11), lab_11);
	gtk_label_set_justify (GTK_LABEL (lab_11), GTK_JUSTIFY_CENTER);

	but_12 = gtk_button_new ();
	gtk_widget_set_name (but_12, "but_12");
	gtk_widget_show (but_12);
	gtk_fixed_put (GTK_FIXED (fixed2), but_12, 400, 32);
	gtk_widget_set_size_request (but_12, 32, 32);
	gtk_tooltips_set_tip (tooltips, but_12, _("fourth finger"), NULL);

	lab_12 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab_12, "lab_12");
	gtk_widget_show (lab_12);
	gtk_container_add (GTK_CONTAINER (but_12), lab_12);
	gtk_label_set_justify (GTK_LABEL (lab_12), GTK_JUSTIFY_CENTER);

	but__14 = gtk_button_new_with_mnemonic (_("<____|"));
	gtk_widget_set_name (but__14, "but__14");
	gtk_widget_show (but__14);
	gtk_fixed_put (GTK_FIXED (fixed2), but__14, 440, 64);
	gtk_widget_set_size_request (but__14, 40, 32);
	gtk_widget_set_sensitive (but__14, FALSE);
	GTK_WIDGET_UNSET_FLAGS (but__14, GTK_CAN_FOCUS);

	but3 = gtk_button_new ();
	gtk_widget_set_name (but3, "but3");
	gtk_widget_show (but3);
	gtk_fixed_put (GTK_FIXED (fixed2), but3, 64, 0);
	gtk_widget_set_size_request (but3, 32, 32);
	gtk_tooltips_set_tip (tooltips, but3, _("third finger"), NULL);

	lab3 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab3, "lab3");
	gtk_widget_show (lab3);
	gtk_container_add (GTK_CONTAINER (but3), lab3);
	gtk_label_set_justify (GTK_LABEL (lab3), GTK_JUSTIFY_CENTER);

	but___9 = gtk_button_new ();
	gtk_widget_set_name (but___9, "but___9");
	gtk_widget_show (but___9);
	gtk_fixed_put (GTK_FIXED (fixed2), but___9, 296, 96);
	gtk_widget_set_size_request (but___9, 32, 32);
	gtk_tooltips_set_tip (tooltips, but___9, _("second finger"), NULL);

	lab___9 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab___9, "lab___9");
	gtk_widget_show (lab___9);
	gtk_container_add (GTK_CONTAINER (but___9), lab___9);
	gtk_label_set_justify (GTK_LABEL (lab___9), GTK_JUSTIFY_CENTER);

	but___10 = gtk_button_new ();
	gtk_widget_set_name (but___10, "but___10");
	gtk_widget_show (but___10);
	gtk_fixed_put (GTK_FIXED (fixed2), but___10, 328, 96);
	gtk_widget_set_size_request (but___10, 32, 32);
	gtk_tooltips_set_tip (tooltips, but___10, _("third finger"), NULL);

	lab___10 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab___10, "lab___10");
	gtk_widget_show (lab___10);
	gtk_container_add (GTK_CONTAINER (but___10), lab___10);
	gtk_label_set_justify (GTK_LABEL (lab___10), GTK_JUSTIFY_CENTER);

	but___12 = gtk_button_new ();
	gtk_widget_set_name (but___12, "but___12");
	gtk_widget_show (but___12);
	gtk_fixed_put (GTK_FIXED (fixed2), but___12, 392, 96);
	gtk_widget_set_size_request (but___12, 32, 32);
	gtk_tooltips_set_tip (tooltips, but___12, _("fourth finger"), NULL);

	lab___12 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab___12, "lab___12");
	gtk_widget_show (lab___12);
	gtk_container_add (GTK_CONTAINER (but___12), lab___12);
	gtk_label_set_justify (GTK_LABEL (lab___12), GTK_JUSTIFY_CENTER);

	but_space = gtk_button_new_with_mnemonic (_("SPACE BAR"));
	gtk_widget_set_name (but_space, "but_space");
	gtk_widget_show (but_space);
	gtk_fixed_put (GTK_FIXED (fixed2), but_space, 120, 128);
	gtk_widget_set_size_request (but_space, 200, 32);
	gtk_widget_set_sensitive (but_space, FALSE);
	GTK_WIDGET_UNSET_FLAGS (but_space, GTK_CAN_FOCUS);
	gtk_tooltips_set_tip (tooltips, but_space, _("thumbs"), NULL);

	but__12 = gtk_button_new ();
	gtk_widget_set_name (but__12, "but__12");
	gtk_widget_show (but__12);
	gtk_fixed_put (GTK_FIXED (fixed2), but__12, 408, 64);
	gtk_widget_set_size_request (but__12, 32, 32);
	gtk_tooltips_set_tip (tooltips, but__12, _("fourth finger"), NULL);

	lab__12 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab__12, "lab__12");
	gtk_widget_show (lab__12);
	gtk_container_add (GTK_CONTAINER (but__12), lab__12);
	gtk_label_set_justify (GTK_LABEL (lab__12), GTK_JUSTIFY_CENTER);

	but_13 = gtk_button_new ();
	gtk_widget_set_name (but_13, "but_13");
	gtk_widget_show (but_13);
	gtk_fixed_put (GTK_FIXED (fixed2), but_13, 432, 32);
	gtk_widget_set_size_request (but_13, 48, 32);
	gtk_tooltips_set_tip (tooltips, but_13, _("fourth finger"), NULL);

	lab_13 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab_13, "lab_13");
	gtk_widget_show (lab_13);
	gtk_container_add (GTK_CONTAINER (but_13), lab_13);
	gtk_label_set_justify (GTK_LABEL (lab_13), GTK_JUSTIFY_CENTER);

	but_14 = gtk_button_new_with_mnemonic (_("<---"));
	gtk_widget_set_name (but_14, "but_14");
	gtk_widget_show (but_14);
	gtk_fixed_put (GTK_FIXED (fixed2), but_14, 448, 0);
	gtk_widget_set_size_request (but_14, 32, 32);
	gtk_widget_set_sensitive (but_14, FALSE);
	GTK_WIDGET_UNSET_FLAGS (but_14, GTK_CAN_FOCUS);

	but14 = gtk_button_new ();
	gtk_widget_set_name (but14, "but14");
	gtk_widget_show (but14);
	gtk_fixed_put (GTK_FIXED (fixed2), but14, 416, 0);
	gtk_widget_set_size_request (but14, 32, 32);
	gtk_tooltips_set_tip (tooltips, but14, _("fourth finger"), NULL);

	lab14 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab14, "lab14");
	gtk_widget_show (lab14);
	gtk_container_add (GTK_CONTAINER (but14), lab14);
	gtk_label_set_justify (GTK_LABEL (lab14), GTK_JUSTIFY_CENTER);

	but_tab = gtk_button_new_with_mnemonic (_("|-->|"));
	gtk_widget_set_name (but_tab, "but_tab");
	gtk_widget_show (but_tab);
	gtk_fixed_put (GTK_FIXED (fixed2), but_tab, 0, 32);
	gtk_widget_set_size_request (but_tab, 48, 32);
	gtk_widget_set_sensitive (but_tab, FALSE);
	GTK_WIDGET_UNSET_FLAGS (but_tab, GTK_CAN_FOCUS);

	but__13 = gtk_button_new_with_mnemonic (_("Caps"));
	gtk_widget_set_name (but__13, "but__13");
	gtk_widget_show (but__13);
	gtk_fixed_put (GTK_FIXED (fixed2), but__13, 0, 64);
	gtk_widget_set_size_request (but__13, 56, 32);
	gtk_widget_set_sensitive (but__13, FALSE);
	GTK_WIDGET_UNSET_FLAGS (but__13, GTK_CAN_FOCUS);

	toggle_shift1 = gtk_toggle_button_new ();
	gtk_widget_set_name (toggle_shift1, "toggle_shift1");
	gtk_widget_show (toggle_shift1);
	gtk_fixed_put (GTK_FIXED (fixed2), toggle_shift1, 0, 96);
	gtk_widget_set_size_request (toggle_shift1, 40, 32);
	gtk_tooltips_set_tip (tooltips, toggle_shift1,
			      _
			      ("Toggles the shift effect on the keys. Alternates between the upper and lower characters of the keys."),
			      NULL);

	pixmap8 = create_pixmap (window_keyboard, "shift.xpm");
	gtk_widget_set_name (pixmap8, "pixmap8");
	gtk_widget_show (pixmap8);
	gtk_container_add (GTK_CONTAINER (toggle_shift1), pixmap8);
	gtk_misc_set_alignment (GTK_MISC (pixmap8), 0.5, 7.45058e-09);

	but1 = gtk_button_new ();
	gtk_widget_set_name (but1, "but1");
	gtk_widget_show (but1);
	gtk_fixed_put (GTK_FIXED (fixed2), but1, 0, 0);
	gtk_widget_set_size_request (but1, 32, 32);
	gtk_tooltips_set_tip (tooltips, but1, _("fourth finger"), NULL);

	lab1 = gtk_label_new (_("+"));
	gtk_widget_set_name (lab1, "lab1");
	gtk_widget_show (lab1);
	gtk_container_add (GTK_CONTAINER (but1), lab1);
	gtk_label_set_justify (GTK_LABEL (lab1), GTK_JUSTIFY_CENTER);

	hbox_kb_tutor = gtk_hbox_new (FALSE, 0);
	gtk_widget_set_name (hbox_kb_tutor, "hbox_kb_tutor");
	gtk_box_pack_start (GTK_BOX (vbox19), hbox_kb_tutor, TRUE, TRUE, 0);

	label107 = gtk_label_new (_("Click on any key above\nto see here which\nfinger you must use:"));
	gtk_widget_set_name (label107, "label107");
	gtk_widget_show (label107);
	gtk_box_pack_start (GTK_BOX (hbox_kb_tutor), label107, FALSE, FALSE, 5);
	gtk_label_set_justify (GTK_LABEL (label107), GTK_JUSTIFY_RIGHT);

	pix_hands = create_pixmap (window_keyboard, "hands_0.xpm");
	gtk_widget_set_name (pix_hands, "pix_hands");
	gtk_widget_show (pix_hands);
	gtk_box_pack_start (GTK_BOX (hbox_kb_tutor), pix_hands, TRUE, TRUE, 0);
	gtk_misc_set_alignment (GTK_MISC (pix_hands), 0, 0.5);

	vbox39 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox39, "vbox39");
	gtk_widget_show (vbox39);
	gtk_box_pack_start (GTK_BOX (hbox_kb_tutor), vbox39, TRUE, TRUE, 0);

	checkbutton_hints = gtk_check_button_new_with_mnemonic (_("Keep hands"));
	gtk_widget_set_name (checkbutton_hints, "checkbutton_hints");
	gtk_widget_show (checkbutton_hints);
	gtk_box_pack_start (GTK_BOX (vbox39), checkbutton_hints, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (checkbutton_hints), 10);
	gtk_tooltips_set_tip (tooltips, checkbutton_hints,
			      _
			      ("If you like these beautiful hands beside, click here before closing this window."),
			      NULL);

	button_keyboard_close = gtk_button_new_with_mnemonic (_("Close"));
	gtk_widget_set_name (button_keyboard_close, "button_keyboard_close");
	gtk_widget_show (button_keyboard_close);
	gtk_box_pack_start (GTK_BOX (vbox39), button_keyboard_close, TRUE, TRUE, 0);
	gtk_tooltips_set_tip (tooltips, button_keyboard_close,
			      _("Close this window and return to the lesson. Hotkey: [Esc]"), NULL);

	g_signal_connect ((gpointer) window_keyboard, "destroy", G_CALLBACK (on_window_keyboard_destroy), NULL);
	g_signal_connect ((gpointer) window_keyboard, "delete_event",
			  G_CALLBACK (on_window_keyboard_delete_event), NULL);
	g_signal_connect ((gpointer) notebook_kb, "switch_page", G_CALLBACK (on_notebook_kb_switch_page), NULL);
	g_signal_connect ((gpointer) entry_kb_main, "insert_text", G_CALLBACK (on_entry_kb_main_insert_text), NULL);
	g_signal_connect ((gpointer) entry_kb_user, "insert_text", G_CALLBACK (on_entry_kb_user_insert_text), NULL);
	g_signal_connect ((gpointer) button_kb_save, "clicked", G_CALLBACK (on_button_kb_save_clicked), NULL);
	g_signal_connect ((gpointer) button_kb_remove, "clicked", G_CALLBACK (on_button_kb_remove_clicked), NULL);
	g_signal_connect ((gpointer) button_keyboard_select, "clicked",
			  G_CALLBACK (on_button_keyboard_select_clicked), NULL);
	g_signal_connect ((gpointer) button_keyboard_cancel, "clicked",
			  G_CALLBACK (on_button_keyboard_cancel_clicked), NULL);
	g_signal_connect ((gpointer) but4, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but5, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but6, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but7, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but8, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but_2, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but_3, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but__2, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but__3, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but_5, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but_6, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but_7, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but_9, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but___11, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but__9, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but__8, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but_8, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but__5, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but__6, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but__7, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but___8, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but___7, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but___6, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but___5, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but___4, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but__4, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but___3, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but___2, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but9, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but10, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but11, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but12, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but_1, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but__1, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but__10, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but13, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but___1, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but_10, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but2, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but__11, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) toggle_shift2, "toggled", G_CALLBACK (on_toggle_shift2_toggled), NULL);
	g_signal_connect ((gpointer) but_4, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but_11, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but_12, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but3, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but___9, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but___10, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but___12, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but_space, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but__12, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but_13, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) but14, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) toggle_shift1, "toggled", G_CALLBACK (on_toggle_shift1_toggled), NULL);
	g_signal_connect ((gpointer) but1, "clicked", G_CALLBACK (on_virtual_key_clicked), NULL);
	g_signal_connect ((gpointer) button_keyboard_close, "clicked",
			  G_CALLBACK (on_button_keyboard_close_clicked), NULL);

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (window_keyboard, window_keyboard, "window_keyboard");
	GLADE_HOOKUP_OBJECT (window_keyboard, hbox56, "hbox56");
	GLADE_HOOKUP_OBJECT (window_keyboard, vbox_kb_left, "vbox_kb_left");
	GLADE_HOOKUP_OBJECT (window_keyboard, vbox38, "vbox38");
	GLADE_HOOKUP_OBJECT (window_keyboard, notebook_kb, "notebook_kb");
	GLADE_HOOKUP_OBJECT (window_keyboard, vbox24, "vbox24");
	GLADE_HOOKUP_OBJECT (window_keyboard, frame22, "frame22");
	GLADE_HOOKUP_OBJECT (window_keyboard, vbox20, "vbox20");
	GLADE_HOOKUP_OBJECT (window_keyboard, frame45, "frame45");
	GLADE_HOOKUP_OBJECT (window_keyboard, combo_kb_main, "combo_kb_main");
	GLADE_HOOKUP_OBJECT (window_keyboard, entry_kb_main, "entry_kb_main");
	GLADE_HOOKUP_OBJECT (window_keyboard, label122, "label122");
	GLADE_HOOKUP_OBJECT (window_keyboard, frame23, "frame23");
	GLADE_HOOKUP_OBJECT (window_keyboard, vbox21, "vbox21");
	GLADE_HOOKUP_OBJECT (window_keyboard, frame46, "frame46");
	GLADE_HOOKUP_OBJECT (window_keyboard, combo_kb_user, "combo_kb_user");
	GLADE_HOOKUP_OBJECT (window_keyboard, entry_kb_user, "entry_kb_user");
	GLADE_HOOKUP_OBJECT (window_keyboard, label123, "label123");
	GLADE_HOOKUP_OBJECT (window_keyboard, label_kb_load, "label_kb_load");
	GLADE_HOOKUP_OBJECT (window_keyboard, vbox26, "vbox26");
	GLADE_HOOKUP_OBJECT (window_keyboard, frame34, "frame34");
	GLADE_HOOKUP_OBJECT (window_keyboard, vbox33, "vbox33");
	GLADE_HOOKUP_OBJECT (window_keyboard, combo_kb_edit, "combo_kb_edit");
	GLADE_HOOKUP_OBJECT (window_keyboard, entry_kb_edit, "entry_kb_edit");
	GLADE_HOOKUP_OBJECT (window_keyboard, hbox27, "hbox27");
	GLADE_HOOKUP_OBJECT (window_keyboard, button_kb_save, "button_kb_save");
	GLADE_HOOKUP_OBJECT (window_keyboard, button_kb_remove, "button_kb_remove");
	GLADE_HOOKUP_OBJECT (window_keyboard, label124, "label124");
	GLADE_HOOKUP_OBJECT (window_keyboard, label46, "label46");
	GLADE_HOOKUP_OBJECT (window_keyboard, vseparator3, "vseparator3");
	GLADE_HOOKUP_OBJECT (window_keyboard, frame43, "frame43");
	GLADE_HOOKUP_OBJECT (window_keyboard, vbox36, "vbox36");
	GLADE_HOOKUP_OBJECT (window_keyboard, frame42, "frame42");
	GLADE_HOOKUP_OBJECT (window_keyboard, frame51, "frame51");
	GLADE_HOOKUP_OBJECT (window_keyboard, label_kb_name, "label_kb_name");
	GLADE_HOOKUP_OBJECT (window_keyboard, hbox53, "hbox53");
	GLADE_HOOKUP_OBJECT (window_keyboard, button_keyboard_select, "button_keyboard_select");
	GLADE_HOOKUP_OBJECT (window_keyboard, button_keyboard_cancel, "button_keyboard_cancel");
	GLADE_HOOKUP_OBJECT (window_keyboard, label125, "label125");
	GLADE_HOOKUP_OBJECT (window_keyboard, vbox19, "vbox19");
	GLADE_HOOKUP_OBJECT (window_keyboard, frame52, "frame52");
	GLADE_HOOKUP_OBJECT (window_keyboard, frame50, "frame50");
	GLADE_HOOKUP_OBJECT (window_keyboard, hbox30, "hbox30");
	GLADE_HOOKUP_OBJECT (window_keyboard, label_virtual_kb, "label_virtual_kb");
	GLADE_HOOKUP_OBJECT (window_keyboard, label_modified, "label_modified");
	GLADE_HOOKUP_OBJECT (window_keyboard, label_saved_tmp, "label_saved_tmp");
	GLADE_HOOKUP_OBJECT (window_keyboard, hbox54, "hbox54");
	GLADE_HOOKUP_OBJECT (window_keyboard, vseparator4, "vseparator4");
	GLADE_HOOKUP_OBJECT (window_keyboard, vseparator5, "vseparator5");
	GLADE_HOOKUP_OBJECT (window_keyboard, frame24, "frame24");
	GLADE_HOOKUP_OBJECT (window_keyboard, frame25, "frame25");
	GLADE_HOOKUP_OBJECT (window_keyboard, fixed2, "fixed2");
	GLADE_HOOKUP_OBJECT (window_keyboard, but4, "but4");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab4, "lab4");
	GLADE_HOOKUP_OBJECT (window_keyboard, but5, "but5");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab5, "lab5");
	GLADE_HOOKUP_OBJECT (window_keyboard, but6, "but6");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab6, "lab6");
	GLADE_HOOKUP_OBJECT (window_keyboard, but7, "but7");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab7, "lab7");
	GLADE_HOOKUP_OBJECT (window_keyboard, but8, "but8");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab8, "lab8");
	GLADE_HOOKUP_OBJECT (window_keyboard, but_2, "but_2");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab_2, "lab_2");
	GLADE_HOOKUP_OBJECT (window_keyboard, but_3, "but_3");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab_3, "lab_3");
	GLADE_HOOKUP_OBJECT (window_keyboard, but__2, "but__2");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab__2, "lab__2");
	GLADE_HOOKUP_OBJECT (window_keyboard, but__3, "but__3");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab__3, "lab__3");
	GLADE_HOOKUP_OBJECT (window_keyboard, but_5, "but_5");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab_5, "lab_5");
	GLADE_HOOKUP_OBJECT (window_keyboard, but_6, "but_6");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab_6, "lab_6");
	GLADE_HOOKUP_OBJECT (window_keyboard, but_7, "but_7");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab_7, "lab_7");
	GLADE_HOOKUP_OBJECT (window_keyboard, but_9, "but_9");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab_9, "lab_9");
	GLADE_HOOKUP_OBJECT (window_keyboard, but___11, "but___11");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab___11, "lab___11");
	GLADE_HOOKUP_OBJECT (window_keyboard, but__9, "but__9");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab__9, "lab__9");
	GLADE_HOOKUP_OBJECT (window_keyboard, but__8, "but__8");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab__8, "lab__8");
	GLADE_HOOKUP_OBJECT (window_keyboard, but_8, "but_8");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab_8, "lab_8");
	GLADE_HOOKUP_OBJECT (window_keyboard, but__5, "but__5");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab__5, "lab__5");
	GLADE_HOOKUP_OBJECT (window_keyboard, but__6, "but__6");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab__6, "lab__6");
	GLADE_HOOKUP_OBJECT (window_keyboard, but__7, "but__7");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab__7, "lab__7");
	GLADE_HOOKUP_OBJECT (window_keyboard, but___8, "but___8");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab___8, "lab___8");
	GLADE_HOOKUP_OBJECT (window_keyboard, but___7, "but___7");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab___7, "lab___7");
	GLADE_HOOKUP_OBJECT (window_keyboard, but___6, "but___6");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab___6, "lab___6");
	GLADE_HOOKUP_OBJECT (window_keyboard, but___5, "but___5");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab___5, "lab___5");
	GLADE_HOOKUP_OBJECT (window_keyboard, but___4, "but___4");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab___4, "lab___4");
	GLADE_HOOKUP_OBJECT (window_keyboard, but__4, "but__4");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab__4, "lab__4");
	GLADE_HOOKUP_OBJECT (window_keyboard, but___3, "but___3");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab___3, "lab___3");
	GLADE_HOOKUP_OBJECT (window_keyboard, but___2, "but___2");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab___2, "lab___2");
	GLADE_HOOKUP_OBJECT (window_keyboard, but9, "but9");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab9, "lab9");
	GLADE_HOOKUP_OBJECT (window_keyboard, but10, "but10");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab10, "lab10");
	GLADE_HOOKUP_OBJECT (window_keyboard, but11, "but11");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab11, "lab11");
	GLADE_HOOKUP_OBJECT (window_keyboard, but12, "but12");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab12, "lab12");
	GLADE_HOOKUP_OBJECT (window_keyboard, but_1, "but_1");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab_1, "lab_1");
	GLADE_HOOKUP_OBJECT (window_keyboard, but__1, "but__1");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab__1, "lab__1");
	GLADE_HOOKUP_OBJECT (window_keyboard, but__10, "but__10");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab__10, "lab__10");
	GLADE_HOOKUP_OBJECT (window_keyboard, but13, "but13");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab13, "lab13");
	GLADE_HOOKUP_OBJECT (window_keyboard, but___1, "but___1");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab___1, "lab___1");
	GLADE_HOOKUP_OBJECT (window_keyboard, but_10, "but_10");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab_10, "lab_10");
	GLADE_HOOKUP_OBJECT (window_keyboard, but2, "but2");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab2, "lab2");
	GLADE_HOOKUP_OBJECT (window_keyboard, but__11, "but__11");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab__11, "lab__11");
	GLADE_HOOKUP_OBJECT (window_keyboard, but___13, "but___13");
	GLADE_HOOKUP_OBJECT (window_keyboard, but___14, "but___14");
	GLADE_HOOKUP_OBJECT (window_keyboard, button_kbd5, "button_kbd5");
	GLADE_HOOKUP_OBJECT (window_keyboard, button_kbd4, "button_kbd4");
	GLADE_HOOKUP_OBJECT (window_keyboard, button_kbd1, "button_kbd1");
	GLADE_HOOKUP_OBJECT (window_keyboard, button_kbd2, "button_kbd2");
	GLADE_HOOKUP_OBJECT (window_keyboard, button_kbd6, "button_kbd6");
	GLADE_HOOKUP_OBJECT (window_keyboard, toggle_shift2, "toggle_shift2");
	GLADE_HOOKUP_OBJECT (window_keyboard, pixmap9, "pixmap9");
	GLADE_HOOKUP_OBJECT (window_keyboard, but_4, "but_4");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab_4, "lab_4");
	GLADE_HOOKUP_OBJECT (window_keyboard, but_11, "but_11");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab_11, "lab_11");
	GLADE_HOOKUP_OBJECT (window_keyboard, but_12, "but_12");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab_12, "lab_12");
	GLADE_HOOKUP_OBJECT (window_keyboard, but__14, "but__14");
	GLADE_HOOKUP_OBJECT (window_keyboard, but3, "but3");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab3, "lab3");
	GLADE_HOOKUP_OBJECT (window_keyboard, but___9, "but___9");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab___9, "lab___9");
	GLADE_HOOKUP_OBJECT (window_keyboard, but___10, "but___10");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab___10, "lab___10");
	GLADE_HOOKUP_OBJECT (window_keyboard, but___12, "but___12");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab___12, "lab___12");
	GLADE_HOOKUP_OBJECT (window_keyboard, but_space, "but_space");
	GLADE_HOOKUP_OBJECT (window_keyboard, but__12, "but__12");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab__12, "lab__12");
	GLADE_HOOKUP_OBJECT (window_keyboard, but_13, "but_13");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab_13, "lab_13");
	GLADE_HOOKUP_OBJECT (window_keyboard, but_14, "but_14");
	GLADE_HOOKUP_OBJECT (window_keyboard, but14, "but14");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab14, "lab14");
	GLADE_HOOKUP_OBJECT (window_keyboard, but_tab, "but_tab");
	GLADE_HOOKUP_OBJECT (window_keyboard, but__13, "but__13");
	GLADE_HOOKUP_OBJECT (window_keyboard, toggle_shift1, "toggle_shift1");
	GLADE_HOOKUP_OBJECT (window_keyboard, pixmap8, "pixmap8");
	GLADE_HOOKUP_OBJECT (window_keyboard, but1, "but1");
	GLADE_HOOKUP_OBJECT (window_keyboard, lab1, "lab1");
	GLADE_HOOKUP_OBJECT (window_keyboard, hbox_kb_tutor, "hbox_kb_tutor");
	GLADE_HOOKUP_OBJECT (window_keyboard, label107, "label107");
	GLADE_HOOKUP_OBJECT (window_keyboard, pix_hands, "pix_hands");
	GLADE_HOOKUP_OBJECT (window_keyboard, vbox39, "vbox39");
	GLADE_HOOKUP_OBJECT (window_keyboard, checkbutton_hints, "checkbutton_hints");
	GLADE_HOOKUP_OBJECT (window_keyboard, button_keyboard_close, "button_keyboard_close");
	GLADE_HOOKUP_OBJECT_NO_REF (window_keyboard, tooltips, "tooltips");

	gtk_widget_grab_focus (entry_kb_edit);
	gtk_window_add_accel_group (GTK_WINDOW (window_keyboard), accel_group);

	return window_keyboard;
}

GtkWidget *
create_popup_keyedit (void)
{
	GtkWidget *popup_keyedit;
	GtkWidget *frame30;
	GtkWidget *frame1;
	GtkWidget *vbox2;
	GtkWidget *frame32;
	GtkWidget *label43;
	GtkWidget *frame33;
	GtkWidget *entry_popup_key;
	GtkWidget *button_popup_cancel;
	GtkTooltips *tooltips;

	tooltips = gtk_tooltips_new ();

	popup_keyedit = gtk_window_new (GTK_WINDOW_POPUP);
	gtk_widget_set_name (popup_keyedit, "popup_keyedit");
	GTK_WIDGET_SET_FLAGS (popup_keyedit, GTK_CAN_FOCUS);
	gtk_tooltips_set_tip (tooltips, popup_keyedit, _("Press the correspondent key on the real keyboard."), NULL);
	gtk_window_set_title (GTK_WINDOW (popup_keyedit), _("Klavaro"));
	gtk_window_set_modal (GTK_WINDOW (popup_keyedit), TRUE);
	gtk_window_set_resizable (GTK_WINDOW (popup_keyedit), FALSE);

	frame30 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame30, "frame30");
	gtk_widget_show (frame30);
	gtk_container_add (GTK_CONTAINER (popup_keyedit), frame30);
	gtk_frame_set_shadow_type (GTK_FRAME (frame30), GTK_SHADOW_OUT);

	frame1 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame1, "frame1");
	gtk_widget_show (frame1);
	gtk_container_add (GTK_CONTAINER (frame30), frame1);
	gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);
	gtk_frame_set_shadow_type (GTK_FRAME (frame1), GTK_SHADOW_IN);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox2, "vbox2");
	gtk_widget_show (vbox2);
	gtk_container_add (GTK_CONTAINER (frame1), vbox2);

	frame32 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame32, "frame32");
	gtk_widget_show (frame32);
	gtk_box_pack_start (GTK_BOX (vbox2), frame32, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame32), 5);

	label43 = gtk_label_new (_("Press a key"));
	gtk_widget_set_name (label43, "label43");
	gtk_widget_show (label43);
	gtk_container_add (GTK_CONTAINER (frame32), label43);
	gtk_label_set_justify (GTK_LABEL (label43), GTK_JUSTIFY_CENTER);
	gtk_misc_set_padding (GTK_MISC (label43), 3, 3);

	frame33 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame33, "frame33");
	gtk_widget_show (frame33);
	gtk_box_pack_start (GTK_BOX (vbox2), frame33, FALSE, FALSE, 0);
	gtk_widget_set_size_request (frame33, 115, -1);
	gtk_container_set_border_width (GTK_CONTAINER (frame33), 4);
	gtk_frame_set_shadow_type (GTK_FRAME (frame33), GTK_SHADOW_OUT);

	entry_popup_key = gtk_entry_new ();
	gtk_widget_set_name (entry_popup_key, "entry_popup_key");
	gtk_widget_show (entry_popup_key);
	gtk_container_add (GTK_CONTAINER (frame33), entry_popup_key);
	gtk_tooltips_set_tip (tooltips, entry_popup_key, _("Click here with the mouse and press a key."), NULL);

	button_popup_cancel = gtk_button_new_with_mnemonic (_("Cancel"));
	gtk_widget_set_name (button_popup_cancel, "button_popup_cancel");
	gtk_widget_show (button_popup_cancel);
	gtk_box_pack_start (GTK_BOX (vbox2), button_popup_cancel, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_popup_cancel), 5);
	GTK_WIDGET_UNSET_FLAGS (button_popup_cancel, GTK_CAN_FOCUS);
	gtk_tooltips_set_tip (tooltips, button_popup_cancel, _("Close without any modification. Hotkey: [Esc]"), NULL);

	g_signal_connect ((gpointer) entry_popup_key, "insert_text", G_CALLBACK (on_entry_popup_key_insert_text), NULL);
	g_signal_connect ((gpointer) button_popup_cancel, "clicked", G_CALLBACK (on_button_popup_cancel_clicked), NULL);

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (popup_keyedit, popup_keyedit, "popup_keyedit");
	GLADE_HOOKUP_OBJECT (popup_keyedit, frame30, "frame30");
	GLADE_HOOKUP_OBJECT (popup_keyedit, frame1, "frame1");
	GLADE_HOOKUP_OBJECT (popup_keyedit, vbox2, "vbox2");
	GLADE_HOOKUP_OBJECT (popup_keyedit, frame32, "frame32");
	GLADE_HOOKUP_OBJECT (popup_keyedit, label43, "label43");
	GLADE_HOOKUP_OBJECT (popup_keyedit, frame33, "frame33");
	GLADE_HOOKUP_OBJECT (popup_keyedit, entry_popup_key, "entry_popup_key");
	GLADE_HOOKUP_OBJECT (popup_keyedit, button_popup_cancel, "button_popup_cancel");
	GLADE_HOOKUP_OBJECT_NO_REF (popup_keyedit, tooltips, "tooltips");

	gtk_widget_grab_focus (entry_popup_key);
	return popup_keyedit;
}

GtkWidget *
create_popup_message_save (void)
{
	GtkWidget *popup_message_save;
	GtkWidget *vbox27;
	GtkWidget *frame37;
	GtkWidget *frame38;
	GtkWidget *vbox28;
	GtkWidget *label49;
	GtkWidget *hseparator3;
	GtkWidget *button_msg_save;

	popup_message_save = gtk_window_new (GTK_WINDOW_POPUP);
	gtk_widget_set_name (popup_message_save, "popup_message_save");
	gtk_window_set_position (GTK_WINDOW (popup_message_save), GTK_WIN_POS_MOUSE);
	gtk_window_set_modal (GTK_WINDOW (popup_message_save), TRUE);

	vbox27 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox27, "vbox27");
	gtk_widget_show (vbox27);
	gtk_container_add (GTK_CONTAINER (popup_message_save), vbox27);

	frame37 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame37, "frame37");
	gtk_widget_show (frame37);
	gtk_box_pack_start (GTK_BOX (vbox27), frame37, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type (GTK_FRAME (frame37), GTK_SHADOW_OUT);

	frame38 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame38, "frame38");
	gtk_widget_show (frame38);
	gtk_container_add (GTK_CONTAINER (frame37), frame38);
	gtk_container_set_border_width (GTK_CONTAINER (frame38), 5);
	gtk_frame_set_shadow_type (GTK_FRAME (frame38), GTK_SHADOW_IN);

	vbox28 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox28, "vbox28");
	gtk_widget_show (vbox28);
	gtk_container_add (GTK_CONTAINER (frame38), vbox28);

	label49 =
		gtk_label_new (_
			       ("Ops! You must save the\nmodified keyboard layout\nor choose another one\nbefore procced."));
	gtk_widget_set_name (label49, "label49");
	gtk_widget_show (label49);
	gtk_box_pack_start (GTK_BOX (vbox28), label49, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (label49), 5, 5);

	hseparator3 = gtk_hseparator_new ();
	gtk_widget_set_name (hseparator3, "hseparator3");
	gtk_widget_show (hseparator3);
	gtk_box_pack_start (GTK_BOX (vbox28), hseparator3, TRUE, TRUE, 0);

	button_msg_save = gtk_button_new_with_mnemonic (_("OK"));
	gtk_widget_set_name (button_msg_save, "button_msg_save");
	gtk_widget_show (button_msg_save);
	gtk_box_pack_start (GTK_BOX (vbox28), button_msg_save, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_msg_save), 10);

	g_signal_connect ((gpointer) button_msg_save, "clicked", G_CALLBACK (on_button_msg_save_clicked), NULL);

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (popup_message_save, popup_message_save, "popup_message_save");
	GLADE_HOOKUP_OBJECT (popup_message_save, vbox27, "vbox27");
	GLADE_HOOKUP_OBJECT (popup_message_save, frame37, "frame37");
	GLADE_HOOKUP_OBJECT (popup_message_save, frame38, "frame38");
	GLADE_HOOKUP_OBJECT (popup_message_save, vbox28, "vbox28");
	GLADE_HOOKUP_OBJECT (popup_message_save, label49, "label49");
	GLADE_HOOKUP_OBJECT (popup_message_save, hseparator3, "hseparator3");
	GLADE_HOOKUP_OBJECT (popup_message_save, button_msg_save, "button_msg_save");

	return popup_message_save;
}

GtkWidget *
create_window_tutor (void)
{
	GtkWidget *window_tutor;
	GtkWidget *vbox_tutor_main;
	GtkWidget *hbox_top_menu;
	GtkWidget *hbox40;
	GtkWidget *frame_lesson;
	GtkWidget *hbox44;
	GtkWidget *label_lesson;
	GtkObject *spinbutton_lesson_adj;
	GtkWidget *spinbutton_lesson;
	GtkWidget *button_revert_lesson;
	GtkWidget *button_reset_lesson;
	GtkWidget *vseparator_tutor;
	GtkWidget *hbox_tutor_menu;
	GtkWidget *button_tutor_other;
	GtkWidget *button_tutor_stat;
	GtkWidget *button_tutor_show_keyb;
	GtkWidget *button_tutor_intro;
	GtkWidget *label_space;
	GtkWidget *vseparator_tutor2;
	GtkWidget *hbox45;
	GtkWidget *button_tutor_close;
	GtkWidget *entry_beautifier;
	GtkWidget *frame_heading_text;
	GtkWidget *hbox58;
	GtkWidget *togglebutton_edit_basic_lesson;
	GtkWidget *entry_custom_basic_lesson;
	GtkWidget *label_heading;
	GtkWidget *vseparator7;
	GtkWidget *button_tutor_font;
	GtkWidget *image1;
	GtkWidget *vseparator6;
	GtkWidget *checkbutton_beep;
	GtkWidget *scrolledwindow_tutor_main;
	GtkWidget *text_tutor;
	GtkWidget *hbox_bottom_mesg;
	GtkWidget *frame59;
	GtkWidget *label_tutor_mesg;
	GtkWidget *frame60;
	GtkWidget *entry_mesg;
	GtkWidget *button_tutor_restart;
	GtkAccelGroup *accel_group;
	GtkTooltips *tooltips;

	tooltips = gtk_tooltips_new ();

	accel_group = gtk_accel_group_new ();

	window_tutor = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_name (window_tutor, "window_tutor");
	gtk_window_set_title (GTK_WINDOW (window_tutor), _("Klavaro"));
	gtk_window_set_position (GTK_WINDOW (window_tutor), GTK_WIN_POS_CENTER);

	vbox_tutor_main = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox_tutor_main, "vbox_tutor_main");
	gtk_widget_show (vbox_tutor_main);
	gtk_container_add (GTK_CONTAINER (window_tutor), vbox_tutor_main);

	hbox_top_menu = gtk_hbox_new (FALSE, 0);
	gtk_widget_set_name (hbox_top_menu, "hbox_top_menu");
	gtk_widget_show (hbox_top_menu);
	gtk_box_pack_start (GTK_BOX (vbox_tutor_main), hbox_top_menu, FALSE, FALSE, 0);

	hbox40 = gtk_hbox_new (FALSE, 0);
	gtk_widget_set_name (hbox40, "hbox40");
	gtk_widget_show (hbox40);
	gtk_box_pack_start (GTK_BOX (hbox_top_menu), hbox40, FALSE, FALSE, 0);

	frame_lesson = gtk_frame_new (NULL);
	gtk_widget_set_name (frame_lesson, "frame_lesson");
	gtk_widget_show (frame_lesson);
	gtk_box_pack_start (GTK_BOX (hbox40), frame_lesson, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type (GTK_FRAME (frame_lesson), GTK_SHADOW_NONE);

	hbox44 = gtk_hbox_new (FALSE, 0);
	gtk_widget_set_name (hbox44, "hbox44");
	gtk_widget_show (hbox44);
	gtk_container_add (GTK_CONTAINER (frame_lesson), hbox44);

	label_lesson = gtk_label_new (_("Lesson:"));
	gtk_widget_set_name (label_lesson, "label_lesson");
	gtk_widget_show (label_lesson);
	gtk_box_pack_start (GTK_BOX (hbox44), label_lesson, FALSE, FALSE, 2);
	gtk_label_set_justify (GTK_LABEL (label_lesson), GTK_JUSTIFY_CENTER);

	spinbutton_lesson_adj = gtk_adjustment_new (3, 1, 50, 1, 5, 5);
	spinbutton_lesson = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_lesson_adj), 1, 0);
	gtk_widget_set_name (spinbutton_lesson, "spinbutton_lesson");
	gtk_widget_show (spinbutton_lesson);
	gtk_box_pack_start (GTK_BOX (hbox44), spinbutton_lesson, FALSE, FALSE, 0);
	GTK_WIDGET_UNSET_FLAGS (spinbutton_lesson, GTK_CAN_FOCUS);
	gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinbutton_lesson), TRUE);
	gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (spinbutton_lesson), GTK_UPDATE_IF_VALID);
	gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinbutton_lesson), TRUE);

	button_revert_lesson = gtk_button_new_with_mnemonic (_("Revert"));
	gtk_widget_set_name (button_revert_lesson, "button_revert_lesson");
	gtk_widget_show (button_revert_lesson);
	gtk_box_pack_start (GTK_BOX (hbox44), button_revert_lesson, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_revert_lesson), 2);
	GTK_WIDGET_UNSET_FLAGS (button_revert_lesson, GTK_CAN_FOCUS);
	gtk_tooltips_set_tip (tooltips, button_revert_lesson,
			      _("Reverts to the current lesson to be accomplished."), NULL);
	gtk_button_set_relief (GTK_BUTTON (button_revert_lesson), GTK_RELIEF_NONE);

	button_reset_lesson = gtk_button_new_with_mnemonic (_("Reset!"));
	gtk_widget_set_name (button_reset_lesson, "button_reset_lesson");
	gtk_widget_show (button_reset_lesson);
	gtk_box_pack_start (GTK_BOX (hbox44), button_reset_lesson, FALSE, FALSE, 3);
	gtk_container_set_border_width (GTK_CONTAINER (button_reset_lesson), 2);
	GTK_WIDGET_UNSET_FLAGS (button_reset_lesson, GTK_CAN_FOCUS);
	gtk_tooltips_set_tip (tooltips, button_reset_lesson,
			      _
			      ("Forgets the current lesson to be accomplished, restarting the course from the introduction."),
			      NULL);
	gtk_button_set_relief (GTK_BUTTON (button_reset_lesson), GTK_RELIEF_NONE);

	vseparator_tutor = gtk_vseparator_new ();
	gtk_widget_set_name (vseparator_tutor, "vseparator_tutor");
	gtk_widget_show (vseparator_tutor);
	gtk_box_pack_start (GTK_BOX (hbox_top_menu), vseparator_tutor, FALSE, FALSE, 0);

	hbox_tutor_menu = gtk_hbox_new (TRUE, 0);
	gtk_widget_set_name (hbox_tutor_menu, "hbox_tutor_menu");
	gtk_widget_show (hbox_tutor_menu);
	gtk_box_pack_start (GTK_BOX (hbox_top_menu), hbox_tutor_menu, FALSE, FALSE, 1);

	button_tutor_other = gtk_button_new_with_mnemonic (_("Other"));
	gtk_widget_set_name (button_tutor_other, "button_tutor_other");
	gtk_widget_show (button_tutor_other);
	gtk_box_pack_start (GTK_BOX (hbox_tutor_menu), button_tutor_other, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_tutor_other), 4);
	GTK_WIDGET_UNSET_FLAGS (button_tutor_other, GTK_CAN_FOCUS);
	gtk_tooltips_set_tip (tooltips, button_tutor_other, _("Load other exercises/lessons."), NULL);
	gtk_button_set_relief (GTK_BUTTON (button_tutor_other), GTK_RELIEF_NONE);

	button_tutor_stat = gtk_button_new_with_mnemonic (_("Progress"));
	gtk_widget_set_name (button_tutor_stat, "button_tutor_stat");
	gtk_widget_show (button_tutor_stat);
	gtk_box_pack_start (GTK_BOX (hbox_tutor_menu), button_tutor_stat, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_tutor_stat), 4);
	GTK_WIDGET_UNSET_FLAGS (button_tutor_stat, GTK_CAN_FOCUS);
	gtk_tooltips_set_tip (tooltips, button_tutor_stat,
			      _("Charts showing the learning progress along the exercises."), NULL);
	gtk_button_set_relief (GTK_BUTTON (button_tutor_stat), GTK_RELIEF_NONE);

	button_tutor_show_keyb = gtk_button_new_with_mnemonic (_("Keyboard"));
	gtk_widget_set_name (button_tutor_show_keyb, "button_tutor_show_keyb");
	gtk_widget_show (button_tutor_show_keyb);
	gtk_box_pack_start (GTK_BOX (hbox_tutor_menu), button_tutor_show_keyb, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_tutor_show_keyb), 4);
	GTK_WIDGET_UNSET_FLAGS (button_tutor_show_keyb, GTK_CAN_FOCUS);
	gtk_tooltips_set_tip (tooltips, button_tutor_show_keyb,
			      _("Show the virtual keyboard and the relation between fingers and keys."), NULL);
	gtk_button_set_relief (GTK_BUTTON (button_tutor_show_keyb), GTK_RELIEF_NONE);

	button_tutor_intro = gtk_button_new_with_mnemonic (_("Introduction"));
	gtk_widget_set_name (button_tutor_intro, "button_tutor_intro");
	gtk_widget_show (button_tutor_intro);
	gtk_box_pack_start (GTK_BOX (hbox_tutor_menu), button_tutor_intro, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_tutor_intro), 4);
	GTK_WIDGET_UNSET_FLAGS (button_tutor_intro, GTK_CAN_FOCUS);
	gtk_tooltips_set_tip (tooltips, button_tutor_intro, _("Go to the exercise's introduction."), NULL);
	gtk_button_set_relief (GTK_BUTTON (button_tutor_intro), GTK_RELIEF_NONE);

	label_space = gtk_label_new ("");
	gtk_widget_set_name (label_space, "label_space");
	gtk_widget_show (label_space);
	gtk_box_pack_start (GTK_BOX (hbox_top_menu), label_space, TRUE, TRUE, 0);
	gtk_label_set_justify (GTK_LABEL (label_space), GTK_JUSTIFY_CENTER);

	vseparator_tutor2 = gtk_vseparator_new ();
	gtk_widget_set_name (vseparator_tutor2, "vseparator_tutor2");
	gtk_widget_show (vseparator_tutor2);
	gtk_box_pack_start (GTK_BOX (hbox_top_menu), vseparator_tutor2, FALSE, FALSE, 0);

	hbox45 = gtk_hbox_new (TRUE, 0);
	gtk_widget_set_name (hbox45, "hbox45");
	gtk_widget_show (hbox45);
	gtk_box_pack_start (GTK_BOX (hbox_top_menu), hbox45, FALSE, TRUE, 2);

	button_tutor_close = gtk_button_new_with_mnemonic (_("Close"));
	gtk_widget_set_name (button_tutor_close, "button_tutor_close");
	gtk_widget_show (button_tutor_close);
	gtk_box_pack_start (GTK_BOX (hbox45), button_tutor_close, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_tutor_close), 4);
	GTK_WIDGET_UNSET_FLAGS (button_tutor_close, GTK_CAN_FOCUS);
	gtk_tooltips_set_tip (tooltips, button_tutor_close, _("Return to the main menu. Hotkey: [Ctrl-Q]"), NULL);
	gtk_widget_add_accelerator (button_tutor_close, "clicked",
				    accel_group, GDK_Q, (GdkModifierType) GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	gtk_widget_add_accelerator (button_tutor_close, "clicked",
				    accel_group, GDK_q, (GdkModifierType) GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	gtk_button_set_relief (GTK_BUTTON (button_tutor_close), GTK_RELIEF_NONE);

	entry_beautifier = gtk_entry_new ();
	gtk_widget_set_name (entry_beautifier, "entry_beautifier");
	gtk_widget_show (entry_beautifier);
	gtk_box_pack_start (GTK_BOX (vbox_tutor_main), entry_beautifier, FALSE, FALSE, 0);
	gtk_widget_set_size_request (entry_beautifier, -1, 7);
	GTK_WIDGET_UNSET_FLAGS (entry_beautifier, GTK_CAN_FOCUS);
	gtk_editable_set_editable (GTK_EDITABLE (entry_beautifier), FALSE);
	gtk_entry_set_visibility (GTK_ENTRY (entry_beautifier), FALSE);

	frame_heading_text = gtk_frame_new (NULL);
	gtk_widget_set_name (frame_heading_text, "frame_heading_text");
	gtk_widget_show (frame_heading_text);
	gtk_box_pack_start (GTK_BOX (vbox_tutor_main), frame_heading_text, FALSE, FALSE, 2);
	gtk_frame_set_shadow_type (GTK_FRAME (frame_heading_text), GTK_SHADOW_IN);

	hbox58 = gtk_hbox_new (FALSE, 0);
	gtk_widget_set_name (hbox58, "hbox58");
	gtk_widget_show (hbox58);
	gtk_container_add (GTK_CONTAINER (frame_heading_text), hbox58);

	togglebutton_edit_basic_lesson = gtk_toggle_button_new_with_mnemonic (_("Edit"));
	gtk_widget_set_name (togglebutton_edit_basic_lesson, "togglebutton_edit_basic_lesson");
	gtk_box_pack_start (GTK_BOX (hbox58), togglebutton_edit_basic_lesson, FALSE, FALSE, 0);
	gtk_tooltips_set_tip (tooltips, togglebutton_edit_basic_lesson,
			      _("Edit the character set to be used in this lesson."), NULL);
	gtk_button_set_relief (GTK_BUTTON (togglebutton_edit_basic_lesson), GTK_RELIEF_HALF);

	entry_custom_basic_lesson = gtk_entry_new ();
	gtk_widget_set_name (entry_custom_basic_lesson, "entry_custom_basic_lesson");
	gtk_box_pack_start (GTK_BOX (hbox58), entry_custom_basic_lesson, TRUE, TRUE, 0);
	gtk_tooltips_set_tip (tooltips, entry_custom_basic_lesson,
			      _("Edit the character set to be used in this lesson."), NULL);
	gtk_entry_set_max_length (GTK_ENTRY (entry_custom_basic_lesson), 80);

	label_heading = gtk_label_new ("");
	gtk_widget_set_name (label_heading, "label_heading");
	gtk_widget_show (label_heading);
	gtk_box_pack_start (GTK_BOX (hbox58), label_heading, TRUE, TRUE, 0);
	gtk_misc_set_alignment (GTK_MISC (label_heading), 7.45058e-09, 0.5);
	gtk_misc_set_padding (GTK_MISC (label_heading), 5, 0);

	vseparator7 = gtk_vseparator_new ();
	gtk_widget_set_name (vseparator7, "vseparator7");
	gtk_widget_show (vseparator7);
	gtk_box_pack_start (GTK_BOX (hbox58), vseparator7, FALSE, FALSE, 0);

	button_tutor_font = gtk_button_new ();
	gtk_widget_set_name (button_tutor_font, "button_tutor_font");
	gtk_widget_show (button_tutor_font);
	gtk_box_pack_start (GTK_BOX (hbox58), button_tutor_font, FALSE, FALSE, 0);
	gtk_tooltips_set_tip (tooltips, button_tutor_font,
			      _("Select the font to be used in the exercise window."), NULL);
	gtk_button_set_relief (GTK_BUTTON (button_tutor_font), GTK_RELIEF_NONE);

	image1 = gtk_image_new_from_stock ("gtk-select-font", GTK_ICON_SIZE_SMALL_TOOLBAR);
	gtk_widget_set_name (image1, "image1");
	gtk_widget_show (image1);
	gtk_container_add (GTK_CONTAINER (button_tutor_font), image1);

	vseparator6 = gtk_vseparator_new ();
	gtk_widget_set_name (vseparator6, "vseparator6");
	gtk_widget_show (vseparator6);
	gtk_box_pack_start (GTK_BOX (hbox58), vseparator6, FALSE, FALSE, 0);

	checkbutton_beep = gtk_check_button_new_with_mnemonic (_("Sound"));
	gtk_widget_set_name (checkbutton_beep, "checkbutton_beep");
	gtk_widget_show (checkbutton_beep);
	gtk_box_pack_start (GTK_BOX (hbox58), checkbutton_beep, FALSE, FALSE, 0);
	GTK_WIDGET_UNSET_FLAGS (checkbutton_beep, GTK_CAN_FOCUS);
	gtk_tooltips_set_tip (tooltips, checkbutton_beep,
			      _("Keep this checked if you want to get those nice beeps. Hotkey: [Ctrl S]"), NULL);
	gtk_widget_add_accelerator (checkbutton_beep, "clicked", accel_group,
				    GDK_s, (GdkModifierType) GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	gtk_widget_add_accelerator (checkbutton_beep, "clicked", accel_group,
				    GDK_S, (GdkModifierType) GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	gtk_button_set_focus_on_click (GTK_BUTTON (checkbutton_beep), FALSE);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_beep), TRUE);

	scrolledwindow_tutor_main = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_set_name (scrolledwindow_tutor_main, "scrolledwindow_tutor_main");
	gtk_widget_show (scrolledwindow_tutor_main);
	gtk_box_pack_start (GTK_BOX (vbox_tutor_main), scrolledwindow_tutor_main, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow_tutor_main), 3);
	GTK_WIDGET_UNSET_FLAGS (scrolledwindow_tutor_main, GTK_CAN_FOCUS);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW
					(scrolledwindow_tutor_main), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow_tutor_main), GTK_SHADOW_IN);

	text_tutor = gtk_text_view_new ();
	gtk_widget_set_name (text_tutor, "text_tutor");
	gtk_widget_show (text_tutor);
	gtk_container_add (GTK_CONTAINER (scrolledwindow_tutor_main), text_tutor);
	gtk_widget_set_size_request (text_tutor, 630, 325);
	gtk_widget_set_sensitive (text_tutor, FALSE);
	GTK_WIDGET_UNSET_FLAGS (text_tutor, GTK_CAN_FOCUS);
	gtk_text_view_set_editable (GTK_TEXT_VIEW (text_tutor), FALSE);
	gtk_text_view_set_accepts_tab (GTK_TEXT_VIEW (text_tutor), FALSE);
	gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (text_tutor), GTK_WRAP_WORD);
	gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (text_tutor), FALSE);
	gtk_text_view_set_pixels_above_lines (GTK_TEXT_VIEW (text_tutor), 9);
	gtk_text_view_set_pixels_below_lines (GTK_TEXT_VIEW (text_tutor), 1);
	gtk_text_view_set_pixels_inside_wrap (GTK_TEXT_VIEW (text_tutor), 1);
	gtk_text_view_set_left_margin (GTK_TEXT_VIEW (text_tutor), 10);
	gtk_text_view_set_right_margin (GTK_TEXT_VIEW (text_tutor), 5);

	hbox_bottom_mesg = gtk_hbox_new (FALSE, 0);
	gtk_widget_set_name (hbox_bottom_mesg, "hbox_bottom_mesg");
	gtk_widget_show (hbox_bottom_mesg);
	gtk_box_pack_start (GTK_BOX (vbox_tutor_main), hbox_bottom_mesg, FALSE, FALSE, 0);

	frame59 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame59, "frame59");
	gtk_widget_show (frame59);
	gtk_box_pack_start (GTK_BOX (hbox_bottom_mesg), frame59, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame59), 3);
	gtk_frame_set_label_align (GTK_FRAME (frame59), 0.5, 0.5);
	gtk_frame_set_shadow_type (GTK_FRAME (frame59), GTK_SHADOW_IN);

	label_tutor_mesg = gtk_label_new (_("Klavaro"));
	gtk_widget_set_name (label_tutor_mesg, "label_tutor_mesg");
	gtk_widget_show (label_tutor_mesg);
	gtk_container_add (GTK_CONTAINER (frame59), label_tutor_mesg);
	gtk_misc_set_alignment (GTK_MISC (label_tutor_mesg), 1, 0.5);
	gtk_misc_set_padding (GTK_MISC (label_tutor_mesg), 2, 0);

	frame60 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame60, "frame60");
	gtk_widget_show (frame60);
	gtk_box_pack_start (GTK_BOX (hbox_bottom_mesg), frame60, TRUE, TRUE, 2);
	gtk_container_set_border_width (GTK_CONTAINER (frame60), 1);
	gtk_frame_set_shadow_type (GTK_FRAME (frame60), GTK_SHADOW_NONE);

	entry_mesg = gtk_entry_new ();
	gtk_widget_set_name (entry_mesg, "entry_mesg");
	gtk_widget_show (entry_mesg);
	gtk_container_add (GTK_CONTAINER (frame60), entry_mesg);
	GTK_WIDGET_SET_FLAGS (entry_mesg, GTK_CAN_DEFAULT);

	button_tutor_restart = gtk_button_new_with_mnemonic (_("Restart"));
	gtk_widget_set_name (button_tutor_restart, "button_tutor_restart");
	gtk_box_pack_start (GTK_BOX (hbox_bottom_mesg), button_tutor_restart, FALSE, FALSE, 2);
	gtk_container_set_border_width (GTK_CONTAINER (button_tutor_restart), 2);
	GTK_WIDGET_UNSET_FLAGS (button_tutor_restart, GTK_CAN_FOCUS);
	gtk_tooltips_set_tip (tooltips, button_tutor_restart,
			      _("Press here to restart the exercise. Hotkey: [Ctrl R]"), NULL);
	gtk_widget_add_accelerator (button_tutor_restart, "clicked",
				    accel_group, GDK_r, (GdkModifierType) GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	gtk_widget_add_accelerator (button_tutor_restart, "clicked",
				    accel_group, GDK_R, (GdkModifierType) GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	gtk_button_set_relief (GTK_BUTTON (button_tutor_restart), GTK_RELIEF_HALF);
	gtk_button_set_focus_on_click (GTK_BUTTON (button_tutor_restart), FALSE);

	g_signal_connect ((gpointer) window_tutor, "destroy", G_CALLBACK (on_window_tutor_destroy), NULL);
	g_signal_connect ((gpointer) spinbutton_lesson, "value_changed",
			  G_CALLBACK (on_spinbutton_lesson_value_changed), NULL);
	g_signal_connect ((gpointer) button_revert_lesson, "clicked",
			  G_CALLBACK (on_button_revert_lesson_clicked), NULL);
	g_signal_connect ((gpointer) button_reset_lesson, "clicked", G_CALLBACK (on_button_reset_lesson_clicked), NULL);
	g_signal_connect ((gpointer) button_tutor_other, "clicked", G_CALLBACK (on_button_tutor_other_clicked), NULL);
	g_signal_connect ((gpointer) button_tutor_stat, "clicked", G_CALLBACK (on_button_tutor_stat_clicked), NULL);
	g_signal_connect ((gpointer) button_tutor_show_keyb, "clicked",
			  G_CALLBACK (on_button_tutor_show_keyb_clicked), NULL);
	g_signal_connect ((gpointer) button_tutor_intro, "clicked", G_CALLBACK (on_button_tutor_intro_clicked), NULL);
	g_signal_connect ((gpointer) button_tutor_close, "clicked", G_CALLBACK (on_button_tutor_close_clicked), NULL);
	g_signal_connect ((gpointer) togglebutton_edit_basic_lesson,
			  "toggled", G_CALLBACK (on_togglebutton_edit_basic_lesson_toggled), NULL);
	g_signal_connect ((gpointer) entry_custom_basic_lesson, "activate",
			  G_CALLBACK (on_entry_custom_basic_lesson_activate), NULL);
	g_signal_connect ((gpointer) button_tutor_font, "clicked", G_CALLBACK (on_button_tutor_font_clicked), NULL);
	g_signal_connect ((gpointer) checkbutton_beep, "toggled", G_CALLBACK (on_checkbutton_beep_toggled), NULL);
	g_signal_connect ((gpointer) text_tutor, "realize", G_CALLBACK (on_text_tutor_realize), NULL);
	g_signal_connect_after ((gpointer) entry_mesg, "focus_out_event",
				G_CALLBACK (on_entry_mesg_focus_out_event), NULL);
	g_signal_connect_after ((gpointer) entry_mesg, "grab_focus", G_CALLBACK (on_entry_mesg_grab_focus), NULL);
	g_signal_connect_after ((gpointer) entry_mesg, "activate", G_CALLBACK (on_entry_mesg_activate), NULL);
	g_signal_connect_after ((gpointer) entry_mesg, "insert_text", G_CALLBACK (on_entry_mesg_insert_text), NULL);
	g_signal_connect_after ((gpointer) entry_mesg, "delete_text", G_CALLBACK (on_entry_mesg_delete_text), NULL);
	g_signal_connect ((gpointer) button_tutor_restart, "clicked",
			  G_CALLBACK (on_button_tutor_restart_clicked), NULL);

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (window_tutor, window_tutor, "window_tutor");
	GLADE_HOOKUP_OBJECT (window_tutor, vbox_tutor_main, "vbox_tutor_main");
	GLADE_HOOKUP_OBJECT (window_tutor, hbox_top_menu, "hbox_top_menu");
	GLADE_HOOKUP_OBJECT (window_tutor, hbox40, "hbox40");
	GLADE_HOOKUP_OBJECT (window_tutor, frame_lesson, "frame_lesson");
	GLADE_HOOKUP_OBJECT (window_tutor, hbox44, "hbox44");
	GLADE_HOOKUP_OBJECT (window_tutor, label_lesson, "label_lesson");
	GLADE_HOOKUP_OBJECT (window_tutor, spinbutton_lesson, "spinbutton_lesson");
	GLADE_HOOKUP_OBJECT (window_tutor, button_revert_lesson, "button_revert_lesson");
	GLADE_HOOKUP_OBJECT (window_tutor, button_reset_lesson, "button_reset_lesson");
	GLADE_HOOKUP_OBJECT (window_tutor, vseparator_tutor, "vseparator_tutor");
	GLADE_HOOKUP_OBJECT (window_tutor, hbox_tutor_menu, "hbox_tutor_menu");
	GLADE_HOOKUP_OBJECT (window_tutor, button_tutor_other, "button_tutor_other");
	GLADE_HOOKUP_OBJECT (window_tutor, button_tutor_stat, "button_tutor_stat");
	GLADE_HOOKUP_OBJECT (window_tutor, button_tutor_show_keyb, "button_tutor_show_keyb");
	GLADE_HOOKUP_OBJECT (window_tutor, button_tutor_intro, "button_tutor_intro");
	GLADE_HOOKUP_OBJECT (window_tutor, label_space, "label_space");
	GLADE_HOOKUP_OBJECT (window_tutor, vseparator_tutor2, "vseparator_tutor2");
	GLADE_HOOKUP_OBJECT (window_tutor, hbox45, "hbox45");
	GLADE_HOOKUP_OBJECT (window_tutor, button_tutor_close, "button_tutor_close");
	GLADE_HOOKUP_OBJECT (window_tutor, entry_beautifier, "entry_beautifier");
	GLADE_HOOKUP_OBJECT (window_tutor, frame_heading_text, "frame_heading_text");
	GLADE_HOOKUP_OBJECT (window_tutor, hbox58, "hbox58");
	GLADE_HOOKUP_OBJECT (window_tutor, togglebutton_edit_basic_lesson, "togglebutton_edit_basic_lesson");
	GLADE_HOOKUP_OBJECT (window_tutor, entry_custom_basic_lesson, "entry_custom_basic_lesson");
	GLADE_HOOKUP_OBJECT (window_tutor, label_heading, "label_heading");
	GLADE_HOOKUP_OBJECT (window_tutor, vseparator7, "vseparator7");
	GLADE_HOOKUP_OBJECT (window_tutor, button_tutor_font, "button_tutor_font");
	GLADE_HOOKUP_OBJECT (window_tutor, image1, "image1");
	GLADE_HOOKUP_OBJECT (window_tutor, vseparator6, "vseparator6");
	GLADE_HOOKUP_OBJECT (window_tutor, checkbutton_beep, "checkbutton_beep");
	GLADE_HOOKUP_OBJECT (window_tutor, scrolledwindow_tutor_main, "scrolledwindow_tutor_main");
	GLADE_HOOKUP_OBJECT (window_tutor, text_tutor, "text_tutor");
	GLADE_HOOKUP_OBJECT (window_tutor, hbox_bottom_mesg, "hbox_bottom_mesg");
	GLADE_HOOKUP_OBJECT (window_tutor, frame59, "frame59");
	GLADE_HOOKUP_OBJECT (window_tutor, label_tutor_mesg, "label_tutor_mesg");
	GLADE_HOOKUP_OBJECT (window_tutor, frame60, "frame60");
	GLADE_HOOKUP_OBJECT (window_tutor, entry_mesg, "entry_mesg");
	GLADE_HOOKUP_OBJECT (window_tutor, button_tutor_restart, "button_tutor_restart");
	GLADE_HOOKUP_OBJECT_NO_REF (window_tutor, tooltips, "tooltips");

	gtk_widget_grab_focus (entry_mesg);
	gtk_widget_grab_default (entry_mesg);
	gtk_window_add_accel_group (GTK_WINDOW (window_tutor), accel_group);

	return window_tutor;
}

GtkWidget *
create_popup_other (void)
{
	GtkWidget *popup_other;
	GtkWidget *frame61;
	GtkWidget *frame_other;
	GtkWidget *vbox29;
	GtkWidget *button5;
	GtkWidget *button_other_apply;
	GtkWidget *scrolledwindow1;
	GtkWidget *treeview_other;
	GtkWidget *button_other_new;
	GtkWidget *button_other_remove;
	GtkWidget *button4;
	GtkTooltips *tooltips;

	tooltips = gtk_tooltips_new ();

	popup_other = gtk_window_new (GTK_WINDOW_POPUP);
	gtk_widget_set_name (popup_other, "popup_other");
	gtk_widget_set_size_request (popup_other, 200, 300);
	gtk_window_set_title (GTK_WINDOW (popup_other), _("Klavaro"));
	gtk_window_set_position (GTK_WINDOW (popup_other), GTK_WIN_POS_MOUSE);
	gtk_window_set_modal (GTK_WINDOW (popup_other), TRUE);

	frame61 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame61, "frame61");
	gtk_widget_show (frame61);
	gtk_container_add (GTK_CONTAINER (popup_other), frame61);
	gtk_frame_set_shadow_type (GTK_FRAME (frame61), GTK_SHADOW_OUT);

	frame_other = gtk_frame_new (NULL);
	gtk_widget_set_name (frame_other, "frame_other");
	gtk_widget_show (frame_other);
	gtk_container_add (GTK_CONTAINER (frame61), frame_other);
	gtk_container_set_border_width (GTK_CONTAINER (frame_other), 5);
	GTK_WIDGET_SET_FLAGS (frame_other, GTK_CAN_FOCUS);
	gtk_frame_set_shadow_type (GTK_FRAME (frame_other), GTK_SHADOW_IN);

	vbox29 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox29, "vbox29");
	gtk_widget_show (vbox29);
	gtk_container_add (GTK_CONTAINER (frame_other), vbox29);

	button5 = gtk_button_new_with_mnemonic ("");
	gtk_widget_set_name (button5, "button5");
	gtk_widget_show (button5);
	gtk_box_pack_start (GTK_BOX (vbox29), button5, FALSE, FALSE, 0);
	gtk_widget_set_size_request (button5, -1, 15);
	gtk_button_set_relief (GTK_BUTTON (button5), GTK_RELIEF_HALF);

	button_other_apply = gtk_button_new_with_mnemonic (_("Apply selected"));
	gtk_widget_set_name (button_other_apply, "button_other_apply");
	gtk_widget_show (button_other_apply);
	gtk_box_pack_start (GTK_BOX (vbox29), button_other_apply, FALSE, FALSE, 0);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_set_name (scrolledwindow1, "scrolledwindow1");
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (vbox29), scrolledwindow1, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1),
					GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	treeview_other = gtk_tree_view_new ();
	gtk_widget_set_name (treeview_other, "treeview_other");
	gtk_widget_show (treeview_other);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), treeview_other);
	gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (treeview_other), FALSE);
	gtk_tree_view_set_enable_search (GTK_TREE_VIEW (treeview_other), FALSE);

	button_other_new = gtk_button_new_with_mnemonic (_("Read from file... (UTF-8)"));
	gtk_widget_set_name (button_other_new, "button_other_new");
	gtk_widget_show (button_other_new);
	gtk_box_pack_start (GTK_BOX (vbox29), button_other_new, FALSE, FALSE, 0);
	gtk_tooltips_set_tip (tooltips, button_other_new,
			      _
			      ("Read a text file and add a copy of it here. The file must be encoded in UTF-8."), NULL);

	button_other_remove = gtk_button_new_with_mnemonic (_("Remove selected"));
	gtk_widget_set_name (button_other_remove, "button_other_remove");
	gtk_widget_show (button_other_remove);
	gtk_box_pack_start (GTK_BOX (vbox29), button_other_remove, FALSE, FALSE, 0);
	gtk_tooltips_set_tip (tooltips, button_other_remove, _("Remove the selected item from the list above."), NULL);

	button4 = gtk_button_new_with_mnemonic ("");
	gtk_widget_set_name (button4, "button4");
	gtk_widget_show (button4);
	gtk_box_pack_start (GTK_BOX (vbox29), button4, FALSE, FALSE, 0);
	gtk_widget_set_size_request (button4, -1, 15);
	GTK_WIDGET_UNSET_FLAGS (button4, GTK_CAN_FOCUS);
	gtk_button_set_relief (GTK_BUTTON (button4), GTK_RELIEF_HALF);
	gtk_button_set_focus_on_click (GTK_BUTTON (button4), FALSE);

	g_signal_connect ((gpointer) popup_other, "enter_notify_event",
			  G_CALLBACK (on_popup_other_enter_notify_event), NULL);
	g_signal_connect ((gpointer) popup_other, "leave_notify_event",
			  G_CALLBACK (on_popup_other_leave_notify_event), NULL);
	g_signal_connect ((gpointer) button_other_apply, "clicked", G_CALLBACK (on_button_other_apply_clicked), NULL);
	g_signal_connect ((gpointer) treeview_other, "realize", G_CALLBACK (on_treeview_other_realize), NULL);
	g_signal_connect ((gpointer) treeview_other, "destroy", G_CALLBACK (on_treeview_other_destroy), NULL);
	g_signal_connect ((gpointer) button_other_new, "clicked", G_CALLBACK (on_button_other_new_clicked), NULL);
	g_signal_connect ((gpointer) button_other_remove, "clicked", G_CALLBACK (on_button_other_remove_clicked), NULL);

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (popup_other, popup_other, "popup_other");
	GLADE_HOOKUP_OBJECT (popup_other, frame61, "frame61");
	GLADE_HOOKUP_OBJECT (popup_other, frame_other, "frame_other");
	GLADE_HOOKUP_OBJECT (popup_other, vbox29, "vbox29");
	GLADE_HOOKUP_OBJECT (popup_other, button5, "button5");
	GLADE_HOOKUP_OBJECT (popup_other, button_other_apply, "button_other_apply");
	GLADE_HOOKUP_OBJECT (popup_other, scrolledwindow1, "scrolledwindow1");
	GLADE_HOOKUP_OBJECT (popup_other, treeview_other, "treeview_other");
	GLADE_HOOKUP_OBJECT (popup_other, button_other_new, "button_other_new");
	GLADE_HOOKUP_OBJECT (popup_other, button_other_remove, "button_other_remove");
	GLADE_HOOKUP_OBJECT (popup_other, button4, "button4");
	GLADE_HOOKUP_OBJECT_NO_REF (popup_other, tooltips, "tooltips");

	return popup_other;
}

GtkWidget *
create_window_stat (void)
{
	GtkWidget *window_stat;
	GtkWidget *vbox30;
	GtkWidget *hbox50;
	GtkWidget *label108;
	GtkWidget *label_stat;
	GtkWidget *label_stat_lesson;
	GtkWidget *label_stat_lesson_n;
	GtkWidget *label_stat_unit;
	GtkWidget *frame_stat;
	GtkWidget *hbox47;
	GtkWidget *toggle_stat_accur;
	GtkWidget *toggle_stat_velo;
	GtkWidget *toggle_stat_fluid;
	GtkWidget *vseparator1;
	GtkWidget *button_stat_close;
	GtkAccelGroup *accel_group;
	GtkTooltips *tooltips;

	tooltips = gtk_tooltips_new ();

	accel_group = gtk_accel_group_new ();

	window_stat = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_name (window_stat, "window_stat");
	gtk_container_set_border_width (GTK_CONTAINER (window_stat), 5);
	gtk_window_set_title (GTK_WINDOW (window_stat), _("Klavaro - Progress"));
	gtk_window_set_position (GTK_WINDOW (window_stat), GTK_WIN_POS_CENTER);
	gtk_window_set_type_hint (GTK_WINDOW (window_stat), GDK_WINDOW_TYPE_HINT_DIALOG);

	vbox30 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox30, "vbox30");
	gtk_widget_show (vbox30);
	gtk_container_add (GTK_CONTAINER (window_stat), vbox30);

	hbox50 = gtk_hbox_new (FALSE, 0);
	gtk_widget_set_name (hbox50, "hbox50");
	gtk_widget_show (hbox50);
	gtk_box_pack_start (GTK_BOX (vbox30), hbox50, FALSE, FALSE, 4);

	label108 = gtk_label_new (_("Learning evolution:"));
	gtk_widget_set_name (label108, "label108");
	gtk_widget_show (label108);
	gtk_box_pack_start (GTK_BOX (hbox50), label108, TRUE, TRUE, 0);
	gtk_label_set_justify (GTK_LABEL (label108), GTK_JUSTIFY_CENTER);
	gtk_misc_set_alignment (GTK_MISC (label108), 0.98, 0.5);

	label_stat = gtk_label_new (_("Klavaro"));
	gtk_widget_set_name (label_stat, "label_stat");
	gtk_widget_show (label_stat);
	gtk_box_pack_start (GTK_BOX (hbox50), label_stat, TRUE, TRUE, 0);
	gtk_label_set_justify (GTK_LABEL (label_stat), GTK_JUSTIFY_CENTER);
	gtk_misc_set_alignment (GTK_MISC (label_stat), 0.02, 0.5);

	label_stat_lesson = gtk_label_new (_("Lesson:"));
	gtk_widget_set_name (label_stat_lesson, "label_stat_lesson");
	gtk_box_pack_start (GTK_BOX (hbox50), label_stat_lesson, FALSE, TRUE, 0);
	gtk_label_set_justify (GTK_LABEL (label_stat_lesson), GTK_JUSTIFY_CENTER);
	gtk_misc_set_alignment (GTK_MISC (label_stat_lesson), 0.98, 0.5);
	gtk_misc_set_padding (GTK_MISC (label_stat_lesson), 5, 0);

	label_stat_lesson_n = gtk_label_new (_("Lesson:"));
	gtk_widget_set_name (label_stat_lesson_n, "label_stat_lesson_n");
	gtk_box_pack_start (GTK_BOX (hbox50), label_stat_lesson_n, FALSE, TRUE, 0);
	gtk_label_set_justify (GTK_LABEL (label_stat_lesson_n), GTK_JUSTIFY_CENTER);
	gtk_misc_set_alignment (GTK_MISC (label_stat_lesson_n), 0.02, 0.5);
	gtk_misc_set_padding (GTK_MISC (label_stat_lesson_n), 2, 0);

	label_stat_unit = gtk_label_new (_("Klavaro"));
	gtk_widget_set_name (label_stat_unit, "label_stat_unit");
	gtk_widget_show (label_stat_unit);
	gtk_box_pack_start (GTK_BOX (vbox30), label_stat_unit, FALSE, FALSE, 0);
	gtk_misc_set_alignment (GTK_MISC (label_stat_unit), 0, 0.5);

	frame_stat = gtk_frame_new (NULL);
	gtk_widget_set_name (frame_stat, "frame_stat");
	gtk_widget_show (frame_stat);
	gtk_box_pack_start (GTK_BOX (vbox30), frame_stat, TRUE, TRUE, 3);
	gtk_widget_set_size_request (frame_stat, 604, 284);
	gtk_frame_set_shadow_type (GTK_FRAME (frame_stat), GTK_SHADOW_IN);

	hbox47 = gtk_hbox_new (TRUE, 0);
	gtk_widget_set_name (hbox47, "hbox47");
	gtk_widget_show (hbox47);
	gtk_box_pack_start (GTK_BOX (vbox30), hbox47, FALSE, FALSE, 3);

	toggle_stat_accur = gtk_toggle_button_new_with_mnemonic (_("Accuracy"));
	gtk_widget_set_name (toggle_stat_accur, "toggle_stat_accur");
	gtk_widget_show (toggle_stat_accur);
	gtk_box_pack_start (GTK_BOX (hbox47), toggle_stat_accur, TRUE, TRUE, 0);
	gtk_tooltips_set_tip (tooltips, toggle_stat_accur,
			      _("Shows the accuracy for the last 30 exercises accomplished."), NULL);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle_stat_accur), TRUE);

	toggle_stat_velo = gtk_toggle_button_new_with_mnemonic (_("Velocity"));
	gtk_widget_set_name (toggle_stat_velo, "toggle_stat_velo");
	gtk_widget_show (toggle_stat_velo);
	gtk_box_pack_start (GTK_BOX (hbox47), toggle_stat_velo, TRUE, TRUE, 0);
	gtk_tooltips_set_tip (tooltips, toggle_stat_velo,
			      _("Shows the velocity for the last 30 exercises accomplished."), NULL);

	toggle_stat_fluid = gtk_toggle_button_new_with_mnemonic (_("Fluidness"));
	gtk_widget_set_name (toggle_stat_fluid, "toggle_stat_fluid");
	gtk_box_pack_start (GTK_BOX (hbox47), toggle_stat_fluid, TRUE, TRUE, 0);
	gtk_tooltips_set_tip (tooltips, toggle_stat_fluid,
			      _("Shows the fluidness for the last 30 exercises accomplished."), NULL);

	vseparator1 = gtk_vseparator_new ();
	gtk_widget_set_name (vseparator1, "vseparator1");
	gtk_widget_show (vseparator1);
	gtk_box_pack_start (GTK_BOX (hbox47), vseparator1, TRUE, TRUE, 0);

	button_stat_close = gtk_button_new_with_mnemonic (_("Close"));
	gtk_widget_set_name (button_stat_close, "button_stat_close");
	gtk_widget_show (button_stat_close);
	gtk_box_pack_start (GTK_BOX (hbox47), button_stat_close, TRUE, TRUE, 0);
	gtk_tooltips_set_tip (tooltips, button_stat_close,
			      _("Close this window, returning to the exercise. Hotkey: [Esc]"), NULL);
	gtk_widget_add_accelerator (button_stat_close, "clicked", accel_group,
				    GDK_Escape, (GdkModifierType) 0, GTK_ACCEL_VISIBLE);
	gtk_button_set_relief (GTK_BUTTON (button_stat_close), GTK_RELIEF_HALF);

	g_signal_connect ((gpointer) frame_stat, "realize", G_CALLBACK (on_frame_stat_realize), NULL);
	g_signal_connect ((gpointer) toggle_stat_accur, "toggled", G_CALLBACK (on_toggle_stat_accur_toggled), NULL);
	g_signal_connect ((gpointer) toggle_stat_velo, "toggled", G_CALLBACK (on_toggle_stat_velo_toggled), NULL);
	g_signal_connect ((gpointer) toggle_stat_fluid, "toggled", G_CALLBACK (on_toggle_stat_fluid_toggled), NULL);
	g_signal_connect ((gpointer) button_stat_close, "clicked", G_CALLBACK (on_button_stat_close_clicked), NULL);

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (window_stat, window_stat, "window_stat");
	GLADE_HOOKUP_OBJECT (window_stat, vbox30, "vbox30");
	GLADE_HOOKUP_OBJECT (window_stat, hbox50, "hbox50");
	GLADE_HOOKUP_OBJECT (window_stat, label108, "label108");
	GLADE_HOOKUP_OBJECT (window_stat, label_stat, "label_stat");
	GLADE_HOOKUP_OBJECT (window_stat, label_stat_lesson, "label_stat_lesson");
	GLADE_HOOKUP_OBJECT (window_stat, label_stat_lesson_n, "label_stat_lesson_n");
	GLADE_HOOKUP_OBJECT (window_stat, label_stat_unit, "label_stat_unit");
	GLADE_HOOKUP_OBJECT (window_stat, frame_stat, "frame_stat");
	GLADE_HOOKUP_OBJECT (window_stat, hbox47, "hbox47");
	GLADE_HOOKUP_OBJECT (window_stat, toggle_stat_accur, "toggle_stat_accur");
	GLADE_HOOKUP_OBJECT (window_stat, toggle_stat_velo, "toggle_stat_velo");
	GLADE_HOOKUP_OBJECT (window_stat, toggle_stat_fluid, "toggle_stat_fluid");
	GLADE_HOOKUP_OBJECT (window_stat, vseparator1, "vseparator1");
	GLADE_HOOKUP_OBJECT (window_stat, button_stat_close, "button_stat_close");
	GLADE_HOOKUP_OBJECT_NO_REF (window_stat, tooltips, "tooltips");

	gtk_window_add_accel_group (GTK_WINDOW (window_stat), accel_group);

	return window_stat;
}

GtkWidget *
create_window_hints (void)
{
	GtkWidget *window_hints;
	GtkWidget *frame_hints;
	GtkWidget *pixmap_hints;

	window_hints = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_name (window_hints, "window_hints");
	gtk_window_set_title (GTK_WINDOW (window_hints), _("Klavaro"));
	gtk_window_set_position (GTK_WINDOW (window_hints), GTK_WIN_POS_MOUSE);
	gtk_window_set_resizable (GTK_WINDOW (window_hints), FALSE);
	gtk_window_set_type_hint (GTK_WINDOW (window_hints), GDK_WINDOW_TYPE_HINT_DIALOG);

	frame_hints = gtk_frame_new (NULL);
	gtk_widget_set_name (frame_hints, "frame_hints");
	gtk_widget_show (frame_hints);
	gtk_container_add (GTK_CONTAINER (window_hints), frame_hints);
	gtk_container_set_border_width (GTK_CONTAINER (frame_hints), 5);
	gtk_frame_set_label_align (GTK_FRAME (frame_hints), 0.5, 0.5);
	gtk_frame_set_shadow_type (GTK_FRAME (frame_hints), GTK_SHADOW_IN);

	pixmap_hints = create_pixmap (window_hints, "hands_0.xpm");
	gtk_widget_set_name (pixmap_hints, "pixmap_hints");
	gtk_widget_show (pixmap_hints);
	gtk_container_add (GTK_CONTAINER (frame_hints), pixmap_hints);

	g_signal_connect ((gpointer) window_hints, "destroy", G_CALLBACK (on_window_hints_destroy), NULL);

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (window_hints, window_hints, "window_hints");
	GLADE_HOOKUP_OBJECT (window_hints, frame_hints, "frame_hints");
	GLADE_HOOKUP_OBJECT (window_hints, pixmap_hints, "pixmap_hints");

	return window_hints;
}

GtkWidget *
create_dialog_confirm (void)
{
	GtkWidget *dialog_confirm;
	GtkWidget *frame57;
	GtkWidget *frame58;
	GtkWidget *vbox42;
	GtkWidget *label117;
	GtkWidget *label_confirm;
	GtkWidget *hseparator7;
	GtkWidget *hbox62;
	GtkWidget *label114;
	GtkWidget *button_confirm_yes;
	GtkWidget *button_confirm_no;
	GtkWidget *label_confirm_action;

	dialog_confirm = gtk_window_new (GTK_WINDOW_POPUP);
	gtk_widget_set_name (dialog_confirm, "dialog_confirm");
	gtk_window_set_title (GTK_WINDOW (dialog_confirm), _("Change language"));
	gtk_window_set_position (GTK_WINDOW (dialog_confirm), GTK_WIN_POS_MOUSE);
	gtk_window_set_modal (GTK_WINDOW (dialog_confirm), TRUE);
	gtk_window_set_resizable (GTK_WINDOW (dialog_confirm), FALSE);

	frame57 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame57, "frame57");
	gtk_widget_show (frame57);
	gtk_container_add (GTK_CONTAINER (dialog_confirm), frame57);
	gtk_frame_set_label_align (GTK_FRAME (frame57), 0.5, 0.5);
	gtk_frame_set_shadow_type (GTK_FRAME (frame57), GTK_SHADOW_OUT);

	frame58 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame58, "frame58");
	gtk_widget_show (frame58);
	gtk_container_add (GTK_CONTAINER (frame57), frame58);
	gtk_container_set_border_width (GTK_CONTAINER (frame58), 5);
	gtk_frame_set_label_align (GTK_FRAME (frame58), 0.5, 0.5);
	gtk_frame_set_shadow_type (GTK_FRAME (frame58), GTK_SHADOW_IN);

	vbox42 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox42, "vbox42");
	gtk_widget_show (vbox42);
	gtk_container_add (GTK_CONTAINER (frame58), vbox42);

	label117 = gtk_label_new (_("Attention!"));
	gtk_widget_set_name (label117, "label117");
	gtk_widget_show (label117);
	gtk_box_pack_start (GTK_BOX (vbox42), label117, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label117), GTK_JUSTIFY_CENTER);
	gtk_misc_set_alignment (GTK_MISC (label117), 0, 0);
	gtk_misc_set_padding (GTK_MISC (label117), 10, 10);

	label_confirm =
		gtk_label_new (_
			       ("This will CHANGE also this interface.\nIf you are selecting a language you do not understand, \nmaybe it will be difficult to get back to the previous one."));
	gtk_widget_set_name (label_confirm, "label_confirm");
	gtk_widget_show (label_confirm);
	gtk_box_pack_start (GTK_BOX (vbox42), label_confirm, FALSE, FALSE, 0);
	gtk_misc_set_alignment (GTK_MISC (label_confirm), 0, 1);
	gtk_misc_set_padding (GTK_MISC (label_confirm), 10, 10);

	hseparator7 = gtk_hseparator_new ();
	gtk_widget_set_name (hseparator7, "hseparator7");
	gtk_widget_show (hseparator7);
	gtk_box_pack_start (GTK_BOX (vbox42), hseparator7, TRUE, TRUE, 0);

	hbox62 = gtk_hbox_new (TRUE, 0);
	gtk_widget_set_name (hbox62, "hbox62");
	gtk_widget_show (hbox62);
	gtk_box_pack_start (GTK_BOX (vbox42), hbox62, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (hbox62), 5);

	label114 = gtk_label_new (_("Do you confirm?"));
	gtk_widget_set_name (label114, "label114");
	gtk_widget_show (label114);
	gtk_box_pack_start (GTK_BOX (hbox62), label114, TRUE, TRUE, 0);
	gtk_label_set_justify (GTK_LABEL (label114), GTK_JUSTIFY_CENTER);
	gtk_misc_set_padding (GTK_MISC (label114), 5, 0);

	button_confirm_yes = gtk_button_new_with_mnemonic (_("Yes"));
	gtk_widget_set_name (button_confirm_yes, "button_confirm_yes");
	gtk_widget_show (button_confirm_yes);
	gtk_box_pack_start (GTK_BOX (hbox62), button_confirm_yes, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_confirm_yes), 5);

	button_confirm_no = gtk_button_new_with_mnemonic (_("No"));
	gtk_widget_set_name (button_confirm_no, "button_confirm_no");
	gtk_widget_show (button_confirm_no);
	gtk_box_pack_start (GTK_BOX (hbox62), button_confirm_no, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (button_confirm_no), 5);

	label_confirm_action = gtk_label_new (_("Do you confirm?"));
	gtk_widget_set_name (label_confirm_action, "label_confirm_action");
	gtk_box_pack_start (GTK_BOX (hbox62), label_confirm_action, TRUE, TRUE, 0);
	gtk_label_set_justify (GTK_LABEL (label_confirm_action), GTK_JUSTIFY_CENTER);
	gtk_misc_set_padding (GTK_MISC (label_confirm_action), 5, 0);

	g_signal_connect ((gpointer) dialog_confirm, "realize", G_CALLBACK (on_dialog_confirm_realize), NULL);
	g_signal_connect ((gpointer) button_confirm_yes, "clicked", G_CALLBACK (on_button_confirm_yes_clicked), NULL);
	g_signal_connect ((gpointer) button_confirm_no, "clicked", G_CALLBACK (on_button_confirm_no_clicked), NULL);

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (dialog_confirm, dialog_confirm, "dialog_confirm");
	GLADE_HOOKUP_OBJECT (dialog_confirm, frame57, "frame57");
	GLADE_HOOKUP_OBJECT (dialog_confirm, frame58, "frame58");
	GLADE_HOOKUP_OBJECT (dialog_confirm, vbox42, "vbox42");
	GLADE_HOOKUP_OBJECT (dialog_confirm, label117, "label117");
	GLADE_HOOKUP_OBJECT (dialog_confirm, label_confirm, "label_confirm");
	GLADE_HOOKUP_OBJECT (dialog_confirm, hseparator7, "hseparator7");
	GLADE_HOOKUP_OBJECT (dialog_confirm, hbox62, "hbox62");
	GLADE_HOOKUP_OBJECT (dialog_confirm, label114, "label114");
	GLADE_HOOKUP_OBJECT (dialog_confirm, button_confirm_yes, "button_confirm_yes");
	GLADE_HOOKUP_OBJECT (dialog_confirm, button_confirm_no, "button_confirm_no");
	GLADE_HOOKUP_OBJECT (dialog_confirm, label_confirm_action, "label_confirm_action");

	return dialog_confirm;
}

GtkWidget *
create_filechooser_tutor (void)
{
	GtkWidget *filechooser_tutor;
	GtkWidget *dialog_vbox2;
	GtkWidget *dialog_action_area2;
	GtkWidget *button6;
	GtkWidget *button7;

	filechooser_tutor =
		gtk_file_chooser_dialog_new (_("Klavaro - Select file"), NULL,
					     GTK_FILE_CHOOSER_ACTION_OPEN, NULL, NULL);
	gtk_widget_set_name (filechooser_tutor, "filechooser_tutor");
	gtk_window_set_type_hint (GTK_WINDOW (filechooser_tutor), GDK_WINDOW_TYPE_HINT_DIALOG);

	dialog_vbox2 = GTK_DIALOG (filechooser_tutor)->vbox;
	gtk_widget_set_name (dialog_vbox2, "dialog_vbox2");
	gtk_widget_show (dialog_vbox2);

	dialog_action_area2 = GTK_DIALOG (filechooser_tutor)->action_area;
	gtk_widget_set_name (dialog_action_area2, "dialog_action_area2");
	gtk_widget_show (dialog_action_area2);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area2), GTK_BUTTONBOX_END);

	button6 = gtk_button_new_from_stock ("gtk-cancel");
	gtk_widget_set_name (button6, "button6");
	gtk_widget_show (button6);
	gtk_dialog_add_action_widget (GTK_DIALOG (filechooser_tutor), button6, GTK_RESPONSE_CANCEL);
	GTK_WIDGET_SET_FLAGS (button6, GTK_CAN_DEFAULT);

	button7 = gtk_button_new_from_stock ("gtk-open");
	gtk_widget_set_name (button7, "button7");
	gtk_widget_show (button7);
	gtk_dialog_add_action_widget (GTK_DIALOG (filechooser_tutor), button7, GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS (button7, GTK_CAN_DEFAULT);

	g_signal_connect ((gpointer) filechooser_tutor, "response", G_CALLBACK (on_filechooser_tutor_response), NULL);
	g_signal_connect ((gpointer) filechooser_tutor, "destroy", G_CALLBACK (on_filechooser_tutor_destroy), NULL);

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (filechooser_tutor, filechooser_tutor, "filechooser_tutor");
	GLADE_HOOKUP_OBJECT_NO_REF (filechooser_tutor, dialog_vbox2, "dialog_vbox2");
	GLADE_HOOKUP_OBJECT_NO_REF (filechooser_tutor, dialog_action_area2, "dialog_action_area2");
	GLADE_HOOKUP_OBJECT (filechooser_tutor, button6, "button6");
	GLADE_HOOKUP_OBJECT (filechooser_tutor, button7, "button7");

	gtk_widget_grab_default (button7);
	return filechooser_tutor;
}

GtkWidget *
create_dialog_info (void)
{
	GtkWidget *dialog_info;
	GtkWidget *dialog_vbox3;
	GtkWidget *vbox3;
	GtkWidget *hbox3;
	GtkWidget *frame7;
	GtkWidget *label_info;
	GtkWidget *hbox46;
	GtkWidget *scrolledwindow_info;
	GtkWidget *text_info;
	GtkWidget *dialog_action_area3;
	GtkWidget *button_;
	GtkTooltips *tooltips;

	tooltips = gtk_tooltips_new ();

	dialog_info = gtk_dialog_new ();
	gtk_widget_set_name (dialog_info, "dialog_info");
	gtk_window_set_title (GTK_WINDOW (dialog_info), _("Klavaro"));
	gtk_window_set_resizable (GTK_WINDOW (dialog_info), FALSE);
	gtk_window_set_type_hint (GTK_WINDOW (dialog_info), GDK_WINDOW_TYPE_HINT_DIALOG);

	dialog_vbox3 = GTK_DIALOG (dialog_info)->vbox;
	gtk_widget_set_name (dialog_vbox3, "dialog_vbox3");
	gtk_widget_show (dialog_vbox3);

	vbox3 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox3, "vbox3");
	gtk_widget_show (vbox3);
	gtk_box_pack_start (GTK_BOX (dialog_vbox3), vbox3, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (vbox3), 10);

	hbox3 = gtk_hbox_new (FALSE, 0);
	gtk_widget_set_name (hbox3, "hbox3");
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox3), hbox3, FALSE, FALSE, 5);

	frame7 = gtk_frame_new (NULL);
	gtk_widget_set_name (frame7, "frame7");
	gtk_widget_show (frame7);
	gtk_box_pack_start (GTK_BOX (hbox3), frame7, TRUE, FALSE, 0);

	label_info = gtk_label_new (_("Introduction"));
	gtk_widget_set_name (label_info, "label_info");
	gtk_widget_show (label_info);
	gtk_container_add (GTK_CONTAINER (frame7), label_info);
	gtk_label_set_justify (GTK_LABEL (label_info), GTK_JUSTIFY_CENTER);
	gtk_misc_set_padding (GTK_MISC (label_info), 5, 5);

	hbox46 = gtk_hbox_new (FALSE, 0);
	gtk_widget_set_name (hbox46, "hbox46");
	gtk_widget_show (hbox46);
	gtk_box_pack_start (GTK_BOX (vbox3), hbox46, TRUE, TRUE, 5);

	scrolledwindow_info = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_set_name (scrolledwindow_info, "scrolledwindow_info");
	gtk_widget_show (scrolledwindow_info);
	gtk_box_pack_start (GTK_BOX (hbox46), scrolledwindow_info, TRUE, TRUE, 0);
	GTK_WIDGET_UNSET_FLAGS (scrolledwindow_info, GTK_CAN_FOCUS);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW
					(scrolledwindow_info), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow_info), GTK_SHADOW_IN);

	text_info = gtk_text_view_new ();
	gtk_widget_set_name (text_info, "text_info");
	gtk_widget_show (text_info);
	gtk_container_add (GTK_CONTAINER (scrolledwindow_info), text_info);
	gtk_widget_set_size_request (text_info, 400, 300);
	GTK_WIDGET_UNSET_FLAGS (text_info, GTK_CAN_FOCUS);
	gtk_text_view_set_editable (GTK_TEXT_VIEW (text_info), FALSE);
	gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (text_info), GTK_WRAP_WORD);
	gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (text_info), FALSE);
	gtk_text_view_set_pixels_above_lines (GTK_TEXT_VIEW (text_info), 9);
	gtk_text_view_set_pixels_below_lines (GTK_TEXT_VIEW (text_info), 1);
	gtk_text_view_set_left_margin (GTK_TEXT_VIEW (text_info), 10);
	gtk_text_view_set_right_margin (GTK_TEXT_VIEW (text_info), 5);

	dialog_action_area3 = GTK_DIALOG (dialog_info)->action_area;
	gtk_widget_set_name (dialog_action_area3, "dialog_action_area3");
	gtk_widget_show (dialog_action_area3);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area3), GTK_BUTTONBOX_SPREAD);

	button_ = gtk_button_new_with_mnemonic (_("Return"));
	gtk_widget_set_name (button_, "button_");
	gtk_widget_show (button_);
	gtk_dialog_add_action_widget (GTK_DIALOG (dialog_info), button_, GTK_RESPONSE_CLOSE);
	gtk_tooltips_set_tip (tooltips, button_,
			      _("This is a tip. Now you press this button to return to the main menu."), NULL);

	g_signal_connect ((gpointer) dialog_info, "response", G_CALLBACK (on_dialog_info_response), NULL);
	g_signal_connect ((gpointer) dialog_info, "destroy", G_CALLBACK (on_dialog_info_destroy), NULL);
	g_signal_connect ((gpointer) text_info, "realize", G_CALLBACK (on_text_info_realize), NULL);

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (dialog_info, dialog_info, "dialog_info");
	GLADE_HOOKUP_OBJECT_NO_REF (dialog_info, dialog_vbox3, "dialog_vbox3");
	GLADE_HOOKUP_OBJECT (dialog_info, vbox3, "vbox3");
	GLADE_HOOKUP_OBJECT (dialog_info, hbox3, "hbox3");
	GLADE_HOOKUP_OBJECT (dialog_info, frame7, "frame7");
	GLADE_HOOKUP_OBJECT (dialog_info, label_info, "label_info");
	GLADE_HOOKUP_OBJECT (dialog_info, hbox46, "hbox46");
	GLADE_HOOKUP_OBJECT (dialog_info, scrolledwindow_info, "scrolledwindow_info");
	GLADE_HOOKUP_OBJECT (dialog_info, text_info, "text_info");
	GLADE_HOOKUP_OBJECT_NO_REF (dialog_info, dialog_action_area3, "dialog_action_area3");
	GLADE_HOOKUP_OBJECT (dialog_info, button_, "button_");
	GLADE_HOOKUP_OBJECT_NO_REF (dialog_info, tooltips, "tooltips");

	gtk_widget_grab_focus (button_);
	return dialog_info;
}

GtkWidget *
create_fontselectiondialog_tutor (void)
{
	GtkWidget *fontselectiondialog_tutor;
	GtkWidget *ok_button1;
	GtkWidget *cancel_button1;
	GtkWidget *apply_button1;
	GtkWidget *font_selection1;

	fontselectiondialog_tutor = gtk_font_selection_dialog_new (_("Font definition"));
	gtk_widget_set_name (fontselectiondialog_tutor, "fontselectiondialog_tutor");
	gtk_container_set_border_width (GTK_CONTAINER (fontselectiondialog_tutor), 4);
	gtk_window_set_type_hint (GTK_WINDOW (fontselectiondialog_tutor), GDK_WINDOW_TYPE_HINT_DIALOG);

	ok_button1 = GTK_FONT_SELECTION_DIALOG (fontselectiondialog_tutor)->ok_button;
	gtk_widget_set_name (ok_button1, "ok_button1");
	gtk_widget_show (ok_button1);
	GTK_WIDGET_SET_FLAGS (ok_button1, GTK_CAN_DEFAULT);

	cancel_button1 = GTK_FONT_SELECTION_DIALOG (fontselectiondialog_tutor)->cancel_button;
	gtk_widget_set_name (cancel_button1, "cancel_button1");
	gtk_widget_show (cancel_button1);
	GTK_WIDGET_SET_FLAGS (cancel_button1, GTK_CAN_DEFAULT);

	apply_button1 = GTK_FONT_SELECTION_DIALOG (fontselectiondialog_tutor)->apply_button;
	gtk_widget_set_name (apply_button1, "apply_button1");
	gtk_widget_show (apply_button1);
	GTK_WIDGET_SET_FLAGS (apply_button1, GTK_CAN_DEFAULT);

	font_selection1 = GTK_FONT_SELECTION_DIALOG (fontselectiondialog_tutor)->fontsel;
	gtk_widget_set_name (font_selection1, "font_selection1");
	gtk_widget_show (font_selection1);
	gtk_container_set_border_width (GTK_CONTAINER (font_selection1), 4);

	g_signal_connect ((gpointer) fontselectiondialog_tutor, "response",
			  G_CALLBACK (on_fontselectiondialog_tutor_response), NULL);
	g_signal_connect ((gpointer) fontselectiondialog_tutor, "destroy",
			  G_CALLBACK (on_fontselectiondialog_tutor_destroy), NULL);

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (fontselectiondialog_tutor, fontselectiondialog_tutor, "fontselectiondialog_tutor");
	GLADE_HOOKUP_OBJECT_NO_REF (fontselectiondialog_tutor, ok_button1, "ok_button1");
	GLADE_HOOKUP_OBJECT_NO_REF (fontselectiondialog_tutor, cancel_button1, "cancel_button1");
	GLADE_HOOKUP_OBJECT_NO_REF (fontselectiondialog_tutor, apply_button1, "apply_button1");
	GLADE_HOOKUP_OBJECT_NO_REF (fontselectiondialog_tutor, font_selection1, "font_selection1");

	return fontselectiondialog_tutor;
}
