/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ADDFORM_H
#define ADDFORM_H

#include "addformdlg.h"
#include <qstringlist.h>
#include <klineedit.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <kfiledialog.h>
#include <kdirselectdialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <qtoolbutton.h>
#include "globals.h"
#include "newsgroup.h"


class Group;

class AddForm : public addFormDlg
{
  Q_OBJECT
	
  QStringList entries;
  QStringList cats;
  Servers *servers;
  NewsGroup *ng;
  Group *g;
  bool checkAndCreateDir( QString dirName );
  bool mkDeepDir( QString dirName );
public:
  AddForm(QString ngName, QString saveDir, QStringList _cats, Group *_g, QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  AddForm(NewsGroup *_ng, Servers *_servers, QStringList _cats, QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0);
  
  
  ~AddForm();
  /*$PUBLIC_FUNCTIONS$*/

public slots:
  /*$PUBLIC_SLOTS$*/

protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
  virtual void          reject();
  virtual void          accept();
  void slotNewCat(QString);
private slots:
	void selectDir();
	void checkSelected();
	void slotSelectionChanged();
	void slotEnableClicked();
	void slotResetClicked();
	void slotAddClicked();
	void slotToggleDay(bool);
signals:
	void newGroup(QStringList, Group*);
	void resetServerInGroup(NewsGroup *, int);
	void saveGroup(NewsGroup*);
	void addCat(QString);
};

#endif

