/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "nzbform.h"
#include "binheader.h"
#include <klistview.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <qcheckbox.h>
#include <qtoolbutton.h>
#include <klineedit.h>
#include <kmessagebox.h>
#include <kdirselectdialog.h>
#include <globals.h>
#include <klocale.h>
#include <qlabel.h>

NzbForm::NzbForm(QMap<int, BinHeader*> *hMap, QString dDir,  QWidget* parent, const char* name, bool modal, WFlags fl)
	: NzbFormDlg(parent,name, modal,fl), headerMap(hMap), destDir(dDir)
{
	buttonOk->setIconSet(KGlobal::iconLoader()->loadIcon("button_ok", KIcon::Small, 0, false));
	buttonCancel->setIconSet(KGlobal::iconLoader()->loadIcon("button_cancel", KIcon::Small, 0, false));
	dirBtn->setIconSet(KGlobal::iconLoader()->loadIcon("fileopen", KIcon::Small, 0, false));
	dirEdit->setText(destDir);
	QString label=QString("<b>Nzb file: ") + QString(name) + QString("</b>");
	fileLabel->setText(label);
	markSelBtn->setEnabled(false);
	unmarkSelBtn->setEnabled(false);
	
	connect(artList, SIGNAL(selectionChanged()), this, SLOT(slotSelectionChanged()));
	
	
	connect(markAllBtn, SIGNAL(clicked()), this, SLOT(slotMarkAll()));
	connect(unmarkAllBtn, SIGNAL(clicked()), this, SLOT(slotUnmarkAll()));
	connect(markSelBtn, SIGNAL(clicked()), this, SLOT(slotMarkSelected()));
	connect(unmarkSelBtn, SIGNAL(clicked()), this, SLOT(slotUnmarkSelected()));
	connect(dirBtn, SIGNAL(clicked()), this, SLOT(slotSelectDir()));
	
	
	artList->setSorting(-1);
	artList->setAllColumnsShowFocus(true);
	artList->setSelectionMode(QListView::Extended);
	artList->setItemMargin(3);
	
	QMap<int, BinHeader*>::iterator it;
	QCheckListItem* item;
	BinHeader* bh;
	it = headerMap->end();
	while ( it != headerMap->begin()) {
		--it;
		bh=it.data();
		item = new QCheckListItem(artList, QString::number(it.key()), QCheckListItem::CheckBox);
		item->setText(1, bh->getSubj());
		item->setText(2, QString::number(bh->getSize()));
		item->setOn(true);
	}
	
	
	
}

NzbForm::~NzbForm()
{
}

/*$SPECIALIZATION$*/
void NzbForm::reject()
{
	QMap<int, BinHeader*>::iterator it;
	for (it = headerMap->begin(); it != headerMap->end(); ++it) {
		delete it.data();
	}
  QDialog::reject();
}

void NzbForm::accept()
{
	if (dirEdit->text().stripWhiteSpace().isEmpty()) {
		KMessageBox::error(this, i18n("The directory name can not be empty"), i18n("Error"));
	} else if (!checkAndCreateDir(dirEdit->text().stripWhiteSpace()) ) {
		KMessageBox::error(this, i18n("Cannot create %1 or directory not writable").arg(dirEdit->text())  , i18n("Error"));
	} else {
		bool first = firstCheck->isChecked();
		QCheckListItem *item;
		if (first)
			item=(QCheckListItem*) artList->lastItem();
		else item = (QCheckListItem *) artList->firstChild();
		
		BinHeader *bh=0;
		//Check the dir...
		QString dir =  dirEdit->text().stripWhiteSpace() + '/';
		
		while (item) {
			if (item->isOn()) {
				//Download the item...
				bh= (*headerMap)[item->text(0).toInt()];
				emit sigDownloadNzbPost(bh, first, dir);
			} else {
				//delete the corresponding binHeader?
				delete (*headerMap)[item->text(0).toInt()];
				
				
			}
			if (first)
				item = (QCheckListItem*) item->itemAbove();
			else item = (QCheckListItem*) item->nextSibling();
		}
		QDialog::accept();
	}
}

void NzbForm::slotMarkAll() {
	
	QCheckListItem * item = (QCheckListItem *) artList->firstChild();
	
	while (item) {
		item->setOn(true);
		item = (QCheckListItem*) item->nextSibling();
	}
	
	

	
}


void NzbForm::slotUnmarkAll() {
	
	QCheckListItem * item = (QCheckListItem *) artList->firstChild();
	
	while (item) {
		item->setOn(false);
		item = (QCheckListItem*)item->nextSibling();
	}
}

void NzbForm::slotMarkSelected() {
	QPtrList<QListViewItem> selection = artList->selectedItems();
	QPtrListIterator<QListViewItem> it(selection);
	QCheckListItem* selected;
	while ( (selected = (QCheckListItem*) it.current() )) {
		selected->setOn(true);
		++it;
	}
}

void NzbForm::slotUnmarkSelected() {
	
	QPtrList<QListViewItem> selection = artList->selectedItems();
	QPtrListIterator<QListViewItem> it(selection);
	QCheckListItem* selected;
	while ( (selected = (QCheckListItem*) it.current() )) {
		selected->setOn(false);
		++it;
	}
}

void NzbForm::slotSelectDir( )
{
	KURL uri = KDirSelectDialog::selectDirectory(dirEdit->text()  , true, this, "Please select a directory");
	if (!uri.isEmpty())
		dirEdit->setText(uri.path());
}

void NzbForm::slotSelectionChanged( )
{
	QPtrList<QListViewItem> selection = artList->selectedItems();
	if (selection.isEmpty()) {
		markSelBtn->setEnabled(false);
		unmarkSelBtn->setEnabled(false);
	} else {
		markSelBtn->setEnabled(true);
		unmarkSelBtn->setEnabled(true);
	}
}


#include "nzbform.moc"

