/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "prefheader.h"
#include "globals.h"
#include <qcheckbox.h>
#include <qradiobutton.h>

PrefHeader::PrefHeader(QWidget* parent, const char* name, WFlags fl)
: PrefHeaderLayout(parent,name,fl)
{
// 	showFrom=Config().showFrom;
	fromCheck->setChecked(Config().showFrom);
	
// 	showDetails=Config().showDetails;
	detailsCheck->setChecked(Config().showDetails);
	
	
// 	showDate = Config().showDate;
	dateCheck->setChecked(Config().showDate);
	
// 	allowExpansion=Config().allowExpansion;
	expandCheck->setChecked(Config().allowExpansion);
	
// 	alwaysdb=Config().alwaysDoubleClick;
	viewCheck->setChecked(Config().alwaysDoubleClick);
	
// 	rememberSort = Config().rememberSort;
	sortCheck->setChecked(Config().rememberSort);
	
// 	rememberOrder = Config().rememberOrder;
	orderCheck->setChecked(Config().rememberOrder);
		
	sizeCheck->setChecked(Config().rememberWidth);
	
// 	remember=Config().keepListSettings;
	memCheck->setChecked(Config().keepListSettings);
	
// 	headerOpt=Config().markOpt;
	if (Config().markOpt == Configuration::Ask)
		askBtn->setChecked(true);
	else if (Config().markOpt == Configuration::No)
		nullBtn->setChecked(true);
	else markBtn->setChecked(true);
	
	
}

PrefHeader::~PrefHeader()
{
}

/*$SPECIALIZATION$*/


#include "prefheader.moc"

