# KMess spec file to build RPM packages
# Based on work from Pascal Bleser <guru@unixtech.be>,
# Simon Eisenmann <http://www.longsleep.org/projects/plone>,
# and the smb4k project
#
# RPM spec options are well explained at
# http://fedora.redhat.com/participate/developers-guide/ch-rpm-building.html
# and /usr/lib/rpm/macros


# package settings
%define kmess_version     1.5
%define kmess_tar_version 1.5
%define rpm_release 1
%define with_debug  0
%define doc_files   AUTHORS COPYING FEATURES INSTALL NEWS README TODO


# detect distro
%define is_fedora    %(test -e /etc/fedora-release    && echo 1 || echo 0)
%define is_mandrake  %(test -e /etc/mandrake-release  && echo 1 || echo 0)
%define is_redhat    %(test -e /etc/redhat-release    && echo 1 || echo 0)
%define is_suse      %(test -e /etc/SuSE-release      && echo 1 || echo 0)
%define is_slackware %(test -e /etc/slackware-version && echo 1 || echo 0)
%define is_debian    %(test -e /etc/debian_version    && echo 1 || echo 0)
# slackware is not an rpm distro, but "rpm2tgz" should do the trick
# debian does not use RPM, but rpmbuild can be abused too


# Many redhat based distro's still have /etc/redhat-release arround:
%if %is_redhat
%define is_redhat   %(grep -q "Red Hat" /etc/redhat-release && echo 1 || echo 0)
%endif


# detect kde version
# The cut for '-' is used to fix versions like "3.1-10" done by Red Hat
%define kde_config         %(test -e /opt/kde3/bin/kde-config && echo "/opt/kde3/bin/kde-config" || echo "kde-config")
%define kde_version        %(%{kde_config} --version | grep '^KDE:' | cut -f2 -d" " | cut -f1 -d"-" )
%define kde_major_version  %(echo "%{kde_version}" | cut -f1-2 -d.)
%define kde_vernum         %(echo "%{kde_major_version}" | tr -d '.')


# detect autopackage compiler (to support "build on newer, run on older" development)
# see http://autopackage.org/aptools.html for details
%define has_apgcc      %(test -e /usr/bin/apg++ && echo 1 || echo 0)


# misc defaults
%define distro         Unknown
%define release_suffix %{rpm_release}
%define is_rpm_distro  1
%if %with_debug
%define release_suffix %{rpm_release}-debug
%endif


# distro specific stuff
%if %is_fedora
%define fedora_version      %(rpm -q --queryformat '%{VERSION}' fedora-release)
%define fedora_vernum       %(echo "%fedora_version" | tr -d '.')
%define release_suffix      %{rpm_release}.FedoraCore%{fedora_vernum}.kde%{kde_vernum}
%define distro              Fedora Core %{fedora_version}
%endif

%if %is_mandrake
%define mandrake_version    %(cat /etc/mandrake-release | cut -f4 -d" ")
%define mandrake_vernum     %(echo "%mandrake_version" | tr -d '.')
%define release_suffix      %{rpm_release}.MandrakeLinux%{mandrake_num}.kde%{kde_vernum}
%define distro              Mandrake Linux %{mandrake_version}
%endif

%if %is_redhat
%define redhat_version      %(rpm -q --queryformat '%{VERSION}' redhat-release)
%define redhat_vernum       %(echo "%redhat_version" | tr -d '.')
%define release_suffix      %{rpm_release}.RedhatLinux%{redhat_vernum}.kde%{kde_vernum}
%define distro              Red Hat Linux %{redhat_version}
%endif

%if %is_suse
%define suse_version        %(grep VERSION /etc/SuSE-release | cut -f3 -d" ")
%define suse_vernum         %(echo "%suse_version" | tr -d '.')
%define release_suffix      %{rpm_release}.SuSELinux%{suse_vernum}.kde%{kde_vernum}
%define distro              SuSE Linux %{suse_version}
%endif

%if %is_slackware
%define slackware_version   %(cat /etc/slackware-version | cut -f2 -d" " | cut -f1-2 -d".")
%define slackware_vernum    %(echo "%slackware_version" | tr -d '.')
%define release_suffix      %{rpm_release}SlackwareLinux%{slackware_vernum}kde%{kde_vernum}
%define distro              Slackware Linux %{slackware_version}
%define is_rpm_distro 0
%endif

%if %is_debian
%define debian_version      %(cat /etc/debian_version)
%define debian_vernum       %(echo "%debian_version" | tr -d '.')
%define release_suffix      %{rpm_release}debian%{debian_vernum}kde%{kde_vernum}
%define distro              Debian Linux %{debian_version}
%define is_rpm_distro 0
%endif


# get current folder (or use ${RPM_SOURCE_DIR} ??)
%define curdir %(pwd)



# Package meta data
Summary:        MSN Messenger Client for KDE
Name:           kmess
Version:        %{kmess_version}
Release:        %{release_suffix}
Source:         kmess-%{kmess_tar_version}.tar.gz
#Source:         http://osdn.dl.sourceforge.net/sourceforge/kmess/kmess-%{kmess_tar_version}.tar.gz
URL:            http://kmess.sourceforge.net/
Group:          Networking/Instant Messaging
Packager:       Diederik van der Boor <vdboor --at-- codingdomain.com>
License:        GPL
Distribution:   %distro


## -- package build configuration

BuildRoot:      %{_tmppath}/build-kmess-%{kmess_version}
AutoReqProv:    no

%if %is_suse
#Requires:       kdelibs3 >= %{kde_major_version}.0
Requires:       kdelibs3 >= %{kde_major_version}.0, kdelibs3 < %{kde_major_version}.999
Requires:       qt3, libstdc++
BuildRequires:  kdelibs3 >= 3.1.0, kdelibs3-devel >= 3.1.0
BuildRequires:  gcc-c++, libstdc++-devel, autoconf, automake, libtool, make, pkgconfig
%endif



%description
KMess is a MSN Messenger client for Linux. It enables Linux
users to chat with friends online who are using MSN Messenger
in Windows or Mac OS. The strength of KMess is it's integration
with the KDE desktop environment, focus on MSN Messenger specific
features and an easy-to-use interface.

Authors:
--------
    Mike K. Bennett       <mkb137 --at-- users.sourceforge.net>
    Michael Curtis        <mdcurtis --at-- users.sourceforge.net>
    Jan Toenjes           <jan.toenjes --at-- web.de>
    Diederik van der Boor <vdboor --at-- codingdomain.com>
    Richard Conway        <richardconway --at-- users.sourceforge.net>
    Valerio Pilo          <amroth --at-- coldshock.net>

%prep
# ------ Configure ------ #


# install check, otherwise the package version is incorrect.
set +x
if test -z "%kde_vernum"; then
  echo "" >&2
  echo "" >&2
  echo "       ------------------------------------" >&2
  echo "        KDE version could not be detected! "  >&2
  echo "        Package building will not continue." >&2
  echo "       ------------------------------------" >&2
  echo "" >&2
  echo "  Please run rpmbuild as normal user or run rpmbuild as:" >&2
  echo "  PATH=\$PATH:/path/to/kde rpmbuild -tb kmess-%{kmess_tar_version}.tar.gz"
  echo "" >&2
  echo "" >&2
  echo "" >&2
  exit 1
fi

# Be verbose
set +x; echo -e "\n\nStarting build for KMess package..."; # set -x
set +x; echo -e "\n\n\033[1;34mExtracting files...\033[0m\n"; set -x

# Extract the files
%setup -q -n "kmess-%{kmess_tar_version}"


%if %has_apgcc
  # Be verbose
  set +x; echo -e "\n\n\033[1;34mStarting configure...\033[0m\n\nAutopackage compiler detected, using apg++ to compile %{name}.\n"; set -x
  # use same settings as autopackage/default.apspec uses
  export APBUILD_BOGUS_DEPS='art_lgpl art_lgpl_2 dl expat fontconfig freetype GL ICE idn kdefx kdesu kwalletclient m nsl png pthread resolv SM util X11 Xcursor Xft Xi Xinerama Xmu Xrandr Xrender'
  export APBUILD_STATIC='Xrender Xext Xss'
  CC=apgcc \
  CXX=apg++ \
%else
  # Be verbose again
  set +x; echo -e "\n\n\033[1;34mStarting configure...\033[0m\n"; set -x
%endif
%if %with_debug
  CFLAGS="${RPM_OPT_FLAGS} -O0 -g -ggdb" \
  CXXFLAGS="${RPM_OPT_FLAGS} -O0 -g -ggdb" \
%else
  CFLAGS="${RPM_OPT_FLAGS}" \
  CXXFLAGS="${RPM_OPT_FLAGS}" \
%endif
./configure \
%if %with_debug
    --enable-debug
%else
    --disable-debug
%endif



%build
# ------ make ------ #

# Be verbose again
set +x; echo -e "\n\n\033[1;34mStarting make...\033[0m\n"; set -x

# Setup for parallel builds (no cpus + 1)
numprocs=`egrep -c ^cpu[0-9]+ /proc/stat || :`
if [ -z "$numprocs" -o "$numprocs" = "0" ]; then
  numprocs=1
fi

# Start make
%{__make} -j$numprocs



%install
# ------ make install ------ #

# Be verbose again
set +x; echo -e "\n\n\033[1;34mStarting make install...\033[0m\n"; set -x

# Remove old build root
%{__rm} -rf "${RPM_BUILD_ROOT}"
mkdir "${RPM_BUILD_ROOT}"  # required by some distro's, slackware for always builds in /usr/src/rpms/BUILD

# # for testing:
# mkdir -p ${RPM_BUILD_ROOT}/usr/bin/
# cp %(kde-config --prefix)/bin/kmess ${RPM_BUILD_ROOT}/usr/bin/kmess
# echo "install-strip:" > Makefile

# Install in build root
%if %with_debug
  %{__make} DESTDIR="${RPM_BUILD_ROOT}" install
%else
  %{__make} DESTDIR="${RPM_BUILD_ROOT}" install-strip
%endif

# Add package description file for slackware
%if %is_slackware
  mkdir "${RPM_BUILD_ROOT}/install"
  cat <<"END" > "${RPM_BUILD_ROOT}/install/slack-desc"
# Slackware package description file.
     |-----handy-ruler------------------------------------------------------|
%{name}: KMess %{kmess_version} MSN Messenger Client for KDE
%{name}:
%{name}: KMess is a MSN Messenger client for Linux. It enables Linux
%{name}: users to chat with friends online who are using MSN Messenger
%{name}: in Windows or Mac OS. The strength of KMess is it's integration
%{name}: with the KDE desktop environment, focus on MSN Messenger specific
%{name}: features and an easy-to-use interface.
%{name}: 
%{name}: Package Created By: KMess development team
%{name}: 
END
%endif
##' fix syntax for vim

# Add package description file for debian
%if %is_debian
  mkdir "${RPM_BUILD_ROOT}/DEBIAN"
  cat <<"END" > "${RPM_BUILD_ROOT}/DEBIAN/control"
Package: %{name}
Version: %{version}
Section: kde
Priority: optional
Architecture: i386
Depends: kdelibs4 (>=4:%{kde_major_version}.0)
Maintainer: The KMess Developers
Description: KMess is a MSN Messenger client for KDE.
 .
 It enables Linux users to chat with friends online
 who are using MSN Messenger in Windows or Mac OS.
 The strength of KMess is it's integration with the
 KDE desktop environment, focus on MSN Messenger
 specific features and an easy-to-use interface.
END
##' fix syntax for vim
  cat <<"END" > "${RPM_BUILD_ROOT}/DEBIAN/changelog"
kmess (%{version}-1) unstable; urgency=low

  * Debian package build with rpmbuild

 -- Diederik van der Boor <vdboor@codingdomain.com>  %(date --rfc-2822)
END
echo "%{doc_files}" | tr ' ' '\n' > "${RPM_BUILD_ROOT}/DEBIAN/docs"
%endif


# Build the .deb package from the RPM build root
%if %is_debian
%define deb_filename %{curdir}/%{name}_%{version}-%{release}_i386.deb
  set +x; echo -e "\n\n\033[1;34mBuilding Debian package...\033[0m\n"; set -x
  dpkg-deb --build "${RPM_BUILD_ROOT}" "%{deb_filename}"
%endif


# Build the .tgz package from the RPM build root
%if %is_slackware
%define slack_filename %{curdir}/kmess-%{version}-%{_target_cpu}-%{release_suffix}.tgz
  set +x; echo -e "\n\n\033[1;34mBuilding Slackware package...\033[0m\n"; set -x
  cd "$RPM_BUILD_ROOT"
  makepkg --linkadd y --chown y "%{slack_filename}"
%endif


# Install done Build a file list for %files
# This is done after 'makepkg --linkadd y' because RPM complains otherwise in Slackware.
cd "$RPM_BUILD_ROOT"
find . -type d | sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,' > "$RPM_BUILD_DIR/file.list.kmess"
find . -type f | sed 's,^\.,\%attr(-\,root\,root) ,' >> "$RPM_BUILD_DIR/file.list.kmess"
%if %is_rpm_distro
find . -type l | sed 's,^\.,\%attr(-\,root\,root) ,' >> "$RPM_BUILD_DIR/file.list.kmess"
%endif

# not using %{_arch} here, because that's always i386
%define rpm_filename %{_rpmdir}/%{_target_cpu}/%{name}-%{version}-%{release}.%{_target_cpu}.rpm

%if %is_rpm_distro
  set +x
  echo -e "\n\n\033[1;34mCollecting file list for RPM package...\033[0m\n"
  cat "$RPM_BUILD_DIR/file.list.kmess"
  set -x
  echo -e "\n\n\033[1;34mBuilding RPM package...\033[0m\n"; set -x
%endif



%clean
# ------ finishing build ------ #

# clean up temporary folders
%{__rm} -rf "${RPM_BUILD_ROOT}"
%{__rm} -rf "${RPM_BUILD_DIR}/%{name}-%{version}/"
%{__rm} -f  "$RPM_BUILD_DIR/file.list.kmess"

# Disable command displaying
set +x

# Display the filename that was created
%if %is_rpm_distro
  echo -e "\n\n\033[1;34mThe following package was created:\033[0m\n\n  %{rpm_filename}\n\n"
%endif

%if %is_slackware
  %{__rm} -f  "%{rpm_filename}"
  echo -e "\n\n\033[1;34mThe following package was created:\033[0m\n\n  %{slack_filename}\n\n"
%endif

%if %is_debian
  %{__rm} -f  "%{rpm_filename}"
  echo -e "\n\n\033[1;34mThe following package was created:\\033[0mn\n  %{deb_filename}\n\n"
%endif



# ------ files to build, changelog to include ------ #

%files -f ../file.list.kmess
%doc ChangeLog %{doc_files}


# Use `date +"%a %b %d %Y"`
%changelog
* Wed May 11 2005 Diederik van der Boor <vdboor --at-- codingdomain.com>
- Updated dependencies
- Fixed slackware building support

* Sun May 08 2005 Diederik van der Boor <vdboor --at-- codingdomain.com> 1.4pre1
- new package

