/***************************************************************************
                          contactaction.h  -  description
                             -------------------
    begin                : Wed Jan 22 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTACTACTION_H
#define CONTACTACTION_H

#include <qwidget.h>
#include <kaction.h>

// Forward declarations
class Contact;
class KPopupMenu;

/**
 * @brief Menu actions to invite contacts.
 * @author Mike K. Bennett
 */
class ContactAction : public KAction
{
  Q_OBJECT

  public:
    // The constructor
  	                 ContactAction(const Contact *contact, KPopupMenu *menu, QWidget *parent=0, const char *name=0);
    // The destructor
  	                ~ContactAction();
    // Return the contact's handle
    const QString    getHandle() const;
    // Set whether or not the contact is in the chat
    void             setInChat( bool inChat );

  private: // Private methods

  private slots: // Private slots
    //Inherit from KAction...
    void             slotActivated();
    // Update the text based on the contact's name
    void             updateText();
    // Update the visibility of the action based on the contact's status, group, and list
    void             updateVisibility();

  private: // Private attributes
    // The contact
    const Contact   *contact_;
    // Whether or not the contact is in the chat
    bool             inChat_;
    // The menu into which the action is inserted
    KPopupMenu      *menu_;
    // Whether or not the contact has been plugged into the menu
    bool             plugged_;

  signals: // Public signals
    // Signal the contact's friendly name when the action is selected
    void             activated(QString handle);

};

#endif
