/***************************************************************************
                          awaymessagedialog.cpp  -  description
                             -------------------
    begin                : Sat Dec 14 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "awaymessagedialog.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qtextedit.h>

#include <klocale.h>

// The constructor
AwayMessageDialog::AwayMessageDialog(QWidget *parent, const char *name )
: KDialogBase( parent, name, false, i18n("Specify an Away message"), Ok | Cancel, Ok, true )
{
  setInitialSize( configDialogSize("AwayMessageDialog") );

  QWidget *page = new QWidget( this );
  setMainWidget( page );

  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );

  QLabel *infoLabel = new QLabel( i18n( "Enter the message that will automatically be\nsent to people who try to message you:" ), page, "info" );
  topLayout->addWidget( infoLabel );

  messageEdit_ = new QTextEdit( page, "messageEdit" );
  messageEdit_->setMinimumWidth( fontMetrics().maxWidth()*20 );
  topLayout->addWidget( messageEdit_ );

  topLayout->addStretch( 10 );

  adjustSize();
}



// The destructor
AwayMessageDialog::~AwayMessageDialog()
{
}



// Show the dialog
bool AwayMessageDialog::useMessage(QString &message)
{
  // Set whether the "ok" button was pressed to false
  ok_ = false;
  // Set the given mesage name to the text edit as the default message
  messageEdit_->setText( message );
  // Exec the form (to show it modally).
  exec();
  // If OK was pressed...
  if ( ok_ )
  {
    // Get the group name from the text edit and store it
    message = messageEdit_->text();
  }
  return ok_;
}



// The Cancel button was pressed.
void AwayMessageDialog::slotCancel()
{
  saveDialogSize("AwayMessageDialog");
  reject();
}



// The OK button was pressed.
void AwayMessageDialog::slotOk()
{
  saveDialogSize("AwayMessageDialog");
  ok_ = true;
  accept();
}

#include "awaymessagedialog.moc"
